/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.dbcp2.TestConnectionPool;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.junit.Assert;

public class TestPoolingDataSource
extends TestConnectionPool {
    protected PoolingDataSource<PoolableConnection> ds = null;
    private GenericObjectPool<PoolableConnection> pool = null;

    public TestPoolingDataSource(String testName) {
        super(testName);
    }

    @Override
    protected Connection getConnection() throws Exception {
        return this.ds.getConnection();
    }

    public void setUp() throws Exception {
        super.setUp();
        Properties props = new Properties();
        props.setProperty("user", "username");
        props.setProperty("password", "password");
        PoolableConnectionFactory factory = new PoolableConnectionFactory((ConnectionFactory)new DriverConnectionFactory((Driver)new TesterDriver(), "jdbc:apache:commons:testdriver", props), null);
        factory.setValidationQuery("SELECT DUMMY FROM DUAL");
        factory.setDefaultReadOnly(Boolean.TRUE);
        factory.setDefaultAutoCommit(Boolean.TRUE);
        this.pool = new GenericObjectPool((PooledObjectFactory)factory);
        factory.setPool(this.pool);
        this.pool.setMaxTotal(this.getMaxTotal());
        this.pool.setMaxWaitMillis(this.getMaxWaitMillis());
        this.ds = new PoolingDataSource(this.pool);
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
    }

    @Override
    public void tearDown() throws Exception {
        this.pool.close();
        super.tearDown();
    }

    public void testPoolGuardConnectionWrapperEqualsSameDelegate() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
        }
        ((DelegatingConnection)c[0]).getDelegate().close();
        Connection con = this.newConnection();
        Assert.assertNotEquals((Object)c[0], (Object)con);
        Assert.assertEquals((Object)((DelegatingConnection)c[0]).getInnermostDelegateInternal(), (Object)((DelegatingConnection)con).getInnermostDelegateInternal());
        for (Connection element : c) {
            element.close();
        }
    }

    public void testPoolGuardConnectionWrapperEqualsReflexive() throws Exception {
        Connection con;
        Connection con2 = con = this.ds.getConnection();
        TestPoolingDataSource.assertTrue((boolean)con2.equals(con));
        TestPoolingDataSource.assertTrue((boolean)con.equals(con2));
        con.close();
    }

    public void testPoolGuardConnectionWrapperEqualsFail() throws Exception {
        Connection con1 = this.ds.getConnection();
        Connection con2 = this.ds.getConnection();
        TestPoolingDataSource.assertFalse((boolean)con1.equals(con2));
        con1.close();
        con2.close();
    }

    public void testPoolGuardConnectionWrapperEqualsNull() throws Exception {
        Connection con1 = this.ds.getConnection();
        Object con2 = null;
        TestPoolingDataSource.assertFalse((boolean)con1.equals(con2));
        con1.close();
    }

    public void testPoolGuardConnectionWrapperEqualsType() throws Exception {
        Connection con1 = this.ds.getConnection();
        Integer con2 = 0;
        TestPoolingDataSource.assertFalse((boolean)con1.equals(con2));
        con1.close();
    }

    public void testestPoolGuardConnectionWrapperEqualInnermost() throws Exception {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        DelegatingConnection con = (DelegatingConnection)this.ds.getConnection();
        Connection inner = con.getInnermostDelegate();
        this.ds.setAccessToUnderlyingConnectionAllowed(false);
        DelegatingConnection con2 = new DelegatingConnection(inner);
        TestPoolingDataSource.assertFalse((boolean)con2.equals(con));
        TestPoolingDataSource.assertTrue((boolean)con.innermostDelegateEquals(con2.getInnermostDelegate()));
        TestPoolingDataSource.assertTrue((boolean)con2.innermostDelegateEquals(inner));
        TestPoolingDataSource.assertFalse((boolean)con.equals(con2));
    }

    public void testFixFactoryConfig() throws Exception {
        Properties props = new Properties();
        props.setProperty("user", "username");
        props.setProperty("password", "password");
        PoolableConnectionFactory f = new PoolableConnectionFactory((ConnectionFactory)new DriverConnectionFactory((Driver)new TesterDriver(), "jdbc:apache:commons:testdriver", props), null);
        f.setValidationQuery("SELECT DUMMY FROM DUAL");
        f.setDefaultReadOnly(Boolean.TRUE);
        f.setDefaultAutoCommit(Boolean.TRUE);
        GenericObjectPool p = new GenericObjectPool((PooledObjectFactory)f);
        p.setMaxTotal(this.getMaxTotal());
        p.setMaxWaitMillis(this.getMaxWaitMillis());
        this.ds = new PoolingDataSource((ObjectPool)p);
        TestPoolingDataSource.assertTrue((boolean)f.getPool().equals(p));
        this.ds.getConnection();
    }
}

