/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import junit.framework.TestCase;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.PoolingConnection;
import org.apache.commons.dbcp2.TesterConnection;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;

public class TestDelegatingConnection
extends TestCase {
    private DelegatingConnection<? extends Connection> conn = null;
    private Connection delegateConn = null;
    private Connection delegateConn2 = null;

    public TestDelegatingConnection(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        this.delegateConn = new TesterConnection("test", "test");
        this.delegateConn2 = new TesterConnection("test", "test");
        this.conn = new DelegatingConnection(this.delegateConn);
    }

    public void testGetDelegate() throws Exception {
        TestDelegatingConnection.assertEquals((Object)this.delegateConn, (Object)this.conn.getDelegate());
    }

    public void testConnectionToString() throws Exception {
        String s = this.conn.toString();
        TestDelegatingConnection.assertNotNull((Object)s);
        TestDelegatingConnection.assertTrue((s.length() > 0 ? 1 : 0) != 0);
    }

    public void testCheckOpen() throws Exception {
        this.conn.checkOpen();
        this.conn.close();
        try {
            this.conn.checkOpen();
            TestDelegatingConnection.fail((String)"Expecting SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCheckOpenNull() throws Exception {
        try {
            this.conn.close();
            this.conn.checkOpen();
            TestDelegatingConnection.fail((String)"Expecting SQLException");
        }
        catch (SQLException ex) {
            TestDelegatingConnection.assertTrue((boolean)ex.getMessage().endsWith("is closed."));
        }
        try {
            this.conn = new DelegatingConnection(null);
            this.conn.setClosedInternal(true);
            this.conn.checkOpen();
            TestDelegatingConnection.fail((String)"Expecting SQLException");
        }
        catch (SQLException ex) {
            TestDelegatingConnection.assertTrue((boolean)ex.getMessage().endsWith("is null."));
        }
        try {
            PoolingConnection pc = new PoolingConnection(this.delegateConn2);
            pc.setStatementPool((KeyedObjectPool)new GenericKeyedObjectPool((KeyedPooledObjectFactory)pc));
            this.conn = new DelegatingConnection((Connection)pc);
            pc.close();
            this.conn.close();
            PreparedStatement ps = this.conn.prepareStatement("");
            Throwable throwable = null;
            if (ps != null) {
                if (throwable != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    ps.close();
                }
            }
            TestDelegatingConnection.fail((String)"Expecting SQLException");
        }
        catch (SQLException ex) {
            TestDelegatingConnection.assertTrue((boolean)ex.getMessage().endsWith("is closed."));
        }
        try {
            this.conn = new DelegatingConnection((Connection)new RTEGeneratingConnection());
            this.conn.close();
            this.conn.checkOpen();
            TestDelegatingConnection.fail((String)"Expecting SQLException");
        }
        catch (SQLException ex) {
            TestDelegatingConnection.assertTrue((boolean)ex.getMessage().endsWith("is closed."));
        }
    }

    static class RTEGeneratingConnection
    extends TesterConnection {
        public RTEGeneratingConnection() {
            super("", "");
        }

        public String toString() {
            throw new RuntimeException("bang!");
        }
    }
}

