/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Random;
import java.util.Stack;
import junit.framework.TestCase;
import org.apache.commons.dbcp2.DelegatingConnection;

public abstract class TestConnectionPool
extends TestCase {
    protected Stack<Connection> connections = new Stack();
    private static final boolean DISPLAY_THREAD_DETAILS = Boolean.valueOf(System.getProperty("TestConnectionPool.display.thread.details", "false"));
    private static int currentThreadCount = 0;
    private static final String DONE = "Done";

    public TestConnectionPool(String testName) {
        super(testName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        super.tearDown();
        while (!this.connections.isEmpty()) {
            Connection conn = this.connections.pop();
            try {
                conn.close();
            }
            catch (Exception exception) {}
            continue;
            finally {
                conn = null;
            }
        }
    }

    protected abstract Connection getConnection() throws Exception;

    protected int getMaxTotal() {
        return 10;
    }

    protected long getMaxWaitMillis() {
        return 100L;
    }

    protected Connection newConnection() throws Exception {
        Connection connection = this.getConnection();
        this.connections.push(connection);
        return connection;
    }

    protected String getUsername(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("select username");
        if (rs.next()) {
            return rs.getString(1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClearWarnings() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
            TestConnectionPool.assertTrue((c[i] != null ? 1 : 0) != 0);
            CallableStatement cs = c[i].prepareCall("warning");
            Throwable throwable = null;
            if (cs == null) continue;
            if (throwable != null) {
                try {
                    cs.close();
                }
                catch (Throwable x2) {
                    throwable.addSuppressed(x2);
                }
                continue;
            }
            cs.close();
        }
        for (Connection element : c) {
            TestConnectionPool.assertNotNull((Object)element.getWarnings());
        }
        for (Connection element : c) {
            element.close();
        }
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
        }
        for (Connection element : c) {
            TestConnectionPool.assertNull((Object)element.getWarnings());
        }
        for (Connection element : c) {
            element.close();
        }
    }

    public void testIsClosed() throws Exception {
        for (int i = 0; i < this.getMaxTotal(); ++i) {
            Connection conn = this.newConnection();
            TestConnectionPool.assertNotNull((Object)conn);
            TestConnectionPool.assertTrue((!conn.isClosed() ? 1 : 0) != 0);
            PreparedStatement stmt = conn.prepareStatement("select * from dual");
            TestConnectionPool.assertNotNull((Object)stmt);
            ResultSet rset = stmt.executeQuery();
            TestConnectionPool.assertNotNull((Object)rset);
            TestConnectionPool.assertTrue((boolean)rset.next());
            rset.close();
            stmt.close();
            conn.close();
            TestConnectionPool.assertTrue((boolean)conn.isClosed());
        }
    }

    public void testCanCloseConnectionTwice() throws Exception {
        for (int i = 0; i < this.getMaxTotal(); ++i) {
            Connection conn = this.newConnection();
            TestConnectionPool.assertNotNull((Object)conn);
            TestConnectionPool.assertTrue((!conn.isClosed() ? 1 : 0) != 0);
            conn.close();
            TestConnectionPool.assertTrue((boolean)conn.isClosed());
            conn.close();
            TestConnectionPool.assertTrue((boolean)conn.isClosed());
        }
    }

    public void testCanCloseStatementTwice() throws Exception {
        Connection conn = this.newConnection();
        TestConnectionPool.assertNotNull((Object)conn);
        TestConnectionPool.assertTrue((!conn.isClosed() ? 1 : 0) != 0);
        for (int i = 0; i < 2; ++i) {
            Statement stmt = conn.createStatement();
            TestConnectionPool.assertNotNull((Object)stmt);
            TestConnectionPool.assertFalse((boolean)this.isClosed(stmt));
            stmt.close();
            TestConnectionPool.assertTrue((boolean)this.isClosed(stmt));
            stmt.close();
            TestConnectionPool.assertTrue((boolean)this.isClosed(stmt));
            stmt.close();
            TestConnectionPool.assertTrue((boolean)this.isClosed(stmt));
        }
        conn.close();
    }

    public void testCanClosePreparedStatementTwice() throws Exception {
        Connection conn = this.newConnection();
        TestConnectionPool.assertNotNull((Object)conn);
        TestConnectionPool.assertTrue((!conn.isClosed() ? 1 : 0) != 0);
        for (int i = 0; i < 2; ++i) {
            PreparedStatement stmt = conn.prepareStatement("select * from dual");
            TestConnectionPool.assertNotNull((Object)stmt);
            TestConnectionPool.assertFalse((boolean)this.isClosed(stmt));
            stmt.close();
            TestConnectionPool.assertTrue((boolean)this.isClosed(stmt));
            stmt.close();
            TestConnectionPool.assertTrue((boolean)this.isClosed(stmt));
            stmt.close();
            TestConnectionPool.assertTrue((boolean)this.isClosed(stmt));
        }
        conn.close();
    }

    public void testCanCloseCallableStatementTwice() throws Exception {
        Connection conn = this.newConnection();
        TestConnectionPool.assertNotNull((Object)conn);
        TestConnectionPool.assertTrue((!conn.isClosed() ? 1 : 0) != 0);
        for (int i = 0; i < 2; ++i) {
            CallableStatement stmt = conn.prepareCall("select * from dual");
            TestConnectionPool.assertNotNull((Object)stmt);
            TestConnectionPool.assertFalse((boolean)this.isClosed(stmt));
            stmt.close();
            TestConnectionPool.assertTrue((boolean)this.isClosed(stmt));
            stmt.close();
            TestConnectionPool.assertTrue((boolean)this.isClosed(stmt));
            stmt.close();
            TestConnectionPool.assertTrue((boolean)this.isClosed(stmt));
        }
        conn.close();
    }

    public void testCanCloseResultSetTwice() throws Exception {
        Connection conn = this.newConnection();
        TestConnectionPool.assertNotNull((Object)conn);
        TestConnectionPool.assertTrue((!conn.isClosed() ? 1 : 0) != 0);
        for (int i = 0; i < 2; ++i) {
            PreparedStatement stmt = conn.prepareStatement("select * from dual");
            TestConnectionPool.assertNotNull((Object)stmt);
            ResultSet rset = stmt.executeQuery();
            TestConnectionPool.assertNotNull((Object)rset);
            TestConnectionPool.assertFalse((boolean)this.isClosed(rset));
            rset.close();
            TestConnectionPool.assertTrue((boolean)this.isClosed(rset));
            rset.close();
            TestConnectionPool.assertTrue((boolean)this.isClosed(rset));
            rset.close();
            TestConnectionPool.assertTrue((boolean)this.isClosed(rset));
        }
        conn.close();
    }

    public void testBackPointers() throws Exception {
        Connection conn = this.newConnection();
        this.assertBackPointers(conn, conn.createStatement());
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.createStatement(0, 0));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.createStatement(0, 0, 0));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareStatement("select * from dual"));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareStatement("select * from dual", 0));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareStatement("select * from dual", 0, 0));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareStatement("select * from dual", 0, 0, 0));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareStatement("select * from dual", new int[0]));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareStatement("select * from dual", new String[0]));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareCall("select * from dual"));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareCall("select * from dual", 0, 0));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareCall("select * from dual", 0, 0, 0));
    }

    protected void assertBackPointers(Connection conn, Statement statement) throws SQLException {
        TestConnectionPool.assertFalse((boolean)conn.isClosed());
        TestConnectionPool.assertFalse((boolean)this.isClosed(statement));
        TestConnectionPool.assertSame((String)"statement.getConnection() should return the exact same connection instance that was used to create the statement", (Object)conn, (Object)statement.getConnection());
        ResultSet resultSet = statement.getResultSet();
        TestConnectionPool.assertFalse((boolean)this.isClosed(resultSet));
        TestConnectionPool.assertSame((String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set", (Object)statement, (Object)resultSet.getStatement());
        ResultSet executeResultSet = statement.executeQuery("select * from dual");
        TestConnectionPool.assertFalse((boolean)this.isClosed(executeResultSet));
        TestConnectionPool.assertSame((String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set", (Object)statement, (Object)executeResultSet.getStatement());
        ResultSet keysResultSet = statement.getGeneratedKeys();
        TestConnectionPool.assertFalse((boolean)this.isClosed(keysResultSet));
        TestConnectionPool.assertSame((String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set", (Object)statement, (Object)keysResultSet.getStatement());
        ResultSet preparedResultSet = null;
        if (statement instanceof PreparedStatement) {
            PreparedStatement preparedStatement = (PreparedStatement)statement;
            preparedResultSet = preparedStatement.executeQuery();
            TestConnectionPool.assertFalse((boolean)this.isClosed(preparedResultSet));
            TestConnectionPool.assertSame((String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set", (Object)statement, (Object)preparedResultSet.getStatement());
        }
        resultSet.getStatement().getConnection().close();
        TestConnectionPool.assertTrue((boolean)conn.isClosed());
        TestConnectionPool.assertTrue((boolean)this.isClosed(statement));
        TestConnectionPool.assertTrue((boolean)this.isClosed(resultSet));
        TestConnectionPool.assertTrue((boolean)this.isClosed(executeResultSet));
        TestConnectionPool.assertTrue((boolean)this.isClosed(keysResultSet));
        if (preparedResultSet != null) {
            TestConnectionPool.assertTrue((boolean)this.isClosed(preparedResultSet));
        }
    }

    public void testSimple() throws Exception {
        Connection conn = this.newConnection();
        TestConnectionPool.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        TestConnectionPool.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        TestConnectionPool.assertNotNull((Object)rset);
        TestConnectionPool.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
    }

    public void testRepeatedBorrowAndReturn() throws Exception {
        for (int i = 0; i < 100; ++i) {
            Connection conn = this.newConnection();
            TestConnectionPool.assertNotNull((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("select * from dual");
            TestConnectionPool.assertNotNull((Object)stmt);
            ResultSet rset = stmt.executeQuery();
            TestConnectionPool.assertNotNull((Object)rset);
            TestConnectionPool.assertTrue((boolean)rset.next());
            rset.close();
            stmt.close();
            conn.close();
        }
    }

    public void testSimple2() throws Exception {
        Connection conn = this.newConnection();
        TestConnectionPool.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        TestConnectionPool.assertNotNull((Object)stmt);
        Object rset = stmt.executeQuery();
        TestConnectionPool.assertNotNull((Object)rset);
        TestConnectionPool.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = conn.prepareStatement("select * from dual");
        TestConnectionPool.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        TestConnectionPool.assertNotNull((Object)rset);
        TestConnectionPool.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
        try {
            Statement s = conn.createStatement();
            rset = null;
            try {
                TestConnectionPool.fail((String)"Can't use closed connections");
            }
            catch (Throwable throwable) {
                rset = throwable;
                throw throwable;
            }
            finally {
                if (s != null) {
                    if (rset != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable x2) {
                            ((Throwable)rset).addSuppressed(x2);
                        }
                    } else {
                        s.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        conn = this.newConnection();
        TestConnectionPool.assertNotNull((Object)conn);
        stmt = conn.prepareStatement("select * from dual");
        TestConnectionPool.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        TestConnectionPool.assertNotNull((Object)rset);
        TestConnectionPool.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = conn.prepareStatement("select * from dual");
        TestConnectionPool.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        TestConnectionPool.assertNotNull((Object)rset);
        TestConnectionPool.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
        conn = null;
    }

    public void testPooling() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        Connection[] u = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
            if (!(c[i] instanceof DelegatingConnection)) {
                for (int j = 0; j <= i; ++j) {
                    c[j].close();
                }
                return;
            }
            u[i] = ((DelegatingConnection)c[i]).getInnermostDelegate();
        }
        for (Connection element : c) {
            element.close();
            Connection con = this.newConnection();
            Connection underCon = ((DelegatingConnection)con).getInnermostDelegate();
            TestConnectionPool.assertTrue((String)"Failed to get connection", (underCon != null ? 1 : 0) != 0);
            boolean found = false;
            for (int j = 0; j < c.length; ++j) {
                if (underCon != u[j]) continue;
                found = true;
                break;
            }
            TestConnectionPool.assertTrue((String)"New connection not from pool", (boolean)found);
            con.close();
        }
    }

    public void testAutoCommitBehavior() throws Exception {
        Connection conn0 = this.newConnection();
        TestConnectionPool.assertNotNull((String)"connection should not be null", (Object)conn0);
        TestConnectionPool.assertTrue((String)"autocommit should be true for conn0", (boolean)conn0.getAutoCommit());
        Connection conn1 = this.newConnection();
        TestConnectionPool.assertTrue((String)"autocommit should be true for conn1", (boolean)conn1.getAutoCommit());
        conn1.close();
        TestConnectionPool.assertTrue((String)"autocommit should be true for conn0", (boolean)conn0.getAutoCommit());
        conn0.setAutoCommit(false);
        TestConnectionPool.assertFalse((String)"autocommit should be false for conn0", (boolean)conn0.getAutoCommit());
        conn0.close();
        Connection conn2 = this.newConnection();
        TestConnectionPool.assertTrue((String)"autocommit should be true for conn2", (boolean)conn2.getAutoCommit());
        Connection conn3 = this.newConnection();
        TestConnectionPool.assertTrue((String)"autocommit should be true for conn3", (boolean)conn3.getAutoCommit());
        conn2.close();
        conn3.close();
    }

    public void testConnectionsAreDistinct() throws Exception {
        Connection[] conn = new Connection[this.getMaxTotal()];
        for (int i = 0; i < conn.length; ++i) {
            conn[i] = this.newConnection();
            for (int j = 0; j < i; ++j) {
                TestConnectionPool.assertTrue((conn[j] != conn[i] ? 1 : 0) != 0);
                TestConnectionPool.assertTrue((!conn[j].equals(conn[i]) ? 1 : 0) != 0);
            }
        }
        for (Connection element : conn) {
            element.close();
        }
    }

    public void testOpening() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
            TestConnectionPool.assertTrue((c[i] != null ? 1 : 0) != 0);
            for (int j = 0; j <= i; ++j) {
                TestConnectionPool.assertTrue((!c[j].isClosed() ? 1 : 0) != 0);
            }
        }
        for (Connection element : c) {
            element.close();
        }
    }

    public void testClosing() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
        }
        c[0].close();
        TestConnectionPool.assertTrue((boolean)c[0].isClosed());
        c[0] = this.newConnection();
        for (Connection element : c) {
            element.close();
        }
    }

    public void testMaxTotal() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
            TestConnectionPool.assertTrue((c[i] != null ? 1 : 0) != 0);
        }
        try {
            this.newConnection();
            TestConnectionPool.fail((String)"Allowed to open more than DefaultMaxTotal connections.");
        }
        catch (SQLException e) {
            // empty catch block
        }
        for (Connection element : c) {
            element.close();
        }
    }

    public void testHashing() throws Exception {
        Connection con = this.getConnection();
        Hashtable<Connection, String> hash = new Hashtable<Connection, String>();
        hash.put(con, "test");
        TestConnectionPool.assertEquals((String)"test", (String)((String)hash.get(con)));
        TestConnectionPool.assertTrue((boolean)hash.containsKey(con));
        TestConnectionPool.assertTrue((boolean)hash.contains("test"));
        hash.clear();
        con.close();
    }

    public void testThreaded() {
        int i;
        TestThread[] threads = new TestThread[this.getMaxTotal()];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new TestThread(50, 50);
            Thread t = new Thread(threads[i]);
            t.start();
        }
        for (i = 0; i < threads.length; ++i) {
            while (!threads[i].complete()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            if (threads[i] == null || !threads[i].failed()) continue;
            TestConnectionPool.fail((String)("Thread failed: " + i));
        }
    }

    public void testPrepareStatementOptions() throws Exception {
        Connection conn = this.newConnection();
        TestConnectionPool.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual", 1005, 1008);
        TestConnectionPool.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        TestConnectionPool.assertNotNull((Object)rset);
        TestConnectionPool.assertTrue((boolean)rset.next());
        TestConnectionPool.assertEquals((int)1005, (int)rset.getType());
        TestConnectionPool.assertEquals((int)1008, (int)rset.getConcurrency());
        rset.close();
        stmt.close();
        conn.close();
    }

    public void testNoRsetClose() throws Exception {
        Connection conn = this.newConnection();
        TestConnectionPool.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("test");
        TestConnectionPool.assertNotNull((Object)stmt);
        ResultSet rset = stmt.getResultSet();
        TestConnectionPool.assertNotNull((Object)rset);
        stmt.close();
        conn.close();
    }

    public void testHashCode() throws Exception {
        Connection conn1 = this.newConnection();
        TestConnectionPool.assertNotNull((Object)conn1);
        Connection conn2 = this.newConnection();
        TestConnectionPool.assertNotNull((Object)conn2);
        TestConnectionPool.assertTrue((conn1.hashCode() != conn2.hashCode() ? 1 : 0) != 0);
    }

    protected boolean isClosed(Statement statement) {
        try {
            statement.getWarnings();
            return false;
        }
        catch (SQLException e) {
            return true;
        }
    }

    protected boolean isClosed(ResultSet resultSet) {
        try {
            resultSet.getWarnings();
            return false;
        }
        catch (SQLException e) {
            return true;
        }
    }

    protected void multipleThreads(int holdTime, boolean expectError, boolean loopOnce, long maxWaitMillis) throws Exception {
        this.multipleThreads(holdTime, expectError, loopOnce, maxWaitMillis, 1, 2 * this.getMaxTotal(), 300L);
    }

    protected void multipleThreads(int holdTime, boolean expectError, boolean loopOnce, long maxWaitMillis, int numStatements, int numThreads, long duration) throws Exception {
        long startTime = this.timeStamp();
        final PoolTest[] pts = new PoolTest[numThreads];
        ThreadGroup threadGroup = new ThreadGroup("foo"){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                for (PoolTest pt : pts) {
                    pt.stop();
                }
            }
        };
        for (int i = 0; i < pts.length; ++i) {
            pts[i] = new PoolTest(threadGroup, holdTime, expectError, loopOnce, numStatements);
        }
        for (PoolTest pt : pts) {
            pt.start();
        }
        Thread.sleep(duration);
        for (PoolTest pt : pts) {
            pt.stop();
        }
        int done = 0;
        int failed = 0;
        int didNotRun = 0;
        int loops = 0;
        for (PoolTest poolTest : pts) {
            Throwable thrown;
            poolTest.thread.join();
            loops += poolTest.loops;
            String state = poolTest.state;
            if (DONE.equals(state)) {
                ++done;
            }
            if (poolTest.loops == 0) {
                ++didNotRun;
            }
            if ((thrown = poolTest.thrown) == null) continue;
            ++failed;
            if (expectError && thrown instanceof SQLException) continue;
            System.out.println("Unexpected error: " + thrown.getMessage());
        }
        long time = this.timeStamp() - startTime;
        System.out.println("Multithread test time = " + time + " ms. Threads: " + pts.length + ". Loops: " + loops + ". Hold time: " + holdTime + ". maxWaitMillis: " + maxWaitMillis + ". Done: " + done + ". Did not run: " + didNotRun + ". Failed: " + failed + ". expectError: " + expectError);
        if (expectError) {
            if (DISPLAY_THREAD_DETAILS || pts.length / 2 != failed) {
                long offset = pts[0].created - 1000L;
                System.out.println("Offset: " + offset);
                for (int i = 0; i < pts.length; ++i) {
                    PoolTest pt = pts[i];
                    System.out.println("Pre: " + (pt.preconnected - offset) + ". Post: " + (pt.postconnected != 0L ? Long.toString(pt.postconnected - offset) : "-") + ". Hash: " + pt.connHash + ". Startup: " + (pt.started - pt.created) + ". getConn(): " + (pt.connected != 0L ? Long.toString(pt.connected - pt.preconnected) : "-") + ". Runtime: " + (pt.ended - pt.started) + ". IDX: " + i + ". Loops: " + pt.loops + ". State: " + pt.state + ". thrown: " + pt.thrown + ".");
                }
            }
            if (didNotRun > 0) {
                System.out.println("NOTE: some threads did not run the code: " + didNotRun);
            }
            TestConnectionPool.assertTrue((String)"Expected some of the threads to fail", (failed > 0 ? 1 : 0) != 0);
            TestConnectionPool.assertEquals((String)"WARNING: Expected half the threads to fail", (int)(pts.length / 2), (int)(failed + didNotRun));
        } else {
            TestConnectionPool.assertEquals((String)"Did not expect any threads to fail", (int)0, (int)failed);
        }
    }

    long timeStamp() {
        return System.currentTimeMillis();
    }

    protected class PoolTest
    implements Runnable {
        private final int connHoldTime;
        private final int numStatements;
        private volatile boolean isRun;
        private String state;
        private final Thread thread;
        private Throwable thrown;
        private final Random random = new Random();
        private final long created;
        private long started;
        private long ended;
        private long preconnected;
        private long connected;
        private long postconnected;
        private int loops = 0;
        private int connHash = 0;
        private final boolean stopOnException;
        private final boolean loopOnce;

        public PoolTest(ThreadGroup threadGroup, int connHoldTime, boolean isStopOnException) {
            this(threadGroup, connHoldTime, isStopOnException, false, 1);
        }

        public PoolTest(ThreadGroup threadGroup, int connHoldTime, boolean isStopOnException, int numStatements) {
            this(threadGroup, connHoldTime, isStopOnException, false, numStatements);
        }

        private PoolTest(ThreadGroup threadGroup, int connHoldTime, boolean isStopOnException, boolean once, int numStatements) {
            this.loopOnce = once;
            this.connHoldTime = connHoldTime;
            this.stopOnException = isStopOnException;
            this.isRun = true;
            this.thrown = null;
            this.thread = new Thread(threadGroup, this, "Thread+" + currentThreadCount++);
            this.thread.setDaemon(false);
            this.created = TestConnectionPool.this.timeStamp();
            this.numStatements = numStatements;
        }

        public void start() {
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.started = TestConnectionPool.this.timeStamp();
            try {
                while (this.isRun) {
                    ++this.loops;
                    this.state = "Getting Connection";
                    this.preconnected = TestConnectionPool.this.timeStamp();
                    Connection conn = TestConnectionPool.this.getConnection();
                    this.connHash = System.identityHashCode(((DelegatingConnection)conn).getInnermostDelegate());
                    this.connected = TestConnectionPool.this.timeStamp();
                    this.state = "Using Connection";
                    TestCase.assertNotNull((Object)conn);
                    String sql = this.numStatements == 1 ? "select * from dual" : "select count " + this.random.nextInt(this.numStatements - 1);
                    PreparedStatement stmt = conn.prepareStatement(sql);
                    TestCase.assertNotNull((Object)stmt);
                    ResultSet rset = stmt.executeQuery();
                    TestCase.assertNotNull((Object)rset);
                    TestCase.assertTrue((boolean)rset.next());
                    this.state = "Holding Connection";
                    Thread.sleep(this.connHoldTime);
                    this.state = "Closing ResultSet";
                    rset.close();
                    this.state = "Closing Statement";
                    stmt.close();
                    this.state = "Closing Connection";
                    conn.close();
                    this.postconnected = TestConnectionPool.this.timeStamp();
                    this.state = "Closed";
                    if (!this.loopOnce) continue;
                    break;
                }
                this.state = TestConnectionPool.DONE;
            }
            catch (Throwable t) {
                this.thrown = t;
                if (!this.stopOnException) {
                    throw new RuntimeException();
                }
            }
            finally {
                this.ended = TestConnectionPool.this.timeStamp();
            }
        }

        public void stop() {
            this.isRun = false;
        }

        public Thread getThread() {
            return this.thread;
        }
    }

    class TestThread
    implements Runnable {
        Random _random = new Random();
        boolean _complete = false;
        boolean _failed = false;
        int _iter = 100;
        int _delay = 50;

        public TestThread() {
        }

        public TestThread(int iter) {
            this._iter = iter;
        }

        public TestThread(int iter, int delay) {
            this._iter = iter;
            this._delay = delay;
        }

        public boolean complete() {
            return this._complete;
        }

        public boolean failed() {
            return this._failed;
        }

        @Override
        public void run() {
            for (int i = 0; i < this._iter; ++i) {
                try {
                    Thread.sleep(this._random.nextInt(this._delay));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try (Connection conn = TestConnectionPool.this.newConnection();
                     PreparedStatement stmt = conn.prepareStatement("select 'literal', SYSDATE from dual");
                     ResultSet rset = stmt.executeQuery();){
                    try {
                        Thread.sleep(this._random.nextInt(this._delay));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this._failed = true;
                    this._complete = true;
                    break;
                }
            }
            this._complete = true;
        }
    }
}

