/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolingConnection;
import org.apache.commons.dbcp2.TestBasicDataSource;
import org.apache.commons.dbcp2.TesterConnection;
import org.apache.commons.dbcp2.TesterUtils;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.junit.Assert;

public class TestAbandonedBasicDataSource
extends TestBasicDataSource {
    public TestAbandonedBasicDataSource(String testName) {
        super(testName);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.ds.setLogAbandoned(true);
        this.ds.setRemoveAbandonedOnBorrow(true);
        this.ds.setRemoveAbandonedOnMaintenance(true);
        this.ds.setRemoveAbandonedTimeout(10000);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAbandoned() throws Exception {
        this.ds.setRemoveAbandonedTimeout(0);
        this.ds.setMaxTotal(1);
        for (int i = 0; i < 3; ++i) {
            TestAbandonedBasicDataSource.assertNotNull((Object)this.ds.getConnection());
        }
    }

    public void testAbandonedClose() throws Exception {
        this.ds.setRemoveAbandonedTimeout(0);
        this.ds.setMaxTotal(1);
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        Connection conn1 = this.getConnection();
        TestAbandonedBasicDataSource.assertNotNull((Object)conn1);
        TestAbandonedBasicDataSource.assertEquals((int)1, (int)this.ds.getNumActive());
        Connection conn2 = this.getConnection();
        TestAbandonedBasicDataSource.assertNotNull((Object)conn2);
        TestAbandonedBasicDataSource.assertEquals((int)1, (int)this.ds.getNumActive());
        TestAbandonedBasicDataSource.assertTrue((boolean)((DelegatingConnection)conn1).getInnermostDelegate().isClosed());
        conn2.close();
        TestAbandonedBasicDataSource.assertEquals((int)0, (int)this.ds.getNumActive());
        conn1.close();
        TestAbandonedBasicDataSource.assertEquals((int)0, (int)this.ds.getNumActive());
    }

    public void testAbandonedCloseWithExceptions() throws Exception {
        this.ds.setRemoveAbandonedTimeout(0);
        this.ds.setMaxTotal(1);
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        Connection conn1 = this.getConnection();
        TestAbandonedBasicDataSource.assertNotNull((Object)conn1);
        TestAbandonedBasicDataSource.assertEquals((int)1, (int)this.ds.getNumActive());
        Connection conn2 = this.getConnection();
        TestAbandonedBasicDataSource.assertNotNull((Object)conn2);
        TestAbandonedBasicDataSource.assertEquals((int)1, (int)this.ds.getNumActive());
        TesterConnection tconn1 = (TesterConnection)((DelegatingConnection)conn1).getInnermostDelegate();
        tconn1.setFailure(new IOException("network error"));
        TesterConnection tconn2 = (TesterConnection)((DelegatingConnection)conn2).getInnermostDelegate();
        tconn2.setFailure(new IOException("network error"));
        try {
            conn2.close();
        }
        catch (SQLException ex) {
            // empty catch block
        }
        TestAbandonedBasicDataSource.assertEquals((int)0, (int)this.ds.getNumActive());
        try {
            conn1.close();
        }
        catch (SQLException ex) {
            // empty catch block
        }
        TestAbandonedBasicDataSource.assertEquals((int)0, (int)this.ds.getNumActive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testlastUsed() throws Exception {
        this.ds.setRemoveAbandonedTimeout(1);
        this.ds.setMaxTotal(2);
        try (Connection conn1 = this.ds.getConnection();){
            Thread.sleep(500L);
            Statement s = conn1.createStatement();
            Throwable throwable = null;
            if (s != null) {
                if (throwable != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    s.close();
                }
            }
            Thread.sleep(800L);
            Connection conn2 = this.ds.getConnection();
            Statement s2 = conn1.createStatement();
            Throwable throwable2 = null;
            if (s2 != null) {
                if (throwable2 != null) {
                    try {
                        s2.close();
                    }
                    catch (Throwable x2) {
                        throwable2.addSuppressed(x2);
                    }
                } else {
                    s2.close();
                }
            }
            conn2.close();
            Thread.sleep(500L);
            PreparedStatement ps = conn1.prepareStatement("SELECT 1 FROM DUAL");
            throwable2 = null;
            if (ps != null) {
                if (throwable2 != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable x2) {
                        throwable2.addSuppressed(x2);
                    }
                } else {
                    ps.close();
                }
            }
            Thread.sleep(800L);
            Connection c = this.ds.getConnection();
            throwable2 = null;
            if (c != null) {
                if (throwable2 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable x2) {
                        throwable2.addSuppressed(x2);
                    }
                } else {
                    c.close();
                }
            }
            s2 = conn1.createStatement();
            throwable2 = null;
            if (s2 != null) {
                if (throwable2 != null) {
                    try {
                        s2.close();
                    }
                    catch (Throwable x2) {
                        throwable2.addSuppressed(x2);
                    }
                } else {
                    s2.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testlastUsedPrepareCall() throws Exception {
        this.ds.setRemoveAbandonedTimeout(1);
        this.ds.setMaxTotal(2);
        try (Connection conn1 = this.ds.getConnection();){
            Thread.sleep(500L);
            CallableStatement cs = conn1.prepareCall("{call home}");
            Throwable throwable = null;
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    cs.close();
                }
            }
            Thread.sleep(800L);
            Connection conn2 = this.ds.getConnection();
            CallableStatement cs2 = conn1.prepareCall("{call home}");
            Throwable throwable2 = null;
            if (cs2 != null) {
                if (throwable2 != null) {
                    try {
                        cs2.close();
                    }
                    catch (Throwable x2) {
                        throwable2.addSuppressed(x2);
                    }
                } else {
                    cs2.close();
                }
            }
            conn2.close();
            Thread.sleep(500L);
            cs2 = conn1.prepareCall("{call home}");
            throwable2 = null;
            if (cs2 != null) {
                if (throwable2 != null) {
                    try {
                        cs2.close();
                    }
                    catch (Throwable x2) {
                        throwable2.addSuppressed(x2);
                    }
                } else {
                    cs2.close();
                }
            }
            Thread.sleep(800L);
            Connection c = this.ds.getConnection();
            throwable2 = null;
            if (c != null) {
                if (throwable2 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable x2) {
                        throwable2.addSuppressed(x2);
                    }
                } else {
                    c.close();
                }
            }
            Statement s = conn1.createStatement();
            throwable2 = null;
            if (s != null) {
                if (throwable2 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable x2) {
                        throwable2.addSuppressed(x2);
                    }
                } else {
                    s.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLastUsedPreparedStatementUse() throws Exception {
        this.ds.setRemoveAbandonedTimeout(1);
        this.ds.setMaxTotal(2);
        try (Connection conn1 = this.ds.getConnection();
             Statement st = conn1.createStatement();){
            String querySQL = "SELECT 1 FROM DUAL";
            Thread.sleep(500L);
            Assert.assertNotNull((Object)st.executeQuery(querySQL));
            Thread.sleep(800L);
            Connection conn2 = this.ds.getConnection();
            Assert.assertNotNull((Object)st.executeQuery(querySQL));
            conn2.close();
            Thread.sleep(500L);
            st.executeUpdate("");
            Thread.sleep(800L);
            Connection c = this.ds.getConnection();
            Throwable throwable = null;
            if (c != null) {
                if (throwable != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    c.close();
                }
            }
            Statement s = conn1.createStatement();
            throwable = null;
            if (s != null) {
                if (throwable != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    s.close();
                }
            }
        }
    }

    public void testLastUsedUpdate() throws Exception {
        DelegatingConnection conn = (DelegatingConnection)this.ds.getConnection();
        PreparedStatement ps = conn.prepareStatement("");
        CallableStatement cs = conn.prepareCall("");
        PreparedStatement st = conn.prepareStatement("");
        this.checkLastUsedStatement(ps, conn);
        this.checkLastUsedPreparedStatement(ps, conn);
        this.checkLastUsedStatement(cs, conn);
        this.checkLastUsedPreparedStatement(cs, conn);
        this.checkLastUsedStatement(st, conn);
    }

    public void testGarbageCollectorCleanUp01() throws Exception {
        DelegatingConnection conn = (DelegatingConnection)this.ds.getConnection();
        Assert.assertEquals((long)0L, (long)conn.getTrace().size());
        this.createStatement((Connection)conn);
        Assert.assertEquals((long)1L, (long)conn.getTrace().size());
        System.gc();
        Assert.assertEquals((long)0L, (long)conn.getTrace().size());
    }

    public void testGarbageCollectorCleanUp02() throws Exception {
        this.ds.setPoolPreparedStatements(true);
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        DelegatingConnection conn = (DelegatingConnection)this.ds.getConnection();
        PoolableConnection poolableConn = (PoolableConnection)conn.getDelegate();
        PoolingConnection poolingConn = (PoolingConnection)poolableConn.getDelegate();
        GenericKeyedObjectPool gkop = (GenericKeyedObjectPool)TesterUtils.getField(poolingConn, "_pstmtPool");
        Assert.assertEquals((long)0L, (long)conn.getTrace().size());
        Assert.assertEquals((long)0L, (long)gkop.getNumActive());
        this.createStatement((Connection)conn);
        Assert.assertEquals((long)1L, (long)conn.getTrace().size());
        Assert.assertEquals((long)1L, (long)gkop.getNumActive());
        System.gc();
        for (int count = 0; count < 50 && gkop.getNumActive() > 0; ++count) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)0L, (long)gkop.getNumActive());
        Assert.assertEquals((long)0L, (long)conn.getTrace().size());
    }

    private void createStatement(Connection conn) throws Exception {
        PreparedStatement ps = conn.prepareStatement("");
        Assert.assertNotNull((Object)ps);
    }

    private void checkLastUsedStatement(Statement st, DelegatingConnection<?> conn) throws Exception {
        st.execute("");
        this.assertAndReset(conn);
        st.execute("", new int[0]);
        this.assertAndReset(conn);
        st.execute("", 0);
        this.assertAndReset(conn);
        st.executeBatch();
        this.assertAndReset(conn);
        Assert.assertNotNull((Object)st.executeQuery(""));
        this.assertAndReset(conn);
        st.executeUpdate("");
        this.assertAndReset(conn);
        st.executeUpdate("", new int[0]);
        this.assertAndReset(conn);
        st.executeUpdate("", 0);
        this.assertAndReset(conn);
        st.executeUpdate("", new String[0]);
        this.assertAndReset(conn);
    }

    private void checkLastUsedPreparedStatement(PreparedStatement ps, DelegatingConnection<?> conn) throws Exception {
        ps.execute();
        this.assertAndReset(conn);
        Assert.assertNotNull((Object)ps.executeQuery());
        this.assertAndReset(conn);
        ps.executeUpdate();
        this.assertAndReset(conn);
    }

    private void assertAndReset(DelegatingConnection<?> con) {
        TestAbandonedBasicDataSource.assertTrue((con.getLastUsed() > 0L ? 1 : 0) != 0);
        con.setLastUsed(0L);
    }
}

