/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.pack200;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.pack200.Pack200Utils;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Test;

public final class Pack200UtilsTest
extends AbstractTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNormalize() throws Throwable {
        File input = Pack200UtilsTest.getFile("bla.jar");
        File[] output = this.createTempDirAndFile();
        try {
            Pack200Utils.normalize((File)input, (File)output[1], new HashMap());
            try (InputStream is = Files.newInputStream(output[1].toPath(), new OpenOption[0]);){
                ArchiveInputStream in = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("jar", is);
                ArchiveEntry entry = in.getNextEntry();
                while (entry != null) {
                    File archiveEntry = new File(this.dir, entry.getName());
                    archiveEntry.getParentFile().mkdirs();
                    if (entry.isDirectory()) {
                        archiveEntry.mkdir();
                        entry = in.getNextEntry();
                        continue;
                    }
                    OutputStream out = Files.newOutputStream(archiveEntry.toPath(), new OpenOption[0]);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    out.close();
                    entry = in.getNextEntry();
                }
                in.close();
            }
        }
        finally {
            output[1].delete();
            output[0].delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNormalizeInPlace() throws Throwable {
        File input = Pack200UtilsTest.getFile("bla.jar");
        File[] output = this.createTempDirAndFile();
        try {
            InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
            OutputStream os = null;
            try {
                os = Files.newOutputStream(output[1].toPath(), new OpenOption[0]);
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                is.close();
                if (os != null) {
                    os.close();
                }
            }
            Pack200Utils.normalize((File)output[1]);
            is = Files.newInputStream(output[1].toPath(), new OpenOption[0]);
            try {
                ArchiveInputStream in = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("jar", is);
                ArchiveEntry entry = in.getNextEntry();
                while (entry != null) {
                    File archiveEntry = new File(this.dir, entry.getName());
                    archiveEntry.getParentFile().mkdirs();
                    if (entry.isDirectory()) {
                        archiveEntry.mkdir();
                        entry = in.getNextEntry();
                        continue;
                    }
                    OutputStream out = Files.newOutputStream(archiveEntry.toPath(), new OpenOption[0]);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    out.close();
                    entry = in.getNextEntry();
                }
                in.close();
            }
            finally {
                is.close();
            }
        }
        finally {
            output[1].delete();
            output[0].delete();
        }
    }
}

