/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorOutputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class FramedLZ4CompressorRoundtripTest
extends AbstractTestCase {
    private final FramedLZ4CompressorOutputStream.Parameters params;

    @Parameterized.Parameters(name="using {0}")
    public static Collection<Object[]> factory() {
        return Arrays.asList({new FramedLZ4CompressorOutputStream.Parameters(FramedLZ4CompressorOutputStream.BlockSize.K64)}, {new FramedLZ4CompressorOutputStream.Parameters(FramedLZ4CompressorOutputStream.BlockSize.K256)}, {new FramedLZ4CompressorOutputStream.Parameters(FramedLZ4CompressorOutputStream.BlockSize.M1)}, {FramedLZ4CompressorOutputStream.Parameters.DEFAULT}, {new FramedLZ4CompressorOutputStream.Parameters(FramedLZ4CompressorOutputStream.BlockSize.M4, false, false, false)}, {new FramedLZ4CompressorOutputStream.Parameters(FramedLZ4CompressorOutputStream.BlockSize.M4, true, true, false)}, {new FramedLZ4CompressorOutputStream.Parameters(FramedLZ4CompressorOutputStream.BlockSize.K64, true, false, true)}, {new FramedLZ4CompressorOutputStream.Parameters(FramedLZ4CompressorOutputStream.BlockSize.M4, true, false, false, BlockLZ4CompressorOutputStream.createParameterBuilder().tunedForSpeed().build())});
    }

    public FramedLZ4CompressorRoundtripTest(FramedLZ4CompressorOutputStream.Parameters params) {
        this.params = params;
    }

    private void roundTripTest(String testFile) throws IOException {
        byte[] expected;
        File input = FramedLZ4CompressorRoundtripTest.getFile(testFile);
        long start = System.currentTimeMillis();
        File outputSz = new File(this.dir, input.getName() + ".framed.lz4");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            expected = IOUtils.toByteArray((InputStream)is);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (FramedLZ4CompressorOutputStream los = new FramedLZ4CompressorOutputStream((OutputStream)bos, this.params);){
            IOUtils.copy((InputStream)new ByteArrayInputStream(expected), (OutputStream)los);
        }
        System.err.println(input.getName() + " written, uncompressed bytes: " + input.length() + ", compressed bytes: " + outputSz.length() + " after " + (System.currentTimeMillis() - start) + "ms");
        start = System.currentTimeMillis();
        var9_10 = null;
        try (FramedLZ4CompressorInputStream sis = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(bos.toByteArray()));){
            byte[] actual = IOUtils.toByteArray((InputStream)sis);
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        }
        catch (Throwable throwable) {
            var9_10 = throwable;
            throw throwable;
        }
        System.err.println(outputSz.getName() + " read after " + (System.currentTimeMillis() - start) + "ms");
    }

    @Test
    public void blaTarRoundtrip() throws IOException {
        this.roundTripTest("bla.tar");
    }

    @Test
    public void gzippedLoremIpsumRoundtrip() throws IOException {
        this.roundTripTest("lorem-ipsum.txt.gz");
    }

    @Test
    public void biggerFileRoundtrip() throws IOException {
        this.roundTripTest("COMPRESS-256.7z");
    }
}

