/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import org.apache.commons.compress.archivers.zip.StreamCompressor;
import org.junit.Assert;
import org.junit.Test;

public class StreamCompressorTest {
    @Test
    public void storedEntries() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamCompressor sc = StreamCompressor.create((OutputStream)baos);
        sc.deflate((InputStream)new ByteArrayInputStream("A".getBytes()), 0);
        sc.deflate((InputStream)new ByteArrayInputStream("BAD".getBytes()), 0);
        Assert.assertEquals((long)3L, (long)sc.getBytesRead());
        Assert.assertEquals((long)3L, (long)sc.getBytesWrittenForLastEntry());
        Assert.assertEquals((long)344750961L, (long)sc.getCrc32());
        sc.deflate((InputStream)new ByteArrayInputStream("CAFE".getBytes()), 0);
        Assert.assertEquals((Object)"ABADCAFE", (Object)baos.toString());
    }

    @Test
    public void deflatedEntries() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamCompressor sc = StreamCompressor.create((OutputStream)baos);
        sc.deflate((InputStream)new ByteArrayInputStream("AAAAAABBBBBB".getBytes()), 8);
        Assert.assertEquals((long)12L, (long)sc.getBytesRead());
        Assert.assertEquals((long)8L, (long)sc.getBytesWrittenForLastEntry());
        Assert.assertEquals((long)3299542L, (long)sc.getCrc32());
        byte[] actuals = baos.toByteArray();
        byte[] expected = new byte[]{115, 116, 4, 1, 39, 48, 0, 0};
        Assert.assertArrayEquals((byte[])expected, (byte[])actuals);
    }

    @Test
    public void testCreateDataOutputCompressor() throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new ByteArrayOutputStream());
        try (StreamCompressor streamCompressor = StreamCompressor.create((DataOutput)dataOutputStream, (Deflater)new Deflater(9));){
            Assert.assertNotNull((Object)streamCompressor);
        }
    }
}

