/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.zip.ScatterZipOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryRequest;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ScatterZipOutputStreamTest {
    private File scatterFile = null;
    private File target = null;

    @After
    public void cleanup() {
        AbstractTestCase.tryHardToDelete(this.scatterFile);
        AbstractTestCase.tryHardToDelete(this.target);
    }

    @Test
    public void putArchiveEntry() throws Exception {
        this.scatterFile = File.createTempFile("scattertest", ".notzip");
        ScatterZipOutputStream scatterZipOutputStream = ScatterZipOutputStream.fileBased((File)this.scatterFile);
        byte[] B_PAYLOAD = "RBBBBBBS".getBytes();
        byte[] A_PAYLOAD = "XAAY".getBytes();
        ZipArchiveEntry zab = new ZipArchiveEntry("b.txt");
        zab.setMethod(8);
        ByteArrayInputStream payload = new ByteArrayInputStream(B_PAYLOAD);
        scatterZipOutputStream.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zab, (InputStreamSupplier)this.createPayloadSupplier(payload)));
        ZipArchiveEntry zae = new ZipArchiveEntry("a.txt");
        zae.setMethod(8);
        ByteArrayInputStream payload1 = new ByteArrayInputStream(A_PAYLOAD);
        scatterZipOutputStream.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zae, (InputStreamSupplier)this.createPayloadSupplier(payload1)));
        this.target = File.createTempFile("scattertest", ".zip");
        ZipArchiveOutputStream outputStream = new ZipArchiveOutputStream(this.target);
        scatterZipOutputStream.writeTo(outputStream);
        outputStream.close();
        scatterZipOutputStream.close();
        ZipFile zf = new ZipFile(this.target);
        ZipArchiveEntry b_entry = (ZipArchiveEntry)zf.getEntries("b.txt").iterator().next();
        Assert.assertEquals((long)8L, (long)b_entry.getSize());
        Assert.assertArrayEquals((byte[])B_PAYLOAD, (byte[])IOUtils.toByteArray((InputStream)zf.getInputStream(b_entry)));
        ZipArchiveEntry a_entry = (ZipArchiveEntry)zf.getEntries("a.txt").iterator().next();
        Assert.assertEquals((long)4L, (long)a_entry.getSize());
        Assert.assertArrayEquals((byte[])A_PAYLOAD, (byte[])IOUtils.toByteArray((InputStream)zf.getInputStream(a_entry)));
        zf.close();
    }

    private InputStreamSupplier createPayloadSupplier(ByteArrayInputStream payload) {
        return () -> payload;
    }
}

