/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class TarArchiveOutputStreamTest
extends AbstractTestCase {
    @Test
    public void testCount() throws Exception {
        File f = File.createTempFile("commons-compress-tarcount", ".tar");
        f.deleteOnExit();
        OutputStream fos = Files.newOutputStream(f.toPath(), new OpenOption[0]);
        ArchiveOutputStream tarOut = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("tar", fos);
        File file1 = TarArchiveOutputStreamTest.getFile("test1.xml");
        TarArchiveEntry sEntry = new TarArchiveEntry(file1, file1.getName());
        tarOut.putArchiveEntry((ArchiveEntry)sEntry);
        InputStream in = Files.newInputStream(file1.toPath(), new OpenOption[0]);
        byte[] buf = new byte[8192];
        int read = 0;
        while ((read = in.read(buf)) > 0) {
            tarOut.write(buf, 0, read);
        }
        in.close();
        tarOut.closeArchiveEntry();
        tarOut.close();
        Assert.assertEquals((long)f.length(), (long)tarOut.getBytesWritten());
    }

    @Test
    public void testMaxFileSizeError() throws Exception {
        TarArchiveEntry t = new TarArchiveEntry("foo");
        t.setSize(0x1FFFFFFFFL);
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)new ByteArrayOutputStream());
        tos.putArchiveEntry((ArchiveEntry)t);
        t.setSize(0x200000000L);
        tos = new TarArchiveOutputStream((OutputStream)new ByteArrayOutputStream());
        try {
            tos.putArchiveEntry((ArchiveEntry)t);
            Assert.fail((String)"Should have generated RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBigNumberErrorMode() throws Exception {
        TarArchiveEntry t = new TarArchiveEntry("foo");
        t.setSize(0x200000000L);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);
        tos.putArchiveEntry((ArchiveEntry)t);
    }

    @Test
    public void testBigNumberStarMode() throws Exception {
        TarArchiveEntry t = new TarArchiveEntry("foo");
        t.setSize(0x200000000L);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);
        tos.setBigNumberMode(1);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.write(new byte[10240]);
        byte[] data = bos.toByteArray();
        Assert.assertEquals((long)128L, (long)(data[124] & 0x80));
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        Assert.assertEquals((long)0x200000000L, (long)e.getSize());
        tin.close();
        this.closeQuietly((Closeable)tos);
    }

    @Test
    public void testBigNumberPosixMode() throws Exception {
        TarArchiveEntry t = new TarArchiveEntry("foo");
        t.setSize(0x200000000L);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);
        tos.setBigNumberMode(2);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.write(new byte[10240]);
        byte[] data = bos.toByteArray();
        Assert.assertEquals((Object)"00000000000 ", (Object)new String(data, 1148, 12, StandardCharsets.UTF_8));
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        Assert.assertEquals((long)0x200000000L, (long)e.getSize());
        tin.close();
        this.closeQuietly((Closeable)tos);
    }

    @Test
    public void testWriteSimplePaxHeaders() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a", "b");
        byte[] data = this.writePaxHeader(m);
        Assert.assertEquals((Object)"00000000006 ", (Object)new String(data, 124, 12, StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"6 a=b\n", (Object)new String(data, 512, 6, StandardCharsets.UTF_8));
    }

    @Test
    public void testPaxHeadersWithLength99() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a", "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012");
        byte[] data = this.writePaxHeader(m);
        Assert.assertEquals((Object)"00000000143 ", (Object)new String(data, 124, 12, StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"99 a=012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012\n", (Object)new String(data, 512, 99, StandardCharsets.UTF_8));
    }

    @Test
    public void testPaxHeadersWithLength101() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a", "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123");
        byte[] data = this.writePaxHeader(m);
        Assert.assertEquals((Object)"00000000145 ", (Object)new String(data, 124, 12, StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"101 a=0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123\n", (Object)new String(data, 512, 101, StandardCharsets.UTF_8));
    }

    private byte[] writePaxHeader(Map<String, String> m) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "ASCII");
        tos.writePaxHeaders(new TarArchiveEntry("x"), "foo", m);
        TarArchiveEntry t = new TarArchiveEntry("foo");
        t.setSize(10240L);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.write(new byte[10240]);
        tos.closeArchiveEntry();
        tos.close();
        return bos.toByteArray();
    }

    @Test
    public void testWriteLongFileNamePosixMode() throws Exception {
        String n = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
        TarArchiveEntry t = new TarArchiveEntry("012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789");
        t.setSize(10240L);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "ASCII");
        tos.setLongFileMode(3);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.write(new byte[10240]);
        tos.closeArchiveEntry();
        byte[] data = bos.toByteArray();
        Assert.assertEquals((Object)"160 path=012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789\n", (Object)new String(data, 512, 160, StandardCharsets.UTF_8));
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        Assert.assertEquals((Object)"012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789", (Object)e.getName());
        tin.close();
        tos.close();
    }

    @Test
    public void testOldEntryStarMode() throws Exception {
        TarArchiveEntry t = new TarArchiveEntry("foo");
        t.setSize(Integer.MAX_VALUE);
        t.setModTime(-1000L);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);
        tos.setBigNumberMode(1);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.write(new byte[10240]);
        byte[] data = bos.toByteArray();
        Assert.assertEquals((long)-1L, (long)data[136]);
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(1969, 11, 31, 23, 59, 59);
        cal.set(14, 0);
        Assert.assertEquals((Object)cal.getTime(), (Object)e.getLastModifiedDate());
        tin.close();
        this.closeQuietly((Closeable)tos);
    }

    @Test
    public void testOldEntryPosixMode() throws Exception {
        TarArchiveEntry t = new TarArchiveEntry("foo");
        t.setSize(Integer.MAX_VALUE);
        t.setModTime(-1000L);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);
        tos.setBigNumberMode(2);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.write(new byte[10240]);
        byte[] data = bos.toByteArray();
        Assert.assertEquals((Object)"00000000000 ", (Object)new String(data, 1160, 12, StandardCharsets.UTF_8));
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(1969, 11, 31, 23, 59, 59);
        cal.set(14, 0);
        Assert.assertEquals((Object)cal.getTime(), (Object)e.getLastModifiedDate());
        tin.close();
        this.closeQuietly((Closeable)tos);
    }

    @Test
    public void testOldEntryError() throws Exception {
        TarArchiveEntry t = new TarArchiveEntry("foo");
        t.setSize(Integer.MAX_VALUE);
        t.setModTime(-1000L);
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)new ByteArrayOutputStream());
        try {
            tos.putArchiveEntry((ArchiveEntry)t);
            Assert.fail((String)"Should have generated RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        tos.close();
    }

    @Test
    public void testWriteNonAsciiPathNamePaxHeader() throws Exception {
        String n = "\u00e4";
        TarArchiveEntry t = new TarArchiveEntry("\u00e4");
        t.setSize(10240L);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);
        tos.setAddPaxHeadersForNonAsciiNames(true);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.write(new byte[10240]);
        tos.closeArchiveEntry();
        tos.close();
        byte[] data = bos.toByteArray();
        Assert.assertEquals((Object)"11 path=\u00e4\n", (Object)new String(data, 512, 11, StandardCharsets.UTF_8));
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        Assert.assertEquals((Object)"\u00e4", (Object)e.getName());
        tin.close();
    }

    @Test
    public void testWriteNonAsciiLinkPathNamePaxHeader() throws Exception {
        String n = "\u00e4";
        TarArchiveEntry t = new TarArchiveEntry("a", 49);
        t.setSize(10240L);
        t.setLinkName("\u00e4");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);
        tos.setAddPaxHeadersForNonAsciiNames(true);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.write(new byte[10240]);
        tos.closeArchiveEntry();
        tos.close();
        byte[] data = bos.toByteArray();
        Assert.assertEquals((Object)"15 linkpath=\u00e4\n", (Object)new String(data, 512, 15, StandardCharsets.UTF_8));
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        Assert.assertEquals((Object)"\u00e4", (Object)e.getLinkName());
        tin.close();
    }

    @Test
    public void testRoundtripWith67CharFileNameGnu() throws Exception {
        this.testRoundtripWith67CharFileName(2);
    }

    @Test
    public void testRoundtripWith67CharFileNamePosix() throws Exception {
        this.testRoundtripWith67CharFileName(3);
    }

    private void testRoundtripWith67CharFileName(int mode) throws Exception {
        String n = "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
        Assert.assertEquals((long)67L, (long)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA".length());
        TarArchiveEntry t = new TarArchiveEntry("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
        t.setSize(10240L);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "ASCII");
        tos.setLongFileMode(mode);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.write(new byte[10240]);
        tos.closeArchiveEntry();
        tos.close();
        byte[] data = bos.toByteArray();
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        Assert.assertEquals((Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", (Object)e.getName());
        tin.close();
    }

    @Test
    public void testWriteLongDirectoryNameErrorMode() throws Exception {
        String n = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/";
        try {
            TarArchiveEntry t = new TarArchiveEntry("012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "ASCII");
            tos.setLongFileMode(0);
            tos.putArchiveEntry((ArchiveEntry)t);
            tos.closeArchiveEntry();
            tos.close();
            Assert.fail((String)"Truncated name didn't throw an exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteLongDirectoryNameTruncateMode() throws Exception {
        String n = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/";
        TarArchiveEntry t = new TarArchiveEntry("012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "ASCII");
        tos.setLongFileMode(1);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.closeArchiveEntry();
        tos.close();
        byte[] data = bos.toByteArray();
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        Assert.assertEquals((String)"Entry name", (Object)("012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/".substring(0, 100) + "/"), (Object)e.getName());
        Assert.assertTrue((String)"The entry is not a directory", (boolean)e.isDirectory());
        tin.close();
    }

    @Test
    public void testWriteLongDirectoryNameGnuMode() throws Exception {
        this.testWriteLongDirectoryName(2);
    }

    @Test
    public void testWriteLongDirectoryNamePosixMode() throws Exception {
        this.testWriteLongDirectoryName(3);
    }

    private void testWriteLongDirectoryName(int mode) throws Exception {
        String n = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/";
        TarArchiveEntry t = new TarArchiveEntry("012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "ASCII");
        tos.setLongFileMode(mode);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.closeArchiveEntry();
        tos.close();
        byte[] data = bos.toByteArray();
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        Assert.assertEquals((Object)"012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/", (Object)e.getName());
        Assert.assertTrue((boolean)e.isDirectory());
        tin.close();
    }

    @Test
    public void testWriteNonAsciiDirectoryNamePosixMode() throws Exception {
        String n = "f\u00f6\u00f6/";
        TarArchiveEntry t = new TarArchiveEntry("f\u00f6\u00f6/");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);
        tos.setAddPaxHeadersForNonAsciiNames(true);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.closeArchiveEntry();
        tos.close();
        byte[] data = bos.toByteArray();
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        Assert.assertEquals((Object)"f\u00f6\u00f6/", (Object)e.getName());
        Assert.assertTrue((boolean)e.isDirectory());
        tin.close();
    }

    @Test
    public void testWriteNonAsciiNameWithUnfortunateNamePosixMode() throws Exception {
        String n = "f\u00f6\u00f6\u00dc";
        TarArchiveEntry t = new TarArchiveEntry("f\u00f6\u00f6\u00dc");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);
        tos.setAddPaxHeadersForNonAsciiNames(true);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.closeArchiveEntry();
        tos.close();
        byte[] data = bos.toByteArray();
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        Assert.assertEquals((Object)"f\u00f6\u00f6\u00dc", (Object)e.getName());
        Assert.assertFalse((boolean)e.isDirectory());
        tin.close();
    }

    @Test
    public void testWriteLongLinkNameErrorMode() throws Exception {
        String linkname = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/test";
        TarArchiveEntry entry = new TarArchiveEntry("test", 50);
        entry.setLinkName("012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/test");
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "ASCII");
            tos.setLongFileMode(0);
            tos.putArchiveEntry((ArchiveEntry)entry);
            tos.closeArchiveEntry();
            tos.close();
            Assert.fail((String)"Truncated link name didn't throw an exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteLongLinkNameTruncateMode() throws Exception {
        String linkname = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/";
        TarArchiveEntry entry = new TarArchiveEntry("test", 50);
        entry.setLinkName("012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "ASCII");
        tos.setLongFileMode(1);
        tos.putArchiveEntry((ArchiveEntry)entry);
        tos.closeArchiveEntry();
        tos.close();
        byte[] data = bos.toByteArray();
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        Assert.assertEquals((String)"Link name", (Object)"012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/".substring(0, 100), (Object)e.getLinkName());
        tin.close();
    }

    @Test
    public void testWriteLongLinkNameGnuMode() throws Exception {
        this.testWriteLongLinkName(2);
    }

    @Test
    public void testWriteLongLinkNamePosixMode() throws Exception {
        this.testWriteLongLinkName(3);
    }

    private void testWriteLongLinkName(int mode) throws Exception {
        String linkname = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/test";
        TarArchiveEntry entry = new TarArchiveEntry("test", 50);
        entry.setLinkName("012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/test");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "ASCII");
        tos.setLongFileMode(mode);
        tos.putArchiveEntry((ArchiveEntry)entry);
        tos.closeArchiveEntry();
        tos.close();
        byte[] data = bos.toByteArray();
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(data));
        TarArchiveEntry e = tin.getNextTarEntry();
        Assert.assertEquals((String)"Entry name", (Object)"test", (Object)e.getName());
        Assert.assertEquals((String)"Link name", (Object)"012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789/test", (Object)e.getLinkName());
        Assert.assertTrue((String)"The entry is not a symbolic link", (boolean)e.isSymbolicLink());
        tin.close();
    }

    @Test
    public void testRecordSize() throws IOException {
        TarArchiveOutputStream tos2;
        try {
            tos2 = new TarArchiveOutputStream((OutputStream)new ByteArrayOutputStream(), 512, 511);
            Assert.fail((String)"should have rejected recordSize of 511");
        }
        catch (IllegalArgumentException tos2) {
            // empty catch block
        }
        try {
            tos2 = new TarArchiveOutputStream((OutputStream)new ByteArrayOutputStream(), 512, 511, null);
            Assert.fail((String)"should have rejected recordSize of 511");
        }
        catch (IllegalArgumentException tos3) {
            // empty catch block
        }
        tos2 = new TarArchiveOutputStream((OutputStream)new ByteArrayOutputStream(), 512, 512);
        Throwable throwable = null;
        try {
            Assert.assertEquals((String)"recordSize", (long)512L, (long)tos2.getRecordSize());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (tos2 != null) {
                if (throwable != null) {
                    try {
                        tos2.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    tos2.close();
                }
            }
        }
        tos2 = new TarArchiveOutputStream((OutputStream)new ByteArrayOutputStream(), 512, 512, null);
        throwable = null;
        try {
            Assert.assertEquals((String)"recordSize", (long)512L, (long)tos2.getRecordSize());
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (tos2 != null) {
                if (throwable != null) {
                    try {
                        tos2.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tos2.close();
                }
            }
        }
    }

    @Test
    public void testBlockSizes() throws Exception {
        String fileName = "/test1.xml";
        byte[] contents = this.getResourceContents("/test1.xml");
        this.testPadding(10240, "/test1.xml", contents);
        this.testPadding(5120, "/test1.xml", contents);
        this.testPadding(32768, "/test1.xml", contents);
        this.testPadding(-2, "/test1.xml", contents);
        try {
            this.testPadding(511, "/test1.xml", contents);
            Assert.fail((String)"should have thrown an illegal argument exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.testPadding(0, "/test1.xml", contents);
            Assert.fail((String)"should have thrown an illegal argument exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        contents = new byte[2048];
        Arrays.fill(contents, (byte)42);
        this.testPadding(10240, "/test1.xml", contents);
    }

    private void testPadding(int blockSize, String fileName, byte[] contents) throws IOException {
        TarArchiveOutputStream tos;
        File f = File.createTempFile("commons-compress-padding", ".tar");
        f.deleteOnExit();
        OutputStream fos = Files.newOutputStream(f.toPath(), new OpenOption[0]);
        if (blockSize != -2) {
            tos = new TarArchiveOutputStream(fos, blockSize);
        } else {
            blockSize = 512;
            tos = new TarArchiveOutputStream(fos);
        }
        TarArchiveEntry sEntry = new TarArchiveEntry(fileName);
        sEntry.setSize((long)contents.length);
        tos.putArchiveEntry((ArchiveEntry)sEntry);
        tos.write(contents);
        tos.closeArchiveEntry();
        tos.close();
        int fileRecordsSize = (int)Math.ceil((double)contents.length / 512.0) * 512;
        int headerSize = 512;
        int endOfArchiveSize = 1024;
        int unpaddedSize = 512 + fileRecordsSize + 1024;
        int paddedSize = (int)Math.ceil((double)unpaddedSize / (double)blockSize) * blockSize;
        Assert.assertEquals((long)paddedSize, (long)f.length());
    }

    private byte[] getResourceContents(String name) throws IOException {
        ByteArrayOutputStream bos;
        try (InputStream resourceAsStream = this.getClass().getResourceAsStream(name);){
            bos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)resourceAsStream, (OutputStream)bos);
        }
        return bos.toByteArray();
    }

    @Test
    public void testPutGlobalPaxHeaderEntry() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);
        int pid = 73;
        boolean globCount = true;
        int lfPaxGlobalExtendedHeader = 103;
        TarArchiveEntry globalHeader = new TarArchiveEntry("/tmp/GlobalHead.73.1", 103);
        globalHeader.addPaxHeader("SCHILLY.xattr.user.org.apache.weasels", "global-weasels");
        tos.putArchiveEntry((ArchiveEntry)globalHeader);
        TarArchiveEntry entry = new TarArchiveEntry("message");
        String x = "If at first you don't succeed, give up";
        entry.setSize((long)"If at first you don't succeed, give up".length());
        tos.putArchiveEntry((ArchiveEntry)entry);
        tos.write("If at first you don't succeed, give up".getBytes());
        tos.closeArchiveEntry();
        entry = new TarArchiveEntry("counter-message");
        String y = "Nothing succeeds like excess";
        entry.setSize((long)"Nothing succeeds like excess".length());
        entry.addPaxHeader("SCHILLY.xattr.user.org.apache.weasels.species", "unknown");
        tos.putArchiveEntry((ArchiveEntry)entry);
        tos.write("Nothing succeeds like excess".getBytes());
        tos.closeArchiveEntry();
        tos.close();
        TarArchiveInputStream in = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(bos.toByteArray()));
        TarArchiveEntry entryIn = in.getNextTarEntry();
        Assert.assertNotNull((Object)entryIn);
        Assert.assertEquals((Object)"message", (Object)entryIn.getName());
        Assert.assertEquals((Object)"global-weasels", (Object)entryIn.getExtraPaxHeader("SCHILLY.xattr.user.org.apache.weasels"));
        InputStreamReader reader = new InputStreamReader((InputStream)in);
        for (int i = 0; i < "If at first you don't succeed, give up".length(); ++i) {
            Assert.assertEquals((long)"If at first you don't succeed, give up".charAt(i), (long)((Reader)reader).read());
        }
        Assert.assertEquals((long)-1L, (long)((Reader)reader).read());
        entryIn = in.getNextTarEntry();
        Assert.assertEquals((Object)"counter-message", (Object)entryIn.getName());
        Assert.assertEquals((Object)"global-weasels", (Object)entryIn.getExtraPaxHeader("SCHILLY.xattr.user.org.apache.weasels"));
        Assert.assertEquals((Object)"unknown", (Object)entryIn.getExtraPaxHeader("SCHILLY.xattr.user.org.apache.weasels.species"));
        Assert.assertNull((Object)in.getNextTarEntry());
    }

    @Test
    public void testLongNameMd5Hash() throws Exception {
        String longFileName = "a/considerably/longer/file/name/which/forces/use/of/the/long/link/header/which/appears/to/always/use/the/current/time/as/modification/date";
        Date modificationDate = new Date();
        byte[] archive1 = TarArchiveOutputStreamTest.createTarArchiveContainingOneDirectory("a/considerably/longer/file/name/which/forces/use/of/the/long/link/header/which/appears/to/always/use/the/current/time/as/modification/date", modificationDate);
        byte[] digest1 = MessageDigest.getInstance("MD5").digest(archive1);
        Thread.sleep(1000L);
        byte[] archive2 = TarArchiveOutputStreamTest.createTarArchiveContainingOneDirectory("a/considerably/longer/file/name/which/forces/use/of/the/long/link/header/which/appears/to/always/use/the/current/time/as/modification/date", modificationDate);
        byte[] digest2 = MessageDigest.getInstance("MD5").digest(archive2);
        Assert.assertArrayEquals((byte[])digest1, (byte[])digest2);
        Thread.sleep(1000L);
        TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(archive2));
        ArchiveEntry nextEntry = tarIn.getNextEntry();
        Assert.assertEquals((Object)"a/considerably/longer/file/name/which/forces/use/of/the/long/link/header/which/appears/to/always/use/the/current/time/as/modification/date", (Object)nextEntry.getName());
        Assert.assertEquals((long)(modificationDate.getTime() / 1000L), (long)(nextEntry.getLastModifiedDate().getTime() / 1000L));
        tarIn.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWriteLongFileNameThrowsException() throws Exception {
        String n = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
        TarArchiveEntry t = new TarArchiveEntry("012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789");
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)new ByteArrayOutputStream(), "ASCII");
        tos.putArchiveEntry((ArchiveEntry)t);
    }

    private static byte[] createTarArchiveContainingOneDirectory(String fname, Date modificationDate) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TarArchiveOutputStream tarOut = new TarArchiveOutputStream((OutputStream)baos, 1024);
        tarOut.setLongFileMode(2);
        TarArchiveEntry tarEntry = new TarArchiveEntry("d");
        tarEntry.setModTime(modificationDate);
        tarEntry.setMode(16877);
        tarEntry.setModTime(modificationDate.getTime());
        tarEntry.setName(fname);
        tarOut.putArchiveEntry((ArchiveEntry)tarEntry);
        tarOut.closeArchiveEntry();
        tarOut.close();
        return baos.toByteArray();
    }
}

