/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.cpio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CpioArchiveTest {
    private final short format;

    @Parameterized.Parameters(name="using {0}")
    public static Collection<Object[]> factory() {
        return Arrays.asList({(short)1}, {(short)2}, {(short)4}, {(short)8});
    }

    public CpioArchiveTest(short format) {
        this.format = format;
    }

    @Test
    public void utf18RoundtripTest() throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (CpioArchiveOutputStream os = new CpioArchiveOutputStream((OutputStream)baos, this.format, 512, "UTF-16LE");){
                CpioArchiveEntry entry = new CpioArchiveEntry(this.format, "T\u00e4st.txt", 4L);
                if (this.format == 2) {
                    entry.setChksum(10L);
                }
                os.putArchiveEntry((ArchiveEntry)entry);
                os.write(new byte[]{1, 2, 3, 4});
                os.closeArchiveEntry();
            }
            baos.close();
            var4_6 = null;
            try (ByteArrayInputStream bin = new ByteArrayInputStream(baos.toByteArray());
                 CpioArchiveInputStream in = new CpioArchiveInputStream((InputStream)bin, "UTF-16LE");){
                CpioArchiveEntry entry = (CpioArchiveEntry)in.getNextEntry();
                Assert.assertNotNull((Object)entry);
                Assert.assertEquals((Object)"T\u00e4st.txt", (Object)entry.getName());
                Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4}, (byte[])IOUtils.toByteArray((InputStream)in));
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
        }
    }
}

