/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class ArchiveOutputStreamTest
extends AbstractTestCase {
    @Test
    public void testFinish() throws Exception {
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        ArchiveOutputStream aos1 = this.factory.createArchiveOutputStream("zip", (OutputStream)out1);
        aos1.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("dummy"));
        try {
            aos1.finish();
            Assert.fail((String)"After putArchive should follow closeArchive");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        aos1 = this.factory.createArchiveOutputStream("jar", (OutputStream)out1);
        aos1.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("dummy"));
        try {
            aos1.finish();
            Assert.fail((String)"After putArchive should follow closeArchive");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        aos1 = this.factory.createArchiveOutputStream("ar", (OutputStream)out1);
        aos1.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("dummy", 100L));
        try {
            aos1.finish();
            Assert.fail((String)"After putArchive should follow closeArchive");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        aos1 = this.factory.createArchiveOutputStream("cpio", (OutputStream)out1);
        aos1.putArchiveEntry((ArchiveEntry)new CpioArchiveEntry("dummy"));
        try {
            aos1.finish();
            Assert.fail((String)"After putArchive should follow closeArchive");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        aos1 = this.factory.createArchiveOutputStream("tar", (OutputStream)out1);
        aos1.putArchiveEntry((ArchiveEntry)new TarArchiveEntry("dummy"));
        try {
            aos1.finish();
            Assert.fail((String)"After putArchive should follow closeArchive");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testOptionalFinish() throws Exception {
        ArchiveOutputStream finishTest;
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        try (ArchiveOutputStream aos1 = this.factory.createArchiveOutputStream("zip", (OutputStream)out1);){
            aos1.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("dummy"));
            aos1.closeArchiveEntry();
        }
        try (ArchiveOutputStream aos1 = this.factory.createArchiveOutputStream("jar", (OutputStream)out1);){
            finishTest = aos1;
            aos1.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("dummy"));
            aos1.closeArchiveEntry();
        }
        try {
            finishTest.finish();
            Assert.fail((String)"finish() cannot follow close()");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        finishTest.close();
    }

    @Test
    public void testCallSequenceAr() throws Exception {
        this.doCallSequence("Ar");
    }

    @Test
    public void testCallSequenceCpio() throws Exception {
        this.doCallSequence("Cpio");
    }

    @Test
    public void testCallSequenceJar() throws Exception {
        this.doCallSequence("Jar");
    }

    @Test
    public void testCallSequenceTar() throws Exception {
        this.doCallSequence("Tar");
    }

    @Test
    public void testCallSequenceZip() throws Exception {
        this.doCallSequence("Zip");
    }

    private void doCallSequence(String archiveType) throws Exception {
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        File dummy = ArchiveOutputStreamTest.getFile("test1.xml");
        ArchiveOutputStream aos1 = this.factory.createArchiveOutputStream(archiveType, (OutputStream)out1);
        aos1.putArchiveEntry(aos1.createArchiveEntry(dummy, "dummy"));
        try (InputStream is2 = Files.newInputStream(dummy.toPath(), new OpenOption[0]);){
            IOUtils.copy((InputStream)is2, (OutputStream)aos1);
        }
        aos1.closeArchiveEntry();
        aos1.close();
        aos1 = this.factory.createArchiveOutputStream(archiveType, (OutputStream)out1);
        try {
            aos1.closeArchiveEntry();
            Assert.fail((String)"Should have raised IOException - closeArchiveEntry() called before putArchiveEntry()");
        }
        catch (IOException is2) {
            // empty catch block
        }
        aos1.putArchiveEntry(aos1.createArchiveEntry(dummy, "dummy"));
        is2 = Files.newInputStream(dummy.toPath(), new OpenOption[0]);
        var6_11 = null;
        try {
            IOUtils.copy((InputStream)is2, (OutputStream)aos1);
        }
        catch (Throwable throwable) {
            var6_11 = throwable;
            throw throwable;
        }
        finally {
            if (is2 != null) {
                if (var6_11 != null) {
                    try {
                        is2.close();
                    }
                    catch (Throwable throwable) {
                        var6_11.addSuppressed(throwable);
                    }
                } else {
                    is2.close();
                }
            }
        }
        try {
            aos1.finish();
            Assert.fail((String)"Should have raised IOException - finish() called before closeArchiveEntry()");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            aos1.close();
            Assert.fail((String)"Should have raised IOException - close() called before closeArchiveEntry()");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        aos1 = this.createArchiveWithDummyEntry(archiveType, out1, dummy);
        aos1.closeArchiveEntry();
        try {
            aos1.closeArchiveEntry();
            Assert.fail((String)"Should have raised IOException - closeArchiveEntry() called with no open entry");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        aos1 = this.createArchiveWithDummyEntry(archiveType, out1, dummy);
        aos1.closeArchiveEntry();
        aos1.finish();
        aos1.close();
        try {
            aos1.finish();
            Assert.fail((String)"Should have raised IOException - finish() called after close()");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ArchiveOutputStream createArchiveWithDummyEntry(String archiveType, OutputStream out1, File dummy) throws Exception {
        ArchiveOutputStream aos1 = this.factory.createArchiveOutputStream(archiveType, out1);
        aos1.putArchiveEntry(aos1.createArchiveEntry(dummy, "dummy"));
        try (InputStream is = Files.newInputStream(dummy.toPath(), new OpenOption[0]);){
            IOUtils.copy((InputStream)is, (OutputStream)aos1);
        }
        return aos1;
    }
}

