/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class TestObjectMethods {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:" + UUID.randomUUID());
        this.dbi = new DBI((DataSource)ds);
        this.dbi.registerMapper((ResultSetMapper)new SomethingMapper());
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testToString() throws Exception {
        DAO dao = (DAO)this.handle.attach(DAO.class);
        Assert.assertThat((Object)dao.toString(), (Matcher)StringContains.containsString((String)DAO.class.getName()));
    }

    @Test
    public void testEquals() throws Exception {
        DAO dao = (DAO)this.handle.attach(DAO.class);
        Assert.assertThat((Object)dao, (Matcher)CoreMatchers.equalTo((Object)dao));
    }

    @Test
    public void testNotEquals() throws Exception {
        DAO dao = (DAO)this.handle.attach(DAO.class);
        DAO oad = (DAO)this.handle.attach(DAO.class);
        Assert.assertThat((Object)dao, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)oad)));
    }

    @Test
    public void testHashCodeDiff() throws Exception {
        DAO dao = (DAO)this.handle.attach(DAO.class);
        DAO oad = (DAO)this.handle.attach(DAO.class);
        Assert.assertThat((Object)dao.hashCode(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)oad.hashCode())));
    }

    @Test
    public void testHashCodeMatch() throws Exception {
        DAO dao = (DAO)this.handle.attach(DAO.class);
        Assert.assertThat((Object)dao.hashCode(), (Matcher)CoreMatchers.equalTo((Object)dao.hashCode()));
    }

    public static interface DAO {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") long var1, @Bind(value="name") String var3);
    }
}

