/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.BindSomething;
import org.skife.jdbi.v2.sqlobject.SomethingBinderAgainstBind;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlObjectBuilder;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.Mapper;
import org.skife.jdbi.v2.sqlobject.mixins.CloseMe;

public class TestCustomBinder {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:" + UUID.randomUUID());
        this.dbi = new DBI((DataSource)ds);
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testFoo() throws Exception {
        this.handle.execute("insert into something (id, name) values (2, 'Martin')", new Object[0]);
        Spiffy spiffy = (Spiffy)SqlObjectBuilder.open((IDBI)this.dbi, Spiffy.class);
        Something s = spiffy.findSame(new Something(2, "Unknown"));
        Assert.assertEquals((Object)"Martin", (Object)s.getName());
        spiffy.close();
    }

    @Test
    public void testCustomBindingAnnotation() throws Exception {
        Spiffy s = (Spiffy)this.handle.attach(Spiffy.class);
        s.insert(new Something(2, "Keith"));
        Assert.assertEquals((Object)"Keith", (Object)s.findNameById(2));
    }

    public static interface Spiffy
    extends CloseMe {
        @SqlQuery(value="select id, name from something where id = :it.id")
        @Mapper(value=SomethingMapper.class)
        public Something findSame(@Bind(value="it", binder=SomethingBinderAgainstBind.class) Something var1);

        @SqlUpdate(value="insert into something (id, name) values (:s.id, :s.name)")
        public int insert(@BindSomething(value="s") Something var1);

        @SqlQuery(value="select name from something where id = :id")
        public String findNameById(@Bind(value="id") int var1);
    }
}

