/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.util.Iterator;
import java.util.UUID;
import javax.sql.DataSource;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.h2.jdbcx.JdbcDataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.IntegerMapper;

public class TestQueryCleanup {
    private static final int COUNT = 100;
    private DBI dbi;

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL(String.format("jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1", UUID.randomUUID()));
        this.dbi = new DBI((DataSource)ds);
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) {
                handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
                for (int i = 0; i < 100; ++i) {
                    ((Update)((Update)handle.createStatement("insert into something (id, name) values (:id, :name)").bind("id", i)).bind("name", UUID.randomUUID().toString())).execute();
                }
                return null;
            }
        });
    }

    @Test
    public void testBasicCleanupHandle() throws Exception {
        Handle handle = this.dbi.open();
        Query q = handle.createQuery("SELECT COUNT(1) FROM something").map((ResultSetMapper)IntegerMapper.FIRST);
        ResultIterator it = q.iterator();
        Assert.assertEquals((long)100L, (long)((Integer)Iterators.getOnlyElement((Iterator)it)).intValue());
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertFalse((boolean)handle.getConnection().isClosed());
        handle.close();
        Assert.assertTrue((boolean)handle.getConnection().isClosed());
    }

    @Test
    public void testBasicCleanupIterator() throws Exception {
        Handle handle = this.dbi.open();
        Query q = ((Query)handle.createQuery("SELECT COUNT(1) FROM something").cleanupHandle()).map((ResultSetMapper)IntegerMapper.FIRST);
        ResultIterator it = q.iterator();
        Assert.assertEquals((long)100L, (long)((Integer)Iterators.getOnlyElement((Iterator)it)).intValue());
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertTrue((boolean)handle.getConnection().isClosed());
    }

    @Test
    public void testBasicCleanupHalfwayHandle1() throws Exception {
        Handle handle = this.dbi.open();
        Query q = handle.createQuery("SELECT id FROM something").map((ResultSetMapper)IntegerMapper.FIRST);
        ResultIterator it = q.iterator();
        for (int i = 0; i < 50; ++i) {
            Assert.assertTrue((boolean)it.hasNext());
            it.next();
        }
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertFalse((boolean)handle.getConnection().isClosed());
        handle.close();
        Assert.assertTrue((boolean)handle.getConnection().isClosed());
    }

    @Test
    public void testBasicCleanupHalfwayHandle2() throws Exception {
        Handle handle = this.dbi.open();
        Query q = ((Query)handle.createQuery("SELECT id FROM something").cleanupHandle()).map((ResultSetMapper)IntegerMapper.FIRST);
        ResultIterator it = q.iterator();
        for (int i = 0; i < 50; ++i) {
            Assert.assertTrue((boolean)it.hasNext());
            it.next();
        }
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertFalse((boolean)handle.getConnection().isClosed());
        handle.close();
        Assert.assertTrue((boolean)handle.getConnection().isClosed());
    }

    @Test
    public void testBasicCleanupHalfwayIterator() throws Exception {
        Handle handle = this.dbi.open();
        Query q = ((Query)handle.createQuery("SELECT id FROM something").cleanupHandle()).map((ResultSetMapper)IntegerMapper.FIRST);
        ResultIterator it = q.iterator();
        for (int i = 0; i < 50; ++i) {
            Assert.assertTrue((boolean)it.hasNext());
            it.next();
        }
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertFalse((boolean)handle.getConnection().isClosed());
        it.close();
        Assert.assertTrue((boolean)handle.getConnection().isClosed());
    }

    @Test
    public void testDoubleCleanup() throws Exception {
        Handle handle = this.dbi.open();
        Query q = ((Query)((Query)handle.createQuery("SELECT id FROM something").cleanupHandle()).cleanupHandle()).map((ResultSetMapper)IntegerMapper.FIRST);
        ResultIterator it = q.iterator();
        while (it.hasNext()) {
            it.next();
        }
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertTrue((boolean)handle.getConnection().isClosed());
    }

    @Test
    public void testDoubleCleanupHalfwayHandle() throws Exception {
        Handle handle = this.dbi.open();
        Query q = ((Query)((Query)handle.createQuery("SELECT id FROM something").cleanupHandle()).cleanupHandle()).map((ResultSetMapper)IntegerMapper.FIRST);
        ResultIterator it = q.iterator();
        for (int i = 0; i < 50; ++i) {
            Assert.assertTrue((boolean)it.hasNext());
            it.next();
        }
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertFalse((boolean)handle.getConnection().isClosed());
        handle.close();
        Assert.assertTrue((boolean)handle.getConnection().isClosed());
    }

    @Test
    public void testDoubleCleanupHalfwayIterator() throws Exception {
        Handle handle = this.dbi.open();
        Query q = ((Query)((Query)handle.createQuery("SELECT id FROM something").cleanupHandle()).cleanupHandle()).map((ResultSetMapper)IntegerMapper.FIRST);
        ResultIterator it = q.iterator();
        for (int i = 0; i < 50; ++i) {
            Assert.assertTrue((boolean)it.hasNext());
            it.next();
        }
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertFalse((boolean)handle.getConnection().isClosed());
        it.close();
        Assert.assertTrue((boolean)handle.getConnection().isClosed());
    }
}

