/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.PreparedBatchPart;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.StringArgument;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class TestArgumentFactory {
    private DBI dbi;
    private Handle h;

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:" + UUID.randomUUID());
        this.dbi = new DBI((DataSource)ds);
        this.h = this.dbi.open();
        this.h.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.h.execute("drop table something", new Object[0]);
        this.h.close();
    }

    @Test
    public void testRegisterOnDBI() throws Exception {
        this.dbi.registerArgumentFactory((ArgumentFactory)new NameAF());
        Handle h2 = this.dbi.open();
        ((Update)((Update)h2.createStatement("insert into something (id, name) values (:id, :name)").bind("id", 7)).bind("name", (Object)new Name("Brian", "McCallister"))).execute();
        String full_name = (String)this.h.createQuery("select name from something where id = 7").map((ResultSetMapper)StringMapper.FIRST).first();
        Assert.assertThat((Object)full_name, (Matcher)CoreMatchers.equalTo((Object)"Brian McCallister"));
        h2.close();
    }

    @Test
    public void testRegisterOnHandle() throws Exception {
        this.h.registerArgumentFactory((ArgumentFactory)new NameAF());
        ((Update)((Update)this.h.createStatement("insert into something (id, name) values (:id, :name)").bind("id", 7)).bind("name", (Object)new Name("Brian", "McCallister"))).execute();
        String full_name = (String)this.h.createQuery("select name from something where id = 7").map((ResultSetMapper)StringMapper.FIRST).first();
        Assert.assertThat((Object)full_name, (Matcher)CoreMatchers.equalTo((Object)"Brian McCallister"));
    }

    @Test
    public void testRegisterOnStatement() throws Exception {
        ((Update)((Update)((Update)this.h.createStatement("insert into something (id, name) values (:id, :name)").registerArgumentFactory((ArgumentFactory)new NameAF())).bind("id", 1)).bind("name", (Object)new Name("Brian", "McCallister"))).execute();
    }

    @Test
    public void testOnPreparedBatch() throws Exception {
        PreparedBatch batch = this.h.prepareBatch("insert into something (id, name) values (:id, :name)");
        batch.registerArgumentFactory((ArgumentFactory)new NameAF());
        ((PreparedBatchPart)batch.add().bind("id", 1)).bind("name", (Object)new Name("Brian", "McCallister"));
        ((PreparedBatchPart)batch.add().bind("id", 2)).bind("name", (Object)new Name("Henning", "S"));
        batch.execute();
        List rs = this.h.createQuery("select name from something order by id").map((ResultSetMapper)StringMapper.FIRST).list();
        Assert.assertThat(rs.get(0), (Matcher)CoreMatchers.equalTo((Object)"Brian McCallister"));
        Assert.assertThat(rs.get(1), (Matcher)CoreMatchers.equalTo((Object)"Henning S"));
    }

    public static class Name {
        private final String first;
        private final String last;

        public Name(String first, String last) {
            this.first = first;
            this.last = last;
        }

        public String getFullName() {
            return this.first + " " + this.last;
        }

        public String toString() {
            return "<Name first=" + this.first + " last=" + this.last + " >";
        }
    }

    public static class NameAF
    implements ArgumentFactory<Name> {
        public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
            return expectedType == Object.class && value instanceof Name;
        }

        public Argument build(Class<?> expectedType, Name value, StatementContext ctx) {
            return new StringArgument(value.getFullName());
        }
    }
}

