/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.ws;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ws.AbstractBasicTest;
import org.asynchttpclient.ws.EchoSocket;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketByteListener;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.eclipse.jetty.websocket.server.WebSocketHandler;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ByteMessageTest
extends AbstractBasicTest {
    @Override
    public WebSocketHandler getWebSocketHandler() {
        return new WebSocketHandler(){

            public void configure(WebSocketServletFactory factory) {
                factory.register(EchoSocket.class);
            }
        };
    }

    @Test(groups={"standalone"})
    public void echoByte() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<byte[]> text = new AtomicReference<byte[]>(new byte[0]);
            WebSocket websocket = (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketByteListener(){

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }

                public void onMessage(byte[] message) {
                    text.set(message);
                    latch.countDown();
                }
            }).build()).get();
            websocket.sendMessage("ECHO".getBytes());
            latch.await();
            Assert.assertEquals((Object)text.get(), (Object)"ECHO".getBytes());
        }
    }

    @Test(groups={"standalone"})
    public void echoTwoMessagesTest() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(2);
            final AtomicReference<Object> text = new AtomicReference<Object>(null);
            WebSocket websocket = (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketByteListener(){

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }

                public void onMessage(byte[] message) {
                    if (text.get() == null) {
                        text.set(message);
                    } else {
                        byte[] n = new byte[((byte[])text.get()).length + message.length];
                        System.arraycopy(text.get(), 0, n, 0, ((byte[])text.get()).length);
                        System.arraycopy(message, 0, n, ((byte[])text.get()).length, message.length);
                        text.set(n);
                    }
                    latch.countDown();
                }
            }).build()).get();
            websocket.sendMessage("ECHO".getBytes()).sendMessage("ECHO".getBytes());
            latch.await();
            Assert.assertEquals(text.get(), (Object)"ECHOECHO".getBytes());
        }
    }

    @Test
    public void echoOnOpenMessagesTest() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(2);
            final AtomicReference<Object> text = new AtomicReference<Object>(null);
            c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketByteListener(){

                public void onOpen(WebSocket websocket) {
                    websocket.sendMessage("ECHO".getBytes()).sendMessage("ECHO".getBytes());
                }

                public void onClose(WebSocket websocket) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }

                public void onMessage(byte[] message) {
                    if (text.get() == null) {
                        text.set(message);
                    } else {
                        byte[] n = new byte[((byte[])text.get()).length + message.length];
                        System.arraycopy(text.get(), 0, n, 0, ((byte[])text.get()).length);
                        System.arraycopy(message, 0, n, ((byte[])text.get()).length, message.length);
                        text.set(n);
                    }
                    latch.countDown();
                }
            }).build()).get();
            latch.await();
            Assert.assertEquals(text.get(), (Object)"ECHOECHO".getBytes());
        }
    }

    public void echoFragments() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<Object> text = new AtomicReference<Object>(null);
            WebSocket websocket = (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketByteListener(){

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }

                public void onMessage(byte[] message) {
                    if (text.get() == null) {
                        text.set(message);
                    } else {
                        byte[] n = new byte[((byte[])text.get()).length + message.length];
                        System.arraycopy(text.get(), 0, n, 0, ((byte[])text.get()).length);
                        System.arraycopy(message, 0, n, ((byte[])text.get()).length, message.length);
                        text.set(n);
                    }
                    latch.countDown();
                }
            }).build()).get();
            websocket.stream("ECHO".getBytes(), false);
            websocket.stream("ECHO".getBytes(), true);
            latch.await();
            Assert.assertEquals(text.get(), (Object)"ECHOECHO".getBytes());
        }
    }
}

