/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.handler.resumable;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hive.druid.io.netty.handler.codec.http.DefaultHttpHeaders;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaders;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Request;
import org.asynchttpclient.handler.resumable.MapResumableProcessor;
import org.asynchttpclient.handler.resumable.ResumableAsyncHandler;
import org.asynchttpclient.handler.resumable.ResumableListener;
import org.asynchttpclient.uri.Uri;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.testng.PowerMockTestCase;
import org.testng.Assert;
import org.testng.annotations.Test;

@PrepareForTest(value={HttpResponseStatus.class, AsyncHandler.State.class})
public class ResumableAsyncHandlerTest
extends PowerMockTestCase {
    @Test
    public void testAdjustRange() {
        MapResumableProcessor proc = new MapResumableProcessor();
        ResumableAsyncHandler handler = new ResumableAsyncHandler((ResumableAsyncHandler.ResumableProcessor)proc);
        Request request = Dsl.get((String)"http://test/url").build();
        Request newRequest = handler.adjustRequestRange(request);
        Assert.assertEquals((Object)newRequest.getUri(), (Object)request.getUri());
        String rangeHeader = newRequest.getHeaders().get("Range");
        Assert.assertNull((Object)rangeHeader);
        proc.put("http://test/url", 5000L);
        newRequest = handler.adjustRequestRange(request);
        Assert.assertEquals((Object)newRequest.getUri(), (Object)request.getUri());
        rangeHeader = newRequest.getHeaders().get("Range");
        Assert.assertEquals((String)rangeHeader, (String)"bytes=5000-");
    }

    @Test
    public void testOnStatusReceivedOkStatus() throws Exception {
        MapResumableProcessor processor = new MapResumableProcessor();
        ResumableAsyncHandler handler = new ResumableAsyncHandler((ResumableAsyncHandler.ResumableProcessor)processor);
        HttpResponseStatus responseStatus200 = (HttpResponseStatus)PowerMockito.mock(HttpResponseStatus.class);
        Mockito.when((Object)responseStatus200.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)responseStatus200.getUri()).thenReturn(PowerMockito.mock(Uri.class));
        AsyncHandler.State state = handler.onStatusReceived(responseStatus200);
        Assert.assertEquals((Object)state, (Object)AsyncHandler.State.CONTINUE, (String)"Status should be CONTINUE for a OK response");
    }

    @Test
    public void testOnStatusReceived206Status() throws Exception {
        MapResumableProcessor processor = new MapResumableProcessor();
        ResumableAsyncHandler handler = new ResumableAsyncHandler((ResumableAsyncHandler.ResumableProcessor)processor);
        HttpResponseStatus responseStatus206 = (HttpResponseStatus)PowerMockito.mock(HttpResponseStatus.class);
        Mockito.when((Object)responseStatus206.getStatusCode()).thenReturn((Object)206);
        Mockito.when((Object)responseStatus206.getUri()).thenReturn(PowerMockito.mock(Uri.class));
        AsyncHandler.State state = handler.onStatusReceived(responseStatus206);
        Assert.assertEquals((Object)state, (Object)AsyncHandler.State.CONTINUE, (String)"Status should be CONTINUE for a 'Partial Content' response");
    }

    @Test
    public void testOnStatusReceivedOkStatusWithDecoratedAsyncHandler() throws Exception {
        HttpResponseStatus mockResponseStatus = (HttpResponseStatus)PowerMockito.mock(HttpResponseStatus.class);
        Mockito.when((Object)mockResponseStatus.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)mockResponseStatus.getUri()).thenReturn(PowerMockito.mock(Uri.class));
        AsyncHandler decoratedAsyncHandler = (AsyncHandler)PowerMockito.mock(AsyncHandler.class);
        AsyncHandler.State mockState = (AsyncHandler.State)PowerMockito.mock(AsyncHandler.State.class);
        Mockito.when((Object)decoratedAsyncHandler.onStatusReceived(mockResponseStatus)).thenReturn((Object)mockState);
        ResumableAsyncHandler handler = new ResumableAsyncHandler(decoratedAsyncHandler);
        AsyncHandler.State state = handler.onStatusReceived(mockResponseStatus);
        ((AsyncHandler)Mockito.verify((Object)decoratedAsyncHandler)).onStatusReceived(mockResponseStatus);
        Assert.assertEquals((Object)state, (Object)mockState, (String)"State returned should be equal to the one returned from decoratedAsyncHandler");
    }

    @Test
    public void testOnStatusReceived500Status() throws Exception {
        MapResumableProcessor processor = new MapResumableProcessor();
        ResumableAsyncHandler handler = new ResumableAsyncHandler((ResumableAsyncHandler.ResumableProcessor)processor);
        HttpResponseStatus mockResponseStatus = (HttpResponseStatus)PowerMockito.mock(HttpResponseStatus.class);
        Mockito.when((Object)mockResponseStatus.getStatusCode()).thenReturn((Object)500);
        Mockito.when((Object)mockResponseStatus.getUri()).thenReturn(PowerMockito.mock(Uri.class));
        AsyncHandler.State state = handler.onStatusReceived(mockResponseStatus);
        Assert.assertEquals((Object)state, (Object)AsyncHandler.State.ABORT, (String)"State should be ABORT for Internal Server Error status");
    }

    @Test
    public void testOnBodyPartReceived() throws Exception {
        ResumableAsyncHandler handler = new ResumableAsyncHandler();
        HttpResponseBodyPart bodyPart = (HttpResponseBodyPart)PowerMockito.mock(HttpResponseBodyPart.class);
        Mockito.when((Object)bodyPart.getBodyPartBytes()).thenReturn((Object)new byte[0]);
        ByteBuffer buffer = ByteBuffer.allocate(0);
        Mockito.when((Object)bodyPart.getBodyByteBuffer()).thenReturn((Object)buffer);
        AsyncHandler.State state = handler.onBodyPartReceived(bodyPart);
        Assert.assertEquals((Object)state, (Object)AsyncHandler.State.CONTINUE, (String)"State should be CONTINUE for a successful onBodyPartReceived");
    }

    @Test
    public void testOnBodyPartReceivedWithResumableListenerThrowsException() throws Exception {
        ResumableAsyncHandler handler = new ResumableAsyncHandler();
        ResumableListener resumableListener = (ResumableListener)PowerMockito.mock(ResumableListener.class);
        ((ResumableListener)Mockito.doThrow((Throwable)new IOException()).when((Object)resumableListener)).onBytesReceived((ByteBuffer)Matchers.anyObject());
        handler.setResumableListener(resumableListener);
        HttpResponseBodyPart bodyPart = (HttpResponseBodyPart)PowerMockito.mock(HttpResponseBodyPart.class);
        AsyncHandler.State state = handler.onBodyPartReceived(bodyPart);
        Assert.assertEquals((Object)state, (Object)AsyncHandler.State.ABORT, (String)"State should be ABORT if the resumableListener threw an exception in onBodyPartReceived");
    }

    @Test
    public void testOnBodyPartReceivedWithDecoratedAsyncHandler() throws Exception {
        HttpResponseBodyPart bodyPart = (HttpResponseBodyPart)PowerMockito.mock(HttpResponseBodyPart.class);
        Mockito.when((Object)bodyPart.getBodyPartBytes()).thenReturn((Object)new byte[0]);
        ByteBuffer buffer = ByteBuffer.allocate(0);
        Mockito.when((Object)bodyPart.getBodyByteBuffer()).thenReturn((Object)buffer);
        AsyncHandler decoratedAsyncHandler = (AsyncHandler)PowerMockito.mock(AsyncHandler.class);
        AsyncHandler.State mockState = (AsyncHandler.State)PowerMockito.mock(AsyncHandler.State.class);
        Mockito.when((Object)decoratedAsyncHandler.onBodyPartReceived(bodyPart)).thenReturn((Object)mockState);
        HttpResponseStatus mockResponseStatus = (HttpResponseStatus)PowerMockito.mock(HttpResponseStatus.class);
        Mockito.when((Object)mockResponseStatus.getStatusCode()).thenReturn((Object)200);
        Uri mockUri = (Uri)PowerMockito.mock(Uri.class);
        Mockito.when((Object)mockUri.toUrl()).thenReturn((Object)"http://non.null");
        Mockito.when((Object)mockResponseStatus.getUri()).thenReturn((Object)mockUri);
        ResumableAsyncHandler handler = new ResumableAsyncHandler(decoratedAsyncHandler);
        handler.onStatusReceived(mockResponseStatus);
        AsyncHandler.State state = handler.onBodyPartReceived(bodyPart);
        Assert.assertEquals((Object)state, (Object)mockState, (String)"State should be equal to the state returned from decoratedAsyncHandler");
    }

    @Test
    public void testOnHeadersReceived() throws Exception {
        ResumableAsyncHandler handler = new ResumableAsyncHandler();
        DefaultHttpHeaders responseHeaders = new DefaultHttpHeaders();
        HttpResponseHeaders headers = new HttpResponseHeaders((HttpHeaders)responseHeaders);
        AsyncHandler.State status = handler.onHeadersReceived(headers);
        Assert.assertEquals((Object)status, (Object)AsyncHandler.State.CONTINUE, (String)"State should be CONTINUE for a successful onHeadersReceived");
    }

    @Test
    public void testOnHeadersReceivedWithDecoratedAsyncHandler() throws Exception {
        DefaultHttpHeaders responseHeaders = new DefaultHttpHeaders();
        HttpResponseHeaders headers = new HttpResponseHeaders((HttpHeaders)responseHeaders);
        AsyncHandler decoratedAsyncHandler = (AsyncHandler)PowerMockito.mock(AsyncHandler.class);
        AsyncHandler.State mockState = (AsyncHandler.State)PowerMockito.mock(AsyncHandler.State.class);
        Mockito.when((Object)decoratedAsyncHandler.onHeadersReceived(headers)).thenReturn((Object)mockState);
        ResumableAsyncHandler handler = new ResumableAsyncHandler(decoratedAsyncHandler);
        AsyncHandler.State status = handler.onHeadersReceived(headers);
        Assert.assertEquals((Object)status, (Object)mockState, (String)"State should be equal to the state returned from decoratedAsyncHandler");
    }

    @Test
    public void testOnHeadersReceivedContentLengthMinus() throws Exception {
        ResumableAsyncHandler handler = new ResumableAsyncHandler();
        DefaultHttpHeaders responseHeaders = new DefaultHttpHeaders();
        responseHeaders.add("Content-Length", (Object)-1);
        HttpResponseHeaders headers = new HttpResponseHeaders((HttpHeaders)responseHeaders);
        AsyncHandler.State status = handler.onHeadersReceived(headers);
        Assert.assertEquals((Object)status, (Object)AsyncHandler.State.ABORT, (String)"State should be ABORT for content length -1");
    }
}

