/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Response;
import org.asynchttpclient.exception.RemotelyClosedException;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AuthTimeoutTest
extends AbstractBasicTest {
    private Server server2;

    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        ServerConnector connector1 = TestUtils.addHttpConnector(this.server);
        TestUtils.addBasicAuthHandler(this.server, (Handler)this.configureHandler());
        this.server.start();
        this.port1 = connector1.getLocalPort();
        this.server2 = new Server();
        ServerConnector connector2 = TestUtils.addHttpConnector(this.server2);
        TestUtils.addDigestAuthHandler(this.server2, (Handler)this.configureHandler());
        this.server2.start();
        this.port2 = connector2.getLocalPort();
        this.logger.info("Local HTTP server started successfully");
    }

    @Override
    @AfterClass(alwaysRun=true)
    public void tearDownGlobal() throws Exception {
        super.tearDownGlobal();
        this.server2.stop();
    }

    @Test(groups={"standalone"}, enabled=false)
    public void basicAuthTimeoutTest() throws Exception {
        try (AsyncHttpClient client = this.newClient();){
            Future<Response> f = this.execute(client, this.server, false);
            f.get();
            Assert.fail((String)"expected timeout");
        }
        catch (Exception e) {
            this.inspectException(e);
        }
    }

    @Test(groups={"standalone"}, enabled=false)
    public void basicPreemptiveAuthTimeoutTest() throws Exception {
        try (AsyncHttpClient client = this.newClient();){
            Future<Response> f = this.execute(client, this.server, true);
            f.get();
            Assert.fail((String)"expected timeout");
        }
        catch (Exception e) {
            this.inspectException(e);
        }
    }

    @Test(groups={"standalone"}, enabled=false)
    public void digestAuthTimeoutTest() throws Exception {
        try (AsyncHttpClient client = this.newClient();){
            Future<Response> f = this.execute(client, this.server2, false);
            f.get();
            Assert.fail((String)"expected timeout");
        }
        catch (Exception e) {
            this.inspectException(e);
        }
    }

    @Test(groups={"standalone"}, enabled=false)
    public void digestPreemptiveAuthTimeoutTest() throws Exception {
        try (AsyncHttpClient client = this.newClient();){
            Future<Response> f = this.execute(client, this.server2, true);
            f.get();
            Assert.fail((String)"expected timeout");
        }
        catch (Exception e) {
            this.inspectException(e);
        }
    }

    @Test(groups={"standalone"}, enabled=false)
    public void basicFutureAuthTimeoutTest() throws Exception {
        try (AsyncHttpClient client = this.newClient();){
            Future<Response> f = this.execute(client, this.server, false);
            f.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"expected timeout");
        }
        catch (Exception e) {
            this.inspectException(e);
        }
    }

    @Test(groups={"standalone"}, enabled=false)
    public void basicFuturePreemptiveAuthTimeoutTest() throws Exception {
        try (AsyncHttpClient client = this.newClient();){
            Future<Response> f = this.execute(client, this.server, true);
            f.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"expected timeout");
        }
        catch (Exception e) {
            this.inspectException(e);
        }
    }

    @Test(groups={"standalone"}, enabled=false)
    public void digestFutureAuthTimeoutTest() throws Exception {
        try (AsyncHttpClient client = this.newClient();){
            Future<Response> f = this.execute(client, this.server2, false);
            f.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"expected timeout");
        }
        catch (Exception e) {
            this.inspectException(e);
        }
    }

    @Test(groups={"standalone"}, enabled=false)
    public void digestFuturePreemptiveAuthTimeoutTest() throws Exception {
        try (AsyncHttpClient client = this.newClient();){
            Future<Response> f = this.execute(client, this.server2, true);
            f.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"expected timeout");
        }
        catch (Exception e) {
            this.inspectException(e);
        }
    }

    protected void inspectException(Throwable t) {
        Assert.assertEquals((Object)t.getCause(), (Object)RemotelyClosedException.INSTANCE);
    }

    private AsyncHttpClient newClient() {
        return Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setPooledConnectionIdleTimeout(2000).setConnectTimeout(20000).setRequestTimeout(2000));
    }

    protected Future<Response> execute(AsyncHttpClient client, Server server, boolean preemptive) throws IOException {
        return ((BoundRequestBuilder)((BoundRequestBuilder)client.prepareGet(this.getTargetUrl()).setRealm(this.realm(preemptive))).setHeader((CharSequence)"X-Content", "Test")).execute();
    }

    private Realm realm(boolean preemptive) {
        return Dsl.basicAuthRealm((String)"user", (String)"admin").setUsePreemptiveAuth(preemptive).build();
    }

    @Override
    protected String getTargetUrl() {
        return "http://localhost:" + this.port1 + "/";
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new IncompleteResponseHandler();
    }

    private class IncompleteResponseHandler
    extends AbstractHandler {
        private IncompleteResponseHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            ServletOutputStream out = response.getOutputStream();
            if (request.getHeader("X-Content") != null) {
                String content = request.getHeader("X-Content");
                response.setHeader("Content-Length", String.valueOf(content.getBytes(StandardCharsets.UTF_8).length));
                out.write(content.substring(1).getBytes(StandardCharsets.UTF_8));
            } else {
                response.setStatus(200);
            }
            out.flush();
            out.close();
        }
    }
}

