/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import org.apache.hive.druid.org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.hive.druid.org.apache.calcite.schema.Schema;
import org.apache.hive.druid.org.apache.calcite.schema.SchemaPlus;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExceptionMessageTest {
    private Connection conn;

    @Before
    public void setUp() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        rootSchema.add("test", (Schema)new ReflectiveSchema((Object)new TestSchema()));
        calciteConnection.setSchema("test");
        this.conn = calciteConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQuery(String sql) throws SQLException {
        Statement stmt = this.conn.createStatement();
        try {
            stmt.executeQuery(sql);
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e) {
                Assert.fail((String)"Error on close");
            }
        }
    }

    @Test
    public void testValidQuery() throws SQLException {
        this.runQuery("select * from \"entries\"");
    }

    @Test
    public void testNonSqlException() throws SQLException {
        try {
            this.runQuery("select * from \"badEntries\"");
            Assert.fail((String)"Query badEntries should result in an exception");
        }
        catch (SQLException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Error while executing SQL \"select * from \"badEntries\"\": Can't iterate over badEntries"));
        }
    }

    @Test
    public void testSyntaxError() {
        try {
            this.runQuery("invalid sql");
            Assert.fail((String)"Query should fail");
        }
        catch (SQLException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Error while executing SQL \"invalid sql\": parse failed: Non-query expression encountered in illegal context"));
        }
    }

    @Test
    public void testSemanticError() {
        try {
            this.runQuery("select \"name\" - \"id\" from \"entries\"");
            Assert.fail((String)"Query with semantic error should fail");
        }
        catch (SQLException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot apply '-' to arguments"));
        }
    }

    @Test
    public void testNonexistentTable() {
        try {
            this.runQuery("select name from \"nonexistentTable\"");
            Assert.fail((String)"Query should fail");
        }
        catch (SQLException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Object 'nonexistentTable' not found"));
        }
    }

    public static class Entry {
        public int id;
        public String name;

        public Entry(int id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    public static class TestSchema {
        public Entry[] entries = new Entry[]{new Entry(1, "name1"), new Entry(2, "name2")};
        public Iterable<Entry> badEntries = new Iterable<Entry>(){

            @Override
            public Iterator<Entry> iterator() {
                throw new IllegalStateException("Can't iterate over badEntries");
            }
        };
    }
}

