/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.test;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Functions;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.cache.CacheBuilder;
import org.apache.hive.druid.com.google.common.cache.CacheLoader;
import org.apache.hive.druid.com.google.common.cache.LoadingCache;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableMultiset;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.hive.druid.org.apache.calcite.DataContext;
import org.apache.hive.druid.org.apache.calcite.adapter.clone.CloneSchema;
import org.apache.hive.druid.org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.hive.druid.org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.hive.druid.org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.hive.druid.org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.hive.druid.org.apache.calcite.config.Lex;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteMetaImpl;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.hive.druid.org.apache.calcite.materialize.Lattice;
import org.apache.hive.druid.org.apache.calcite.model.ModelHandler;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.runtime.CalciteException;
import org.apache.hive.druid.org.apache.calcite.runtime.FlatLists;
import org.apache.hive.druid.org.apache.calcite.runtime.GeoFunctions;
import org.apache.hive.druid.org.apache.calcite.runtime.Hook;
import org.apache.hive.druid.org.apache.calcite.schema.Schema;
import org.apache.hive.druid.org.apache.calcite.schema.SchemaPlus;
import org.apache.hive.druid.org.apache.calcite.schema.Table;
import org.apache.hive.druid.org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.hive.druid.org.apache.calcite.schema.impl.ViewTable;
import org.apache.hive.druid.org.apache.calcite.schema.impl.ViewTableMacro;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.hive.druid.org.apache.calcite.test.ConnectionSpec;
import org.apache.hive.druid.org.apache.calcite.test.CountriesTableFunction;
import org.apache.hive.druid.org.apache.calcite.test.JdbcTest;
import org.apache.hive.druid.org.apache.calcite.test.Matchers;
import org.apache.hive.druid.org.apache.calcite.test.StreamTest;
import org.apache.hive.druid.org.apache.calcite.tools.FrameworkConfig;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;
import org.apache.hive.druid.org.apache.calcite.util.Closer;
import org.apache.hive.druid.org.apache.calcite.util.Holder;
import org.apache.hive.druid.org.apache.calcite.util.JsonBuilder;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;

public class CalciteAssert {
    public static final DatabaseInstance DB = DatabaseInstance.valueOf(((String)Util.first((Object)System.getProperty("calcite.test.db"), (Object)"HSQLDB")).toUpperCase(Locale.ROOT));
    public static final boolean ENABLE_SLOW = Util.getBooleanProperty((String)"calcite.test.slow");
    private static final DateFormat UTC_DATE_FORMAT;
    private static final DateFormat UTC_TIME_FORMAT;
    private static final DateFormat UTC_TIMESTAMP_FORMAT;
    public static final ConnectionFactory EMPTY_CONNECTION_FACTORY;
    private static final AssertThat DISABLED;

    private CalciteAssert() {
    }

    public static AssertThat that() {
        return AssertThat.EMPTY;
    }

    public static AssertThat that(Config config) {
        return CalciteAssert.that().with(config);
    }

    public static AssertThat model(String model) {
        return CalciteAssert.that().withModel(model);
    }

    public static AssertThat hr() {
        return CalciteAssert.that(Config.REGULAR);
    }

    static Function<RelNode, Void> checkRel(final String expected, final AtomicInteger counter) {
        return new Function<RelNode, Void>(){

            public Void apply(RelNode relNode) {
                if (counter != null) {
                    counter.incrementAndGet();
                }
                String s = RelOptUtil.toString((RelNode)relNode);
                Assert.assertThat((Object)s, Matchers.containsStringLinux(expected));
                return null;
            }
        };
    }

    static Function<Throwable, Void> checkException(final String expected) {
        return new Function<Throwable, Void>(){

            public Void apply(Throwable p0) {
                Assert.assertNotNull((String)"expected exception but none was thrown", (Object)p0);
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                p0.printStackTrace(printWriter);
                printWriter.flush();
                String stack = stringWriter.toString();
                Assert.assertTrue((String)stack, (boolean)stack.contains(expected));
                return null;
            }
        };
    }

    static Function<Throwable, Void> checkValidationException(final String expected) {
        return new Function<Throwable, Void>(){

            @Nullable
            public Void apply(@Nullable Throwable throwable) {
                Assert.assertNotNull((String)"Nothing was thrown", (Object)throwable);
                Exception exception = this.containsCorrectException(throwable);
                Assert.assertTrue((String)"Expected to fail at validation, but did not", (exception != null ? 1 : 0) != 0);
                if (expected != null) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    exception.printStackTrace(printWriter);
                    printWriter.flush();
                    String stack = stringWriter.toString();
                    Assert.assertTrue((String)stack, (boolean)stack.contains(expected));
                }
                return null;
            }

            private boolean isCorrectException(Throwable throwable) {
                return throwable instanceof SqlValidatorException || throwable instanceof CalciteException;
            }

            private Exception containsCorrectException(Throwable root) {
                for (Throwable currentCause = root; currentCause != null; currentCause = currentCause.getCause()) {
                    if (!this.isCorrectException(currentCause)) continue;
                    return (Exception)currentCause;
                }
                return null;
            }
        };
    }

    static Function<ResultSet, Void> checkResult(String expected) {
        return CalciteAssert.checkResult(expected, new ResultSetFormatter());
    }

    static Function<ResultSet, Void> checkResult(final String expected, final ResultSetFormatter resultSetFormatter) {
        return new Function<ResultSet, Void>(){

            public Void apply(ResultSet resultSet) {
                try {
                    resultSetFormatter.resultSet(resultSet);
                    Assert.assertThat((Object)resultSetFormatter.string(), Matchers.isLinux(expected));
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    static Function<ResultSet, Void> checkResultValue(final String expected) {
        return new Function<ResultSet, Void>(){

            public Void apply(ResultSet resultSet) {
                try {
                    if (!resultSet.next()) {
                        throw new AssertionError((Object)"too few rows");
                    }
                    if (resultSet.getMetaData().getColumnCount() != 1) {
                        throw new AssertionError((Object)"expected 1 column");
                    }
                    String resultString = resultSet.getString(1);
                    Assert.assertThat((Object)resultString, expected == null ? CoreMatchers.nullValue(String.class) : Matchers.isLinux(expected));
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static Function<ResultSet, Void> checkResultCount(final org.hamcrest.Matcher<Integer> expected) {
        return new Function<ResultSet, Void>(){

            public Void apply(ResultSet resultSet) {
                try {
                    int count = CalciteAssert.countRows(resultSet);
                    Assert.assertThat((Object)count, (org.hamcrest.Matcher)expected);
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static Function<Integer, Void> checkUpdateCount(final int expected) {
        return new Function<Integer, Void>(){

            public Void apply(Integer updateCount) {
                Assert.assertThat((Object)updateCount, (org.hamcrest.Matcher)CoreMatchers.is((Object)expected));
                return null;
            }
        };
    }

    static Function<ResultSet, Void> consistentResult(final boolean ordered) {
        return new Function<ResultSet, Void>(){
            int executeCount = 0;
            Collection expected;

            public Void apply(ResultSet resultSet) {
                ++this.executeCount;
                try {
                    Collection<String> result = CalciteAssert.toStringList(resultSet, ordered ? new ArrayList() : new TreeSet());
                    if (this.executeCount == 1) {
                        this.expected = result;
                    } else if (!this.expected.equals(result)) {
                        Assert.assertThat((Object)CalciteAssert.newlineList(result), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)CalciteAssert.newlineList(this.expected)));
                        Assert.fail((String)"oops");
                    }
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    static String newlineList(Collection collection) {
        StringBuilder buf = new StringBuilder();
        for (Object o : collection) {
            buf.append(o).append('\n');
        }
        return buf.toString();
    }

    static Function<ResultSet, Void> checkResultUnordered(String ... lines) {
        return CalciteAssert.checkResult(true, false, lines);
    }

    static Function<ResultSet, Void> checkResult(final boolean sort, final boolean head, final String ... lines) {
        return new Function<ResultSet, Void>(){

            public Void apply(ResultSet resultSet) {
                try {
                    List trimmedActualList;
                    ArrayList expectedList = Lists.newArrayList((Object[])lines);
                    if (sort) {
                        Collections.sort(expectedList);
                    }
                    ArrayList actualList = Lists.newArrayList();
                    CalciteAssert.toStringList(resultSet, actualList);
                    if (sort) {
                        Collections.sort(actualList);
                    }
                    if (!(trimmedActualList = head && actualList.size() > expectedList.size() ? actualList.subList(0, expectedList.size()) : actualList).equals(expectedList)) {
                        Assert.assertThat((Object)Util.lines((Iterable)trimmedActualList), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)Util.lines((Iterable)expectedList)));
                    }
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static Function<ResultSet, Void> checkResultContains(final String ... expected) {
        return new Function<ResultSet, Void>(){

            public Void apply(ResultSet s) {
                try {
                    String actual = CalciteAssert.toString(s);
                    for (String st : expected) {
                        Assert.assertThat((Object)actual, Matchers.containsStringLinux(st));
                    }
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static Function<ResultSet, Void> checkResultContains(final String expected, final int count) {
        return new Function<ResultSet, Void>(){

            public Void apply(ResultSet s) {
                try {
                    String actual = Util.toLinux((String)CalciteAssert.toString(s));
                    Assert.assertTrue((String)(actual + " should have " + count + " occurrence of " + expected), (StringUtils.countMatches((CharSequence)actual, (CharSequence)expected) == count ? 1 : 0) != 0);
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static Function<ResultSet, Void> checkMaskedResultContains(final String expected) {
        return new Function<ResultSet, Void>(){

            public Void apply(ResultSet s) {
                try {
                    String actual = Util.toLinux((String)CalciteAssert.toString(s));
                    String maskedActual = actual.replaceAll(", id = [0-9]+", "");
                    Assert.assertThat((Object)maskedActual, (org.hamcrest.Matcher)CoreMatchers.containsString((String)expected));
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static Function<ResultSet, Void> checkResultType(final String expected) {
        return new Function<ResultSet, Void>(){

            public Void apply(ResultSet s) {
                try {
                    String actual = CalciteAssert.typeString(s.getMetaData());
                    Assert.assertEquals((Object)expected, (Object)actual);
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private static String typeString(ResultSetMetaData metaData) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < metaData.getColumnCount(); ++i) {
            list.add(metaData.getColumnName(i + 1) + " " + metaData.getColumnTypeName(i + 1) + (metaData.isNullable(i + 1) == 0 ? " NOT NULL" : ""));
        }
        return ((Object)list).toString();
    }

    /*
     * WARNING - void declaration
     */
    static void assertQuery(Connection connection, String sql, int limit, boolean materializationsEnabled, List<Pair<Hook, Function>> hooks, Function<ResultSet, Void> resultChecker, Function<Integer, Void> updateChecker, Function<Throwable, Void> exceptionChecker) throws Exception {
        String message = "With materializationsEnabled=" + materializationsEnabled + ", limit=" + limit;
        try {
            void var12_19;
            Integer updateCount;
            Statement statement;
            block32: {
                try (Closer closer = new Closer();){
                    if (connection instanceof CalciteConnection) {
                        CalciteConnection calciteConnection = (CalciteConnection)connection;
                        calciteConnection.getProperties().setProperty(CalciteConnectionProperty.MATERIALIZATIONS_ENABLED.camelName(), Boolean.toString(materializationsEnabled));
                        calciteConnection.getProperties().setProperty(CalciteConnectionProperty.CREATE_MATERIALIZATIONS.camelName(), Boolean.toString(materializationsEnabled));
                        if (!calciteConnection.getProperties().containsKey(CalciteConnectionProperty.TIME_ZONE.camelName())) {
                            calciteConnection.getProperties().setProperty(CalciteConnectionProperty.TIME_ZONE.camelName(), DateTimeUtils.UTC_ZONE.getID());
                        }
                    }
                    for (Pair pair : hooks) {
                        closer.add((AutoCloseable)((Hook)pair.left).addThread((Function)pair.right));
                    }
                    statement = connection.createStatement();
                    statement.setMaxRows(limit <= 0 ? limit : Math.max(limit, 1));
                    Object var12_17 = null;
                    updateCount = null;
                    try {
                        if (updateChecker == null) {
                            ResultSet resultSet = statement.executeQuery(sql);
                        } else {
                            updateCount = statement.executeUpdate(sql);
                        }
                        if (exceptionChecker != null) {
                            exceptionChecker.apply(null);
                            return;
                        }
                    }
                    catch (Error | Exception e) {
                        if (exceptionChecker != null) {
                            exceptionChecker.apply((Object)e);
                            return;
                        }
                        throw e;
                    }
                    if (resultChecker == null) break block32;
                }
                resultChecker.apply((Object)var12_19);
            }
            if (updateChecker != null) {
                updateChecker.apply((Object)updateCount);
            }
            if (var12_19 != null) {
                var12_19.close();
            }
            statement.close();
            connection.close();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(message, e);
        }
    }

    static void assertPrepare(Connection connection, String sql, boolean materializationsEnabled, final Function<RelNode, Void> convertChecker, final Function<RelNode, Void> substitutionChecker) throws Exception {
        String message = "With materializationsEnabled=" + materializationsEnabled;
        try (Closer closer = new Closer();){
            if (convertChecker != null) {
                closer.add((AutoCloseable)Hook.TRIMMED.addThread((Function)new Function<RelNode, Void>(){

                    public Void apply(RelNode rel) {
                        convertChecker.apply((Object)rel);
                        return null;
                    }
                }));
            }
            if (substitutionChecker != null) {
                closer.add((AutoCloseable)Hook.SUB.addThread((Function)new Function<RelNode, Void>(){

                    public Void apply(RelNode rel) {
                        substitutionChecker.apply((Object)rel);
                        return null;
                    }
                }));
            }
            ((CalciteConnection)connection).getProperties().setProperty(CalciteConnectionProperty.MATERIALIZATIONS_ENABLED.camelName(), Boolean.toString(materializationsEnabled));
            ((CalciteConnection)connection).getProperties().setProperty(CalciteConnectionProperty.CREATE_MATERIALIZATIONS.camelName(), Boolean.toString(materializationsEnabled));
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.close();
            connection.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(message, e);
        }
    }

    static String toString(ResultSet resultSet) throws SQLException {
        return new ResultSetFormatter().resultSet(resultSet).string();
    }

    static int countRows(ResultSet resultSet) throws SQLException {
        int n = 0;
        while (resultSet.next()) {
            ++n;
        }
        return n;
    }

    static Collection<String> toStringList(ResultSet resultSet, Collection<String> list) throws SQLException {
        return new ResultSetFormatter().toStringList(resultSet, list);
    }

    static List<String> toList(ResultSet resultSet) throws SQLException {
        return (List)CalciteAssert.toStringList(resultSet, new ArrayList<String>());
    }

    static ImmutableMultiset<String> toSet(ResultSet resultSet) throws SQLException {
        return ImmutableMultiset.copyOf(CalciteAssert.toList(resultSet));
    }

    static Object call(Object o, String methodName, Object ... args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return CalciteAssert.method(o, methodName, args).invoke(o, args);
    }

    /*
     * Unable to fully structure code
     */
    static Method method(Object o, String methodName, Object[] args) {
        aClass = o.getClass();
        while (true) lbl-1000:
        // 5 sources

        {
            block1: for (Method method1 : aClass.getMethods()) {
                if (!method1.getName().equals(methodName) || method1.getParameterTypes().length != args.length || !Modifier.isPublic(method1.getDeclaringClass().getModifiers())) continue;
                for (Pair pair : Pair.zip((Object[])args, (Object[])method1.getParameterTypes())) {
                    if (((Class)pair.right).isInstance(pair.left)) continue;
                    continue block1;
                }
                return method1;
            }
            if (aClass.getSuperclass() != null && aClass.getSuperclass() != Object.class) {
                aClass = aClass.getSuperclass();
                ** continue;
            }
            interfaces = aClass.getInterfaces();
            if (interfaces.length <= 0) break;
            aClass = interfaces[0];
        }
        throw new AssertionError((Object)("method " + methodName + " not found"));
    }

    public static SchemaPlus addSchema(SchemaPlus rootSchema, SchemaSpec schema) {
        switch (schema) {
            case REFLECTIVE_FOODMART: {
                return rootSchema.add("foodmart", (Schema)new ReflectiveSchema((Object)new JdbcTest.FoodmartSchema()));
            }
            case JDBC_SCOTT: {
                ConnectionSpec cs = DatabaseInstance.HSQLDB.scott;
                DataSource dataSource = JdbcSchema.dataSource((String)cs.url, (String)cs.driver, (String)cs.username, (String)cs.password);
                return rootSchema.add("JDBC_SCOTT", (Schema)JdbcSchema.create((SchemaPlus)rootSchema, (String)"JDBC_SCOTT", (DataSource)dataSource, (String)cs.catalog, (String)cs.schema));
            }
            case JDBC_FOODMART: {
                ConnectionSpec cs = CalciteAssert.DB.foodmart;
                DataSource dataSource = JdbcSchema.dataSource((String)cs.url, (String)cs.driver, (String)cs.username, (String)cs.password);
                return rootSchema.add("foodmart", (Schema)JdbcSchema.create((SchemaPlus)rootSchema, (String)"foodmart", (DataSource)dataSource, (String)cs.catalog, (String)cs.schema));
            }
            case JDBC_FOODMART_WITH_LATTICE: {
                SchemaPlus foodmart = rootSchema.getSubSchema("foodmart");
                if (foodmart == null) {
                    foodmart = CalciteAssert.addSchema(rootSchema, SchemaSpec.JDBC_FOODMART);
                }
                foodmart.add("lattice", Lattice.create((CalciteSchema)((CalciteSchema)foodmart.unwrap(CalciteSchema.class)), (String)"select 1 from \"foodmart\".\"sales_fact_1997\" as s\njoin \"foodmart\".\"time_by_day\" as t using (\"time_id\")\njoin \"foodmart\".\"customer\" as c using (\"customer_id\")\njoin \"foodmart\".\"product\" as p using (\"product_id\")\njoin \"foodmart\".\"product_class\" as pc on p.\"product_class_id\" = pc.\"product_class_id\"", (boolean)true));
                return foodmart;
            }
            case SCOTT: {
                SchemaPlus jdbcScott = rootSchema.getSubSchema("jdbc_scott");
                if (jdbcScott == null) {
                    jdbcScott = CalciteAssert.addSchema(rootSchema, SchemaSpec.JDBC_SCOTT);
                }
                return rootSchema.add("scott", (Schema)new CloneSchema(jdbcScott));
            }
            case CLONE_FOODMART: {
                SchemaPlus foodmart = rootSchema.getSubSchema("foodmart");
                if (foodmart == null) {
                    foodmart = CalciteAssert.addSchema(rootSchema, SchemaSpec.JDBC_FOODMART);
                }
                return rootSchema.add("foodmart2", (Schema)new CloneSchema(foodmart));
            }
            case GEO: {
                ModelHandler.addFunctions((SchemaPlus)rootSchema, null, (List)ImmutableList.of(), (String)GeoFunctions.class.getName(), (String)"*", (boolean)true);
                SchemaPlus s = rootSchema.add("GEO", (Schema)new AbstractSchema());
                ModelHandler.addFunctions((SchemaPlus)s, (String)"countries", (List)ImmutableList.of(), (String)CountriesTableFunction.class.getName(), null, (boolean)false);
                String sql = "select * from table(\"countries\"(true))";
                ViewTableMacro viewMacro = ViewTable.viewMacro((SchemaPlus)rootSchema, (String)"select * from table(\"countries\"(true))", (List)ImmutableList.of((Object)"GEO"), (List)ImmutableList.of(), (Boolean)false);
                s.add("countries", (org.apache.hive.druid.org.apache.calcite.schema.Function)viewMacro);
                return s;
            }
            case HR: {
                return rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
            }
            case LINGUAL: {
                return rootSchema.add("SALES", (Schema)new ReflectiveSchema((Object)new JdbcTest.LingualSchema()));
            }
            case BLANK: {
                return rootSchema.add("BLANK", (Schema)new AbstractSchema());
            }
            case ORINOCO: {
                SchemaPlus orinoco = rootSchema.add("ORINOCO", (Schema)new AbstractSchema());
                orinoco.add("ORDERS", (Table)new StreamTest.OrdersHistoryTable(StreamTest.OrdersStreamTableFactory.getRowList()));
                return orinoco;
            }
            case POST: {
                SchemaPlus post = rootSchema.add("POST", (Schema)new AbstractSchema());
                post.add("EMP", (org.apache.hive.druid.org.apache.calcite.schema.Function)ViewTable.viewMacro((SchemaPlus)post, (String)"select * from (values\n    ('Jane', 10, 'F'),\n    ('Bob', 10, 'M'),\n    ('Eric', 20, 'M'),\n    ('Susan', 30, 'F'),\n    ('Alice', 30, 'F'),\n    ('Adam', 50, 'M'),\n    ('Eve', 50, 'F'),\n    ('Grace', 60, 'F'),\n    ('Wilma', cast(null as integer), 'F'))\n  as t(ename, deptno, gender)", (List)ImmutableList.of(), (List)ImmutableList.of((Object)"POST", (Object)"EMP"), null));
                post.add("DEPT", (org.apache.hive.druid.org.apache.calcite.schema.Function)ViewTable.viewMacro((SchemaPlus)post, (String)"select * from (values\n    (10, 'Sales'),\n    (20, 'Marketing'),\n    (30, 'Engineering'),\n    (40, 'Empty')) as t(deptno, dname)", (List)ImmutableList.of(), (List)ImmutableList.of((Object)"POST", (Object)"DEPT"), null));
                post.add("EMPS", (org.apache.hive.druid.org.apache.calcite.schema.Function)ViewTable.viewMacro((SchemaPlus)post, (String)"select * from (values\n    (100, 'Fred',  10, CAST(NULL AS CHAR(1)), CAST(NULL AS VARCHAR(20)), 40,               25, TRUE,    FALSE, DATE '1996-08-03'),\n    (110, 'Eric',  20, 'M',                   'San Francisco',           3,                80, UNKNOWN, FALSE, DATE '2001-01-01'),\n    (110, 'John',  40, 'M',                   'Vancouver',               2, CAST(NULL AS INT), FALSE,   TRUE,  DATE '2002-05-03'),\n    (120, 'Wilma', 20, 'F',                   CAST(NULL AS VARCHAR(20)), 1,                 5, UNKNOWN, TRUE,  DATE '2005-09-07'),\n    (130, 'Alice', 40, 'F',                   'Vancouver',               2, CAST(NULL AS INT), FALSE,   TRUE,  DATE '2007-01-01'))\n as t(empno, name, deptno, gender, city, empid, age, slacker, manager, joinedat)", (List)ImmutableList.of(), (List)ImmutableList.of((Object)"POST", (Object)"EMPS"), null));
                return post;
            }
        }
        throw new AssertionError((Object)("unknown schema " + (Object)((Object)schema)));
    }

    public static void assertArrayEqual(String message, Object[] expected, Object[] actual) {
        Joiner joiner = Joiner.on((char)'\n');
        String strExpected = expected == null ? null : joiner.join(expected);
        String strActual = actual == null ? null : joiner.join(actual);
        Assert.assertEquals((String)message, (Object)strExpected, (Object)strActual);
    }

    static <F, T> Function<F, T> constantNull() {
        return Functions.constant(null);
    }

    static PropBuilder propBuilder() {
        return new PropBuilder();
    }

    static {
        TimeZone utc = DateTimeUtils.UTC_ZONE;
        UTC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
        UTC_DATE_FORMAT.setTimeZone(utc);
        UTC_TIME_FORMAT = new SimpleDateFormat("HH:mm:ss", Locale.ROOT);
        UTC_TIME_FORMAT.setTimeZone(utc);
        UTC_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT);
        UTC_TIMESTAMP_FORMAT.setTimeZone(utc);
        EMPTY_CONNECTION_FACTORY = new MapConnectionFactory(ImmutableMap.of(), ImmutableList.of());
        DISABLED = new AssertThat(EMPTY_CONNECTION_FACTORY){

            @Override
            public AssertThat with(Config config) {
                return this;
            }

            @Override
            public AssertThat with(ConnectionFactory connectionFactory) {
                return this;
            }

            @Override
            public AssertThat with(String property, Object value) {
                return this;
            }

            @Override
            public AssertThat withSchema(String name, Schema schema) {
                return this;
            }

            @Override
            public AssertQuery query(String sql) {
                return NopAssertQuery.of(sql);
            }

            @Override
            public AssertThat connectThrows(Function<Throwable, Void> exceptionChecker) {
                return this;
            }

            @Override
            public <T> AssertThat doWithConnection(Function<CalciteConnection, T> fn) throws Exception {
                return this;
            }

            @Override
            public AssertThat withDefaultSchema(String schema) {
                return this;
            }

            @Override
            public AssertThat with(SchemaSpec ... specs) {
                return this;
            }

            @Override
            public AssertThat with(Lex lex) {
                return this;
            }

            @Override
            public AssertThat with(ConnectionPostProcessor postProcessor) {
                return this;
            }

            @Override
            public AssertThat enable(boolean enabled) {
                return this;
            }

            @Override
            public AssertThat pooled() {
                return this;
            }
        };
    }

    static class PropBuilder {
        final Properties properties = new Properties();

        PropBuilder() {
        }

        PropBuilder set(CalciteConnectionProperty p, String v) {
            this.properties.setProperty(p.camelName(), v);
            return this;
        }

        Properties build() {
            return this.properties;
        }
    }

    static class ResultSetFormatter {
        final StringBuilder buf = new StringBuilder();

        ResultSetFormatter() {
        }

        public ResultSetFormatter resultSet(ResultSet resultSet) throws SQLException {
            ResultSetMetaData metaData = resultSet.getMetaData();
            while (resultSet.next()) {
                this.rowToString(resultSet, metaData);
                this.buf.append("\n");
            }
            return this;
        }

        ResultSetFormatter rowToString(ResultSet resultSet, ResultSetMetaData metaData) throws SQLException {
            int n = metaData.getColumnCount();
            if (n > 0) {
                int i = 1;
                while (true) {
                    this.buf.append(metaData.getColumnLabel(i)).append("=").append(this.adjustValue(resultSet.getString(i)));
                    if (i == n) break;
                    this.buf.append("; ");
                    ++i;
                }
            }
            return this;
        }

        protected String adjustValue(String string) {
            return string;
        }

        public Collection<String> toStringList(ResultSet resultSet, Collection<String> list) throws SQLException {
            ResultSetMetaData metaData = resultSet.getMetaData();
            while (resultSet.next()) {
                this.rowToString(resultSet, metaData);
                list.add(this.buf.toString());
                this.buf.setLength(0);
            }
            return list;
        }

        public String string() {
            String s = this.buf.toString();
            this.buf.setLength(0);
            return s;
        }
    }

    public static enum SchemaSpec {
        REFLECTIVE_FOODMART,
        JDBC_FOODMART,
        CLONE_FOODMART,
        JDBC_FOODMART_WITH_LATTICE,
        GEO,
        HR,
        JDBC_SCOTT,
        SCOTT,
        BLANK,
        LINGUAL,
        POST,
        ORINOCO;

    }

    public static enum DatabaseInstance {
        HSQLDB(new ConnectionSpec("jdbc:hsqldb:res:foodmart", "FOODMART", "FOODMART", "org.hsqldb.jdbcDriver", "foodmart"), new ConnectionSpec("jdbc:hsqldb:res:scott", "SCOTT", "TIGER", "org.hsqldb.jdbcDriver", "SCOTT")),
        H2(new ConnectionSpec("jdbc:h2:" + DatabaseInstance.getDataSetPath() + "/h2/target/foodmart;user=foodmart;password=foodmart", "foodmart", "foodmart", "org.h2.Driver", "foodmart"), null),
        MYSQL(new ConnectionSpec("jdbc:mysql://localhost/foodmart", "foodmart", "foodmart", "com.mysql.jdbc.Driver", "foodmart"), null),
        ORACLE(new ConnectionSpec("jdbc:oracle:thin:@localhost:1521:XE", "foodmart", "foodmart", "oracle.jdbc.OracleDriver", "FOODMART"), null),
        POSTGRESQL(new ConnectionSpec("jdbc:postgresql://localhost/foodmart?user=foodmart&password=foodmart&searchpath=foodmart", "foodmart", "foodmart", "org.postgresql.Driver", "foodmart"), null);

        public final ConnectionSpec foodmart;
        public final ConnectionSpec scott;

        private static String getDataSetPath() {
            String[] dirs;
            String path = System.getProperty("calcite.test.dataset");
            if (path != null) {
                return path;
            }
            for (String s : dirs = new String[]{"../calcite-test-dataset", "../../calcite-test-dataset"}) {
                if (!new File(s).exists() || !new File(s, "vm").exists()) continue;
                return s;
            }
            return ".";
        }

        private DatabaseInstance(ConnectionSpec foodmart, ConnectionSpec scott) {
            this.foodmart = foodmart;
            this.scott = scott;
        }
    }

    private static class NopAssertQuery
    extends AssertQuery {
        private NopAssertQuery(String sql) {
            super(null, sql);
        }

        static AssertQuery of(String sql) {
            return new NopAssertQuery(sql);
        }

        @Override
        protected Connection createConnection() throws Exception {
            throw new AssertionError((Object)"disabled");
        }

        @Override
        public AssertQuery returns(String sql, Function<ResultSet, Void> checker) {
            return this;
        }

        @Override
        public AssertQuery throws_(String message) {
            return this;
        }

        @Override
        public AssertQuery runs() {
            return this;
        }

        @Override
        public AssertQuery convertMatches(Function<RelNode, Void> checker) {
            return this;
        }

        @Override
        public AssertQuery substitutionMatches(Function<RelNode, Void> checker) {
            return this;
        }

        @Override
        public AssertQuery planContains(String expected) {
            return this;
        }

        @Override
        public AssertQuery planHasSql(String expected) {
            return this;
        }

        @Override
        public AssertQuery planUpdateHasSql(String expected, int count) {
            return this;
        }

        @Override
        public AssertQuery queryContains(Function<List, Void> predicate1) {
            return this;
        }
    }

    public static enum Config {
        EMPTY,
        REGULAR,
        LINGUAL,
        JDBC_FOODMART,
        JDBC_SCOTT,
        FOODMART_CLONE,
        GEO,
        JDBC_FOODMART_WITH_LATTICE,
        REGULAR_PLUS_METADATA,
        SCOTT,
        SPARK;

    }

    public static class AssertMetaData {
        private final ConnectionFactory connectionFactory;
        private final Function<Connection, ResultSet> function;

        AssertMetaData(ConnectionFactory connectionFactory, Function<Connection, ResultSet> function) {
            this.connectionFactory = connectionFactory;
            this.function = function;
        }

        public final AssertMetaData returns(Function<ResultSet, Void> checker) {
            try {
                Connection c = this.connectionFactory.createConnection();
                ResultSet resultSet = (ResultSet)this.function.apply((Object)c);
                checker.apply((Object)resultSet);
                resultSet.close();
                c.close();
                return this;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public AssertMetaData returns(String expected) {
            return this.returns(CalciteAssert.checkResult(expected));
        }
    }

    public static class AssertQuery {
        private final String sql;
        private ConnectionFactory connectionFactory;
        private String plan;
        private int limit;
        private boolean materializationsEnabled = false;
        private final List<Pair<Hook, Function>> hooks = Lists.newArrayList();

        private AssertQuery(ConnectionFactory connectionFactory, String sql) {
            this.sql = sql;
            this.connectionFactory = connectionFactory;
        }

        protected Connection createConnection() throws Exception {
            return this.connectionFactory.createConnection();
        }

        public final AssertQuery withConnection(Function<Connection, Void> f) throws Exception {
            try (Connection c = this.createConnection();){
                f.apply((Object)c);
            }
            return this;
        }

        public AssertQuery enable(boolean enabled) {
            return enabled ? this : NopAssertQuery.of(this.sql);
        }

        public AssertQuery returns(String expected) {
            return this.returns(CalciteAssert.checkResult(expected));
        }

        public AssertQuery returns2(String expected) {
            return this.returns(CalciteAssert.checkResult(expected, new ResultSetFormatter(){

                @Override
                protected String adjustValue(String s) {
                    if (s != null) {
                        if (s.contains(".")) {
                            while (s.endsWith("0")) {
                                s = s.substring(0, s.length() - 1);
                            }
                            if (s.endsWith(".")) {
                                s = s.substring(0, s.length() - 1);
                            }
                        }
                        if (s.endsWith(" 00:00:00")) {
                            s = s.substring(0, s.length() - " 00:00:00".length());
                        }
                    }
                    return s;
                }
            }));
        }

        public AssertQuery returnsValue(String expected) {
            return this.returns(CalciteAssert.checkResultValue(expected));
        }

        public AssertQuery returnsCount(int expectedCount) {
            return this.returns(CalciteAssert.checkResultCount((org.hamcrest.Matcher<Integer>)CoreMatchers.is((Object)expectedCount)));
        }

        public final AssertQuery returns(Function<ResultSet, Void> checker) {
            return this.returns(this.sql, checker);
        }

        public final AssertQuery updates(int count) {
            try {
                CalciteAssert.assertQuery(this.createConnection(), this.sql, this.limit, this.materializationsEnabled, this.hooks, null, CalciteAssert.checkUpdateCount(count), null);
                return this;
            }
            catch (Exception e) {
                throw new RuntimeException("exception while executing [" + this.sql + "]", e);
            }
        }

        protected AssertQuery returns(String sql, Function<ResultSet, Void> checker) {
            try {
                CalciteAssert.assertQuery(this.createConnection(), sql, this.limit, this.materializationsEnabled, this.hooks, checker, null, null);
                return this;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("exception while executing [" + sql + "]", e);
            }
        }

        public AssertQuery returnsUnordered(String ... lines) {
            return this.returns(CalciteAssert.checkResult(true, false, lines));
        }

        public AssertQuery returnsOrdered(String ... lines) {
            return this.returns(CalciteAssert.checkResult(false, false, lines));
        }

        public AssertQuery returnsStartingWith(String ... lines) {
            return this.returns(CalciteAssert.checkResult(false, true, lines));
        }

        public AssertQuery throws_(String message) {
            try {
                CalciteAssert.assertQuery(this.createConnection(), this.sql, this.limit, this.materializationsEnabled, this.hooks, null, null, CalciteAssert.checkException(message));
                return this;
            }
            catch (Exception e) {
                throw new RuntimeException("exception while executing [" + this.sql + "]", e);
            }
        }

        public AssertQuery failsAtValidation(String optionalMessage) {
            try {
                CalciteAssert.assertQuery(this.createConnection(), this.sql, this.limit, this.materializationsEnabled, this.hooks, null, null, CalciteAssert.checkValidationException(optionalMessage));
                return this;
            }
            catch (Exception e) {
                throw new RuntimeException("exception while executing [" + this.sql + "]", e);
            }
        }

        public AssertQuery failsAtValidation() {
            return this.failsAtValidation(null);
        }

        public AssertQuery runs() {
            try {
                CalciteAssert.assertQuery(this.createConnection(), this.sql, this.limit, this.materializationsEnabled, this.hooks, null, null, null);
                return this;
            }
            catch (Exception e) {
                throw new RuntimeException("exception while executing [" + this.sql + "]", e);
            }
        }

        public AssertQuery typeIs(String expected) {
            try {
                CalciteAssert.assertQuery(this.createConnection(), this.sql, this.limit, false, this.hooks, CalciteAssert.checkResultType(expected), null, null);
                return this;
            }
            catch (Exception e) {
                throw new RuntimeException("exception while executing [" + this.sql + "]", e);
            }
        }

        public final AssertQuery convertContains(String expected) {
            return this.convertMatches(CalciteAssert.checkRel(expected, null));
        }

        public AssertQuery convertMatches(Function<RelNode, Void> checker) {
            try {
                CalciteAssert.assertPrepare(this.createConnection(), this.sql, this.materializationsEnabled, checker, null);
                return this;
            }
            catch (Exception e) {
                throw new RuntimeException("exception while preparing [" + this.sql + "]", e);
            }
        }

        public AssertQuery substitutionMatches(Function<RelNode, Void> checker) {
            try {
                CalciteAssert.assertPrepare(this.createConnection(), this.sql, this.materializationsEnabled, null, checker);
                return this;
            }
            catch (Exception e) {
                throw new RuntimeException("exception while preparing [" + this.sql + "]", e);
            }
        }

        public AssertQuery explainContains(String expected) {
            return this.explainMatches("", CalciteAssert.checkResultContains(expected));
        }

        public final AssertQuery explainMatches(String extra, Function<ResultSet, Void> checker) {
            return this.returns("explain plan " + extra + "for " + this.sql, checker);
        }

        public AssertQuery planContains(String expected) {
            this.ensurePlan(null);
            Assert.assertTrue((String)("Plan [" + this.plan + "] contains [" + expected + "]"), (boolean)Util.toLinux((String)this.plan).replaceAll("\\\\r\\\\n", "\\\\n").contains(expected));
            return this;
        }

        public AssertQuery planUpdateHasSql(String expected, int count) {
            this.ensurePlan(CalciteAssert.checkUpdateCount(count));
            expected = "getDataSource(), \"" + expected.replace("\\", "\\\\").replace("\"", "\\\"").replaceAll("\n", "\\\\n") + "\"";
            Assert.assertTrue((String)("Plan [" + this.plan + "] contains [" + expected + "]"), (boolean)Util.toLinux((String)this.plan).replaceAll("\\\\r\\\\n", "\\\\n").contains(expected));
            return this;
        }

        public AssertQuery planHasSql(String expected) {
            return this.planContains("getDataSource(), \"" + expected.replace("\\", "\\\\").replace("\"", "\\\"").replaceAll("\n", "\\\\n") + "\"");
        }

        private void ensurePlan(Function<Integer, Void> checkUpdate) {
            if (this.plan != null) {
                return;
            }
            this.addHook(Hook.JAVA_PLAN, new Function<String, Void>(){

                public Void apply(String a0) {
                    AssertQuery.this.plan = a0;
                    return null;
                }
            });
            try {
                CalciteAssert.assertQuery(this.createConnection(), this.sql, this.limit, this.materializationsEnabled, this.hooks, null, checkUpdate, null);
                Assert.assertNotNull((Object)this.plan);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while executing [" + this.sql + "]", e);
            }
        }

        public AssertQuery queryContains(Function<List, Void> predicate1) {
            final ArrayList list = Lists.newArrayList();
            this.addHook(Hook.QUERY_PLAN, new Function<Object, Void>(){

                public Void apply(Object a0) {
                    list.add(a0);
                    return null;
                }
            });
            try {
                CalciteAssert.assertQuery(this.createConnection(), this.sql, this.limit, this.materializationsEnabled, this.hooks, null, null, null);
                predicate1.apply((Object)list);
                return this;
            }
            catch (Exception e) {
                throw new RuntimeException("exception while executing [" + this.sql + "]", e);
            }
        }

        public AssertQuery limit(int limit) {
            this.limit = limit;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sameResultWithMaterializationsDisabled() {
            boolean save = this.materializationsEnabled;
            try {
                this.materializationsEnabled = false;
                boolean ordered = this.sql.toUpperCase(Locale.ROOT).contains("ORDER BY");
                Function<ResultSet, Void> checker = CalciteAssert.consistentResult(ordered);
                this.returns(checker);
                this.materializationsEnabled = true;
                this.returns(checker);
            }
            finally {
                this.materializationsEnabled = save;
            }
        }

        public AssertQuery enableMaterializations(boolean enable) {
            this.materializationsEnabled = enable;
            return this;
        }

        public <T> AssertQuery withHook(Hook hook, Function<T, Void> handler) {
            this.addHook(hook, handler);
            return this;
        }

        private <T> void addHook(Hook hook, Function<T, Void> handler) {
            this.hooks.add((Pair<Hook, Function>)Pair.of((Object)hook, handler));
        }

        public <V> AssertQuery withProperty(Hook hook, V value) {
            return this.withHook(hook, Hook.property(value));
        }

        public AssertQuery withRel(final Function<RelBuilder, RelNode> relFn) {
            return this.withHook(Hook.STRING_TO_QUERY, new Function<Pair<FrameworkConfig, Holder<CalcitePrepare.Query>>, Void>(){

                public Void apply(Pair<FrameworkConfig, Holder<CalcitePrepare.Query>> pair) {
                    RelBuilder b = RelBuilder.create((FrameworkConfig)((FrameworkConfig)pair.left));
                    ((Holder)pair.right).set((Object)CalcitePrepare.Query.of((RelNode)((RelNode)relFn.apply((Object)b))));
                    return null;
                }
            });
        }
    }

    private static class MapConnectionFactory
    extends ConnectionFactory {
        private final ImmutableMap<String, String> map;
        private final ImmutableList<ConnectionPostProcessor> postProcessors;

        private MapConnectionFactory(ImmutableMap<String, String> map, ImmutableList<ConnectionPostProcessor> postProcessors) {
            this.map = (ImmutableMap)Preconditions.checkNotNull(map);
            this.postProcessors = (ImmutableList)Preconditions.checkNotNull(postProcessors);
        }

        public boolean equals(Object obj) {
            return this == obj || obj.getClass() == MapConnectionFactory.class && ((MapConnectionFactory)obj).map.equals(this.map) && ((MapConnectionFactory)obj).postProcessors.equals(this.postProcessors);
        }

        public int hashCode() {
            return Objects.hash(this.map, this.postProcessors);
        }

        @Override
        public Connection createConnection() throws SQLException {
            Properties info = new Properties();
            for (Map.Entry entry : this.map.entrySet()) {
                info.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            Connection connection = DriverManager.getConnection("jdbc:calcite:", info);
            for (ConnectionPostProcessor postProcessor : this.postProcessors) {
                connection = postProcessor.apply(connection);
            }
            return connection;
        }

        @Override
        public ConnectionFactory with(String property, Object value) {
            return new MapConnectionFactory((ImmutableMap<String, String>)FlatLists.append(this.map, (Object)property, (Object)value.toString()), this.postProcessors);
        }

        @Override
        public ConnectionFactory with(ConnectionPostProcessor postProcessor) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(this.postProcessors);
            builder.add((Object)postProcessor);
            return new MapConnectionFactory(this.map, (ImmutableList<ConnectionPostProcessor>)builder.build());
        }
    }

    private static class PoolingConnectionFactory
    extends ConnectionFactory {
        private final ConnectionFactory factory;

        PoolingConnectionFactory(ConnectionFactory factory) {
            this.factory = factory;
        }

        @Override
        public Connection createConnection() throws SQLException {
            try {
                return (Connection)Pool.POOL.get((Object)this.factory);
            }
            catch (ExecutionException | UncheckedExecutionException e) {
                throw new SQLException("Unable to get pooled connection for " + this.factory, e.getCause());
            }
        }

        private static class Pool {
            private static final LoadingCache<ConnectionFactory, Connection> POOL = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<ConnectionFactory, Connection>(){

                public Connection load(@Nonnull ConnectionFactory key) throws Exception {
                    return key.createConnection();
                }
            });

            private Pool() {
            }
        }
    }

    public static class AddSchemaSpecPostProcessor
    implements ConnectionPostProcessor {
        private final SchemaSpec schemaSpec;

        public AddSchemaSpecPostProcessor(SchemaSpec schemaSpec) {
            this.schemaSpec = schemaSpec;
        }

        @Override
        public Connection apply(Connection connection) throws SQLException {
            CalciteConnection con = connection.unwrap(CalciteConnection.class);
            SchemaPlus rootSchema = con.getRootSchema();
            switch (this.schemaSpec) {
                case JDBC_FOODMART_WITH_LATTICE: 
                case CLONE_FOODMART: {
                    CalciteAssert.addSchema(rootSchema, SchemaSpec.JDBC_FOODMART);
                }
            }
            CalciteAssert.addSchema(rootSchema, this.schemaSpec);
            if (this.schemaSpec == SchemaSpec.CLONE_FOODMART) {
                con.setSchema("foodmart2");
            }
            return connection;
        }
    }

    public static class AddSchemaPostProcessor
    implements ConnectionPostProcessor {
        private final String name;
        private final Schema schema;

        public AddSchemaPostProcessor(String name, Schema schema) {
            this.name = name;
            this.schema = schema;
        }

        @Override
        public Connection apply(Connection connection) throws SQLException {
            if (this.schema != null) {
                CalciteConnection con = connection.unwrap(CalciteConnection.class);
                SchemaPlus rootSchema = con.getRootSchema();
                rootSchema.add(this.name, this.schema);
            }
            connection.setSchema(this.name);
            return connection;
        }
    }

    public static interface ConnectionPostProcessor {
        public Connection apply(Connection var1) throws SQLException;
    }

    public static abstract class ConnectionFactory {
        public abstract Connection createConnection() throws SQLException;

        public ConnectionFactory with(String property, Object value) {
            throw new UnsupportedOperationException();
        }

        public ConnectionFactory with(ConnectionPostProcessor postProcessor) {
            throw new UnsupportedOperationException();
        }
    }

    public static class AssertThat {
        private final ConnectionFactory connectionFactory;
        private static final AssertThat EMPTY = new AssertThat(EMPTY_CONNECTION_FACTORY);

        private AssertThat(ConnectionFactory connectionFactory) {
            this.connectionFactory = (ConnectionFactory)Preconditions.checkNotNull((Object)connectionFactory);
        }

        public AssertThat with(Config config) {
            if (config == Config.SPARK) {
                return this.with("spark", "true");
            }
            switch (config) {
                case EMPTY: {
                    return EMPTY;
                }
                case REGULAR: {
                    return this.with(SchemaSpec.HR, SchemaSpec.REFLECTIVE_FOODMART, SchemaSpec.POST);
                }
                case REGULAR_PLUS_METADATA: {
                    return this.with(SchemaSpec.HR, SchemaSpec.REFLECTIVE_FOODMART);
                }
                case GEO: {
                    return this.with(SchemaSpec.GEO).with(CalciteConnectionProperty.CONFORMANCE.camelName(), SqlConformanceEnum.LENIENT);
                }
                case LINGUAL: {
                    return this.with(SchemaSpec.LINGUAL);
                }
                case JDBC_FOODMART: {
                    return this.with(SchemaSpec.JDBC_FOODMART);
                }
                case FOODMART_CLONE: {
                    return this.with(SchemaSpec.CLONE_FOODMART);
                }
                case JDBC_FOODMART_WITH_LATTICE: {
                    return this.with(SchemaSpec.JDBC_FOODMART_WITH_LATTICE);
                }
                case JDBC_SCOTT: {
                    return this.with(SchemaSpec.JDBC_SCOTT);
                }
                case SCOTT: {
                    return this.with(SchemaSpec.SCOTT);
                }
            }
            throw Util.unexpected((Enum)config);
        }

        public AssertThat with(SchemaSpec ... specs) {
            AssertThat next = this;
            for (SchemaSpec spec : specs) {
                next = next.with(new AddSchemaSpecPostProcessor(spec));
            }
            return next;
        }

        public AssertThat with(ConnectionFactory connectionFactory) {
            return new AssertThat(connectionFactory);
        }

        public final AssertThat with(Map<String, String> map) {
            AssertThat x = this;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                x = this.with(entry.getKey(), entry.getValue());
            }
            return x;
        }

        public AssertThat with(String property, Object value) {
            return new AssertThat(this.connectionFactory.with(property, value));
        }

        public AssertThat with(Lex lex) {
            return this.with(CalciteConnectionProperty.LEX.name(), lex.toString());
        }

        public AssertThat withSchema(String name, Schema schema) {
            return new AssertThat(this.connectionFactory.with(new AddSchemaPostProcessor(name, schema)));
        }

        public AssertThat with(ConnectionPostProcessor postProcessor) {
            return new AssertThat(this.connectionFactory.with(postProcessor));
        }

        public final AssertThat withModel(String model) {
            return this.with("model", "inline:" + model);
        }

        public final AssertThat withMaterializations(String model, String ... materializations) {
            return this.withMaterializations(model, false, materializations);
        }

        public final AssertThat withMaterializations(String model, final boolean existing, final String ... materializations) {
            return this.withMaterializations(model, new Function<JsonBuilder, List<Object>>(){

                public List<Object> apply(JsonBuilder builder) {
                    assert (materializations.length % 2 == 0);
                    List list = builder.list();
                    for (int i = 0; i < materializations.length; ++i) {
                        String table = materializations[i++];
                        Map map = builder.map();
                        map.put("table", table);
                        if (!existing) {
                            map.put("view", table + "v");
                        }
                        String sql = materializations[i];
                        String sql2 = sql.replaceAll("`", "\"");
                        map.put("sql", sql2);
                        list.add(map);
                    }
                    return list;
                }
            });
        }

        public final AssertThat withMaterializations(String model, Function<JsonBuilder, List<Object>> materializations) {
            String model2;
            JsonBuilder builder = new JsonBuilder();
            List list = (List)materializations.apply((Object)builder);
            String buf = "materializations: " + builder.toJsonString((Object)list);
            if (model.contains("defaultSchema: 'foodmart'")) {
                int endIndex = model.lastIndexOf(93);
                model2 = model.substring(0, endIndex) + ", \n{ name: 'mat', " + buf + "}\n]" + model.substring(endIndex + 1);
            } else if (model.contains("type: ")) {
                model2 = model.replaceFirst("type: ", Matcher.quoteReplacement(buf + ",\ntype: "));
            } else {
                throw new AssertionError((Object)"do not know where to splice");
            }
            return this.withModel(model2);
        }

        public AssertQuery query(String sql) {
            return new AssertQuery(this.connectionFactory, sql);
        }

        public AssertThat connectThrows(String message) {
            return this.connectThrows(CalciteAssert.checkException(message));
        }

        public AssertThat connectThrows(Function<Throwable, Void> exceptionChecker) {
            Throwable throwable;
            try {
                Connection x = this.connectionFactory.createConnection();
                try {
                    x.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throwable = null;
            }
            catch (Throwable e) {
                throwable = e;
            }
            exceptionChecker.apply((Object)throwable);
            return this;
        }

        public <T> AssertThat doWithConnection(Function<CalciteConnection, T> fn) throws Exception {
            try (Connection connection = this.connectionFactory.createConnection();){
                Object t = fn.apply((Object)((CalciteConnection)connection));
                Util.discard((Object)t);
                AssertThat assertThat = this;
                return assertThat;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> AssertThat doWithDataContext(Function<DataContext, T> fn) throws Exception {
            CalciteConnection connection = (CalciteConnection)this.connectionFactory.createConnection();
            DataContext dataContext = CalciteMetaImpl.createDataContext((CalciteConnection)connection);
            try {
                Object t = fn.apply((Object)dataContext);
                Util.discard((Object)t);
                AssertThat assertThat = this;
                return assertThat;
            }
            finally {
                connection.close();
            }
        }

        public AssertThat withDefaultSchema(String schema) {
            return new AssertThat(this.connectionFactory.with(new AddSchemaPostProcessor(schema, null)));
        }

        public Connection connect() throws SQLException {
            return this.connectionFactory.createConnection();
        }

        public AssertThat enable(boolean enabled) {
            return enabled ? this : DISABLED;
        }

        public AssertThat pooled() {
            if (this.connectionFactory instanceof PoolingConnectionFactory) {
                return this;
            }
            return new AssertThat(new PoolingConnectionFactory(this.connectionFactory));
        }

        public AssertMetaData metaData(Function<Connection, ResultSet> function) {
            return new AssertMetaData(this.connectionFactory, function);
        }
    }
}

