/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.resolver.dns;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.hive.druid.io.netty.resolver.dns.DnsServerAddressStream;
import org.apache.hive.druid.io.netty.resolver.dns.UnixResolverDnsServerAddressStreamProvider;
import org.apache.hive.druid.io.netty.util.CharsetUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class UnixResolverDnsServerAddressStreamProviderTest {
    @Test
    public void defaultLookupShouldReturnResultsIfOnlySingleFileSpecified(@TempDir Path tempDir) throws Exception {
        File f = this.buildFile(tempDir, "domain linecorp.local\nnameserver 127.0.0.2\nnameserver 127.0.0.3\n");
        UnixResolverDnsServerAddressStreamProvider p = new UnixResolverDnsServerAddressStreamProvider(f, null);
        DnsServerAddressStream stream = p.nameServerAddressStream("somehost");
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.2", stream.next());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.3", stream.next());
    }

    @Test
    public void nameServerAddressStreamShouldBeRotationalWhenRotationOptionsIsPresent(@TempDir Path tempDir) throws Exception {
        File f = this.buildFile(tempDir, "options rotate\ndomain linecorp.local\nnameserver 127.0.0.2\nnameserver 127.0.0.3\nnameserver 127.0.0.4\n");
        UnixResolverDnsServerAddressStreamProvider p = new UnixResolverDnsServerAddressStreamProvider(f, null);
        DnsServerAddressStream stream = p.nameServerAddressStream("");
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.2", stream.next());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.3", stream.next());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.4", stream.next());
        stream = p.nameServerAddressStream("");
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.3", stream.next());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.4", stream.next());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.2", stream.next());
        stream = p.nameServerAddressStream("");
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.4", stream.next());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.2", stream.next());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.3", stream.next());
        stream = p.nameServerAddressStream("");
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.2", stream.next());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.3", stream.next());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.4", stream.next());
    }

    @Test
    public void nameServerAddressStreamShouldAlwaysStartFromTheTopWhenRotationOptionsIsAbsent(@TempDir Path tempDir) throws Exception {
        File f = this.buildFile(tempDir, "domain linecorp.local\nnameserver 127.0.0.2\nnameserver 127.0.0.3\nnameserver 127.0.0.4\n");
        UnixResolverDnsServerAddressStreamProvider p = new UnixResolverDnsServerAddressStreamProvider(f, null);
        DnsServerAddressStream stream = p.nameServerAddressStream("");
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.2", stream.next());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.3", stream.next());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.4", stream.next());
        stream = p.nameServerAddressStream("");
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.2", stream.next());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.3", stream.next());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.4", stream.next());
        stream = p.nameServerAddressStream("");
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.2", stream.next());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.3", stream.next());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.4", stream.next());
    }

    @Test
    public void defaultReturnedWhenNoBetterMatch(@TempDir Path tempDir) throws Exception {
        File f = this.buildFile(tempDir, "domain linecorp.local\nnameserver 127.0.0.2\nnameserver 127.0.0.3\n");
        File f2 = this.buildFile(tempDir, "domain squarecorp.local\nnameserver 127.0.0.4\nnameserver 127.0.0.5\n");
        UnixResolverDnsServerAddressStreamProvider p = new UnixResolverDnsServerAddressStreamProvider(f, new File[]{f2});
        DnsServerAddressStream stream = p.nameServerAddressStream("somehost");
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.2", stream.next());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.3", stream.next());
    }

    @Test
    public void moreRefinedSelectionReturnedWhenMatch(@TempDir Path tempDir) throws Exception {
        File f = this.buildFile(tempDir, "domain linecorp.local\nnameserver 127.0.0.2\nnameserver 127.0.0.3\n");
        File f2 = this.buildFile(tempDir, "domain dc1.linecorp.local\nnameserver 127.0.0.4\nnameserver 127.0.0.5\n");
        UnixResolverDnsServerAddressStreamProvider p = new UnixResolverDnsServerAddressStreamProvider(f, new File[]{f2});
        DnsServerAddressStream stream = p.nameServerAddressStream("myhost.dc1.linecorp.local");
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.4", stream.next());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.5", stream.next());
    }

    @Test
    public void ndotsOptionIsParsedIfPresent(@TempDir Path tempDir) throws IOException {
        File f = this.buildFile(tempDir, "search localdomain\nnameserver 127.0.0.11\noptions ndots:0\n");
        Assertions.assertEquals((int)0, (int)UnixResolverDnsServerAddressStreamProvider.parseEtcResolverOptions((File)f).ndots());
        f = this.buildFile(tempDir, "search localdomain\nnameserver 127.0.0.11\noptions ndots:123 foo:goo\n");
        Assertions.assertEquals((int)123, (int)UnixResolverDnsServerAddressStreamProvider.parseEtcResolverOptions((File)f).ndots());
    }

    @Test
    public void defaultValueReturnedIfNdotsOptionsNotPresent(@TempDir Path tempDir) throws IOException {
        File f = this.buildFile(tempDir, "search localdomain\nnameserver 127.0.0.11\n");
        Assertions.assertEquals((int)1, (int)UnixResolverDnsServerAddressStreamProvider.parseEtcResolverOptions((File)f).ndots());
    }

    @Test
    public void timeoutOptionIsParsedIfPresent(@TempDir Path tempDir) throws IOException {
        File f = this.buildFile(tempDir, "search localdomain\nnameserver 127.0.0.11\noptions timeout:0\n");
        Assertions.assertEquals((int)0, (int)UnixResolverDnsServerAddressStreamProvider.parseEtcResolverOptions((File)f).timeout());
        f = this.buildFile(tempDir, "search localdomain\nnameserver 127.0.0.11\noptions foo:bar timeout:124\n");
        Assertions.assertEquals((int)124, (int)UnixResolverDnsServerAddressStreamProvider.parseEtcResolverOptions((File)f).timeout());
    }

    @Test
    public void defaultValueReturnedIfTimeoutOptionsIsNotPresent(@TempDir Path tempDir) throws IOException {
        File f = this.buildFile(tempDir, "search localdomain\nnameserver 127.0.0.11\n");
        Assertions.assertEquals((int)5, (int)UnixResolverDnsServerAddressStreamProvider.parseEtcResolverOptions((File)f).timeout());
    }

    @Test
    public void attemptsOptionIsParsedIfPresent(@TempDir Path tempDir) throws IOException {
        File f = this.buildFile(tempDir, "search localdomain\nnameserver 127.0.0.11\noptions attempts:0\n");
        Assertions.assertEquals((int)0, (int)UnixResolverDnsServerAddressStreamProvider.parseEtcResolverOptions((File)f).attempts());
        f = this.buildFile(tempDir, "search localdomain\nnameserver 127.0.0.11\noptions foo:bar attempts:12\n");
        Assertions.assertEquals((int)12, (int)UnixResolverDnsServerAddressStreamProvider.parseEtcResolverOptions((File)f).attempts());
    }

    @Test
    public void defaultValueReturnedIfAttemptsOptionsIsNotPresent(@TempDir Path tempDir) throws IOException {
        File f = this.buildFile(tempDir, "search localdomain\nnameserver 127.0.0.11\n");
        Assertions.assertEquals((int)16, (int)UnixResolverDnsServerAddressStreamProvider.parseEtcResolverOptions((File)f).attempts());
    }

    @Test
    public void emptyEtcResolverDirectoryDoesNotThrow(@TempDir Path tempDir) throws IOException {
        File f = this.buildFile(tempDir, "domain linecorp.local\nnameserver 127.0.0.2\nnameserver 127.0.0.3\n");
        UnixResolverDnsServerAddressStreamProvider p = new UnixResolverDnsServerAddressStreamProvider(f, tempDir.resolve("netty-empty").toFile().listFiles());
        DnsServerAddressStream stream = p.nameServerAddressStream("somehost");
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.2", stream.next());
    }

    @Test
    public void searchDomainsWithOnlyDomain(@TempDir Path tempDir) throws IOException {
        File f = this.buildFile(tempDir, "domain linecorp.local\nnameserver 127.0.0.2\n");
        List domains = UnixResolverDnsServerAddressStreamProvider.parseEtcResolverSearchDomains((File)f);
        Assertions.assertEquals(Collections.singletonList("linecorp.local"), (Object)domains);
    }

    @Test
    public void searchDomainsWithOnlySearch(@TempDir Path tempDir) throws IOException {
        File f = this.buildFile(tempDir, "search linecorp.local\nnameserver 127.0.0.2\n");
        List domains = UnixResolverDnsServerAddressStreamProvider.parseEtcResolverSearchDomains((File)f);
        Assertions.assertEquals(Collections.singletonList("linecorp.local"), (Object)domains);
    }

    @Test
    public void searchDomainsWithMultipleSearch(@TempDir Path tempDir) throws IOException {
        File f = this.buildFile(tempDir, "search linecorp.local\nsearch squarecorp.local\nnameserver 127.0.0.2\n");
        List domains = UnixResolverDnsServerAddressStreamProvider.parseEtcResolverSearchDomains((File)f);
        Assertions.assertEquals(Arrays.asList("linecorp.local", "squarecorp.local"), (Object)domains);
    }

    @Test
    public void searchDomainsWithMultipleSearchSeperatedByWhitespace(@TempDir Path tempDir) throws IOException {
        File f = this.buildFile(tempDir, "search linecorp.local squarecorp.local\nnameserver 127.0.0.2\n");
        List domains = UnixResolverDnsServerAddressStreamProvider.parseEtcResolverSearchDomains((File)f);
        Assertions.assertEquals(Arrays.asList("linecorp.local", "squarecorp.local"), (Object)domains);
    }

    @Test
    public void searchDomainsWithMultipleSearchSeperatedByTab(@TempDir Path tempDir) throws IOException {
        File f = this.buildFile(tempDir, "search linecorp.local\tsquarecorp.local\nnameserver 127.0.0.2\n");
        List domains = UnixResolverDnsServerAddressStreamProvider.parseEtcResolverSearchDomains((File)f);
        Assertions.assertEquals(Arrays.asList("linecorp.local", "squarecorp.local"), (Object)domains);
    }

    @Test
    public void searchDomainsPrecedence(@TempDir Path tempDir) throws IOException {
        File f = this.buildFile(tempDir, "domain linecorp.local\nsearch squarecorp.local\nnameserver 127.0.0.2\n");
        List domains = UnixResolverDnsServerAddressStreamProvider.parseEtcResolverSearchDomains((File)f);
        Assertions.assertEquals(Collections.singletonList("squarecorp.local"), (Object)domains);
    }

    @Test
    public void ignoreInvalidEntries(@TempDir Path tempDir) throws Exception {
        File f = this.buildFile(tempDir, "domain netty.local\nnameserver nil\nnameserver 127.0.0.3\n");
        UnixResolverDnsServerAddressStreamProvider p = new UnixResolverDnsServerAddressStreamProvider(f, null);
        DnsServerAddressStream stream = p.nameServerAddressStream("somehost");
        Assertions.assertEquals((int)1, (int)stream.size());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.3", stream.next());
    }

    private File buildFile(Path tempDir, String contents) throws IOException {
        Path path = tempDir.resolve("netty-dns-" + UUID.randomUUID().toString().substring(24) + ".txt");
        Files.write(path, contents.getBytes(CharsetUtil.UTF_8), new OpenOption[0]);
        return path.toFile();
    }

    @Test
    public void ignoreComments(@TempDir Path tempDir) throws Exception {
        File f = this.buildFile(tempDir, "domain linecorp.local\nnameserver 127.0.0.2 #somecomment\n");
        UnixResolverDnsServerAddressStreamProvider p = new UnixResolverDnsServerAddressStreamProvider(f, null);
        DnsServerAddressStream stream = p.nameServerAddressStream("somehost");
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.2", stream.next());
    }

    @Test
    public void ipv6Nameserver(@TempDir Path tempDir) throws Exception {
        File f = this.buildFile(tempDir, "search localdomain\nnameserver 10.211.55.1\nnameserver fe80::21c:42ff:fe00:18%nonexisting\n");
        UnixResolverDnsServerAddressStreamProvider p = new UnixResolverDnsServerAddressStreamProvider(f, null);
        DnsServerAddressStream stream = p.nameServerAddressStream("somehost");
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("10.211.55.1", stream.next());
    }

    private static void assertHostNameEquals(String expectedHostname, InetSocketAddress next) {
        Assertions.assertEquals((Object)expectedHostname, (Object)next.getHostString(), (String)("unexpected hostname: " + next));
    }
}

