/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.resolver;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import org.apache.hive.druid.io.netty.resolver.HostsFileEntries;
import org.apache.hive.druid.io.netty.resolver.HostsFileParser;
import org.apache.hive.druid.io.netty.util.CharsetUtil;
import org.apache.hive.druid.io.netty.util.internal.ResourcesUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HostsFileParserTest {
    @Test
    public void testParse() throws IOException {
        String hostsString = "127.0.0.1 host1" + "\n" + "::1 host1" + "\n" + "\n" + "192.168.0.1\thost2" + "\n" + "#comment" + "\n" + " #comment  " + "\n" + "192.168.0.2  host3  #comment" + "\n" + "192.168.0.3  host4  host5 host6" + "\n" + "192.168.0.4  host4" + "\n" + "192.168.0.5  HOST7" + "\n" + "192.168.0.6  host7" + "\n";
        HostsFileEntries entries = HostsFileParser.parse((Reader)new BufferedReader(new StringReader(hostsString)));
        Map inet4Entries = entries.inet4Entries();
        Map inet6Entries = entries.inet6Entries();
        Assertions.assertEquals((int)7, (int)inet4Entries.size(), (String)"Expected 7 IPv4 entries");
        Assertions.assertEquals((int)1, (int)inet6Entries.size(), (String)"Expected 1 IPv6 entries");
        Assertions.assertEquals((Object)"127.0.0.1", (Object)((Inet4Address)inet4Entries.get("host1")).getHostAddress());
        Assertions.assertEquals((Object)"192.168.0.1", (Object)((Inet4Address)inet4Entries.get("host2")).getHostAddress());
        Assertions.assertEquals((Object)"192.168.0.2", (Object)((Inet4Address)inet4Entries.get("host3")).getHostAddress());
        Assertions.assertEquals((Object)"192.168.0.3", (Object)((Inet4Address)inet4Entries.get("host4")).getHostAddress());
        Assertions.assertEquals((Object)"192.168.0.3", (Object)((Inet4Address)inet4Entries.get("host5")).getHostAddress());
        Assertions.assertEquals((Object)"192.168.0.3", (Object)((Inet4Address)inet4Entries.get("host6")).getHostAddress());
        Assertions.assertNotNull(inet4Entries.get("host7"), (String)"uppercase host doesn't resolve");
        Assertions.assertEquals((Object)"192.168.0.5", (Object)((Inet4Address)inet4Entries.get("host7")).getHostAddress());
        Assertions.assertEquals((Object)"0:0:0:0:0:0:0:1", (Object)((Inet6Address)inet6Entries.get("host1")).getHostAddress());
    }

    @Test
    public void testParseUnicode() throws IOException {
        Charset unicodeCharset;
        try {
            unicodeCharset = Charset.forName("unicode");
        }
        catch (UnsupportedCharsetException e) {
            return;
        }
        HostsFileParserTest.testParseFile(HostsFileParser.parse((File)ResourcesUtil.getFile(this.getClass(), (String)"hosts-unicode"), (Charset[])new Charset[]{unicodeCharset}));
    }

    @Test
    public void testParseMultipleCharsets() throws IOException {
        Charset unicodeCharset;
        try {
            unicodeCharset = Charset.forName("unicode");
        }
        catch (UnsupportedCharsetException e) {
            return;
        }
        HostsFileParserTest.testParseFile(HostsFileParser.parse((File)ResourcesUtil.getFile(this.getClass(), (String)"hosts-unicode"), (Charset[])new Charset[]{CharsetUtil.UTF_8, CharsetUtil.ISO_8859_1, unicodeCharset}));
    }

    private static void testParseFile(HostsFileEntries entries) throws IOException {
        Map inet4Entries = entries.inet4Entries();
        Map inet6Entries = entries.inet6Entries();
        Assertions.assertEquals((int)2, (int)inet4Entries.size(), (String)"Expected 2 IPv4 entries");
        Assertions.assertEquals((int)1, (int)inet6Entries.size(), (String)"Expected 1 IPv6 entries");
        Assertions.assertEquals((Object)"127.0.0.1", (Object)((Inet4Address)inet4Entries.get("localhost")).getHostAddress());
        Assertions.assertEquals((Object)"255.255.255.255", (Object)((Inet4Address)inet4Entries.get("broadcasthost")).getHostAddress());
        Assertions.assertEquals((Object)"0:0:0:0:0:0:0:1", (Object)((Inet6Address)inet6Entries.get("localhost")).getHostAddress());
    }
}

