/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.ssl.ocsp;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hive.druid.io.netty.bootstrap.Bootstrap;
import org.apache.hive.druid.io.netty.channel.ChannelFuture;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.channel.ChannelInitializer;
import org.apache.hive.druid.io.netty.channel.ChannelOption;
import org.apache.hive.druid.io.netty.channel.ChannelPipeline;
import org.apache.hive.druid.io.netty.channel.EventLoopGroup;
import org.apache.hive.druid.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hive.druid.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hive.druid.io.netty.channel.socket.SocketChannel;
import org.apache.hive.druid.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.hive.druid.io.netty.handler.ssl.SslContext;
import org.apache.hive.druid.io.netty.handler.ssl.SslContextBuilder;
import org.apache.hive.druid.io.netty.handler.ssl.ocsp.OcspResponse;
import org.apache.hive.druid.io.netty.handler.ssl.ocsp.OcspServerCertificateValidator;
import org.apache.hive.druid.io.netty.handler.ssl.ocsp.OcspValidationEvent;
import org.apache.hive.druid.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class OcspServerCertificateValidatorTest {
    OcspServerCertificateValidatorTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void connectUsingHttpAndValidateCertificateUsingOcspTest() throws Exception {
        final AtomicBoolean ocspStatus = new AtomicBoolean();
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            final SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(new ChannelHandler[]{sslContext.newHandler(ch.alloc(), "netty.io", 443)});
                    pipeline.addLast(new ChannelHandler[]{new OcspServerCertificateValidator(false)});
                    pipeline.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<Object>(){

                        protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
                        }

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                            if (evt instanceof OcspValidationEvent) {
                                OcspValidationEvent event = (OcspValidationEvent)evt;
                                ocspStatus.set(event.response().status() == OcspResponse.Status.VALID);
                                ctx.channel().close();
                                latch.countDown();
                            }
                        }
                    }});
                }
            });
            ChannelFuture channelFuture = bootstrap.connect("netty.io", 443);
            channelFuture.sync();
            latch.await(1L, TimeUnit.MINUTES);
            Assertions.assertTrue((boolean)ocspStatus.get());
            channelFuture.channel().closeFuture().sync();
        }
        finally {
            eventLoopGroup.shutdownGracefully();
        }
    }
}

