/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.channel.ChannelDuplexHandler;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.util.ReferenceCountUtil;
import org.apache.hive.druid.io.netty.util.internal.ObjectUtil;
import org.apache.hive.druid.io.netty.util.internal.PlatformDependent;

public class LastInboundHandler
extends ChannelDuplexHandler {
    private final List<Object> queue = new ArrayList<Object>();
    private final Consumer<ChannelHandlerContext> channelReadCompleteConsumer;
    private Throwable lastException;
    private ChannelHandlerContext ctx;
    private boolean channelActive;
    private String writabilityStates = "";
    private static final Consumer<Object> NOOP_CONSUMER = new Consumer<Object>(){

        @Override
        public void accept(Object obj) {
        }
    };

    public static <T> Consumer<T> noopConsumer() {
        return NOOP_CONSUMER;
    }

    public LastInboundHandler() {
        this(LastInboundHandler.noopConsumer());
    }

    public LastInboundHandler(Consumer<ChannelHandlerContext> channelReadCompleteConsumer) {
        this.channelReadCompleteConsumer = (Consumer)ObjectUtil.checkNotNull(channelReadCompleteConsumer, (String)"channelReadCompleteConsumer");
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.ctx = ctx;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.channelActive) {
            throw new IllegalStateException("channelActive may only be fired once.");
        }
        this.channelActive = true;
        super.channelActive(ctx);
    }

    public boolean isChannelActive() {
        return this.channelActive;
    }

    public String writabilityStates() {
        return this.writabilityStates;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (!this.channelActive) {
            throw new IllegalStateException("channelInactive may only be fired once after channelActive.");
        }
        this.channelActive = false;
        super.channelInactive(ctx);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.writabilityStates = "".equals(this.writabilityStates) ? String.valueOf(ctx.channel().isWritable()) : this.writabilityStates + "," + ctx.channel().isWritable();
        super.channelWritabilityChanged(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.queue.add(msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.channelReadCompleteConsumer.accept(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        this.queue.add(new UserEvent(evt));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.lastException != null) {
            cause.printStackTrace();
        } else {
            this.lastException = cause;
        }
    }

    public void checkException() throws Exception {
        if (this.lastException == null) {
            return;
        }
        Throwable t = this.lastException;
        this.lastException = null;
        PlatformDependent.throwException((Throwable)t);
    }

    public <T> T readInbound() {
        for (int i = 0; i < this.queue.size(); ++i) {
            Object o = this.queue.get(i);
            if (o instanceof UserEvent) continue;
            this.queue.remove(i);
            return (T)o;
        }
        return null;
    }

    public <T> T blockingReadInbound() {
        T msg;
        while ((msg = this.readInbound()) == null) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
        return msg;
    }

    public <T> T readUserEvent() {
        for (int i = 0; i < this.queue.size(); ++i) {
            Object o = this.queue.get(i);
            if (!(o instanceof UserEvent)) continue;
            this.queue.remove(i);
            return (T)((UserEvent)o).evt;
        }
        return null;
    }

    public <T> T readInboundMessageOrUserEvent() {
        if (this.queue.isEmpty()) {
            return null;
        }
        Object o = this.queue.remove(0);
        if (o instanceof UserEvent) {
            return (T)((UserEvent)o).evt;
        }
        return (T)o;
    }

    public void writeOutbound(Object ... msgs) throws Exception {
        for (Object msg : msgs) {
            this.ctx.write(msg);
        }
        this.ctx.flush();
        EmbeddedChannel ch = (EmbeddedChannel)this.ctx.channel();
        ch.runPendingTasks();
        ch.checkException();
        this.checkException();
    }

    public void finishAndReleaseAll() throws Exception {
        Object o;
        this.checkException();
        while ((o = this.readInboundMessageOrUserEvent()) != null) {
            ReferenceCountUtil.release(o);
        }
    }

    public Channel channel() {
        return this.ctx.channel();
    }

    private static final class UserEvent {
        private final Object evt;

        UserEvent(Object evt) {
            this.evt = evt;
        }
    }

    public static interface Consumer<T> {
        public void accept(T var1);
    }
}

