/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import org.apache.hive.druid.io.netty.handler.codec.http.TooLongHttpLineException;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Error;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Exception;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class Http2ExceptionTest {
    Http2ExceptionTest() {
    }

    @Test
    public void connectionErrorHandlesMessage() {
        TooLongHttpLineException e = new TooLongHttpLineException("An HTTP line is larger than 1024 bytes.");
        Http2Exception http2Exception = Http2Exception.connectionError((Http2Error)Http2Error.COMPRESSION_ERROR, (Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
        Assertions.assertEquals((Object)Http2Error.COMPRESSION_ERROR, (Object)http2Exception.error());
        Assertions.assertEquals((Object)"An HTTP line is larger than 1024 bytes.", (Object)http2Exception.getMessage());
    }

    @Test
    public void connectionErrorHandlesNullExceptionMessage() {
        RuntimeException e = new RuntimeException();
        Http2Exception http2Exception = Http2Exception.connectionError((Http2Error)Http2Error.COMPRESSION_ERROR, (Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
        Assertions.assertEquals((Object)Http2Error.COMPRESSION_ERROR, (Object)http2Exception.error());
        Assertions.assertEquals((Object)"Unexpected error", (Object)http2Exception.getMessage());
    }

    @Test
    public void connectionErrorHandlesMultipleMessages() {
        RuntimeException e = new RuntimeException();
        Http2Exception http2Exception = Http2Exception.connectionError((Http2Error)Http2Error.COMPRESSION_ERROR, (Throwable)e, (String)e.getMessage(), (Object[])new Object[]{"a", "b"});
        Assertions.assertEquals((Object)Http2Error.COMPRESSION_ERROR, (Object)http2Exception.error());
        Assertions.assertEquals((Object)"Unexpected error: [a, b]", (Object)http2Exception.getMessage());
    }
}

