/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.DefaultEventLoopGroup;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2Connection;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Connection;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Error;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Exception;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Stream;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2StreamVisitor;
import org.apache.hive.druid.io.netty.util.concurrent.Future;
import org.apache.hive.druid.io.netty.util.concurrent.FutureListener;
import org.apache.hive.druid.io.netty.util.concurrent.GenericFutureListener;
import org.apache.hive.druid.io.netty.util.concurrent.Promise;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class DefaultHttp2ConnectionTest {
    private DefaultHttp2Connection server;
    private DefaultHttp2Connection client;
    private static DefaultEventLoopGroup group;
    @Mock
    private Http2Connection.Listener clientListener;
    @Mock
    private Http2Connection.Listener clientListener2;

    @BeforeAll
    public static void beforeClass() {
        group = new DefaultEventLoopGroup(2);
    }

    @AfterAll
    public static void afterClass() {
        group.shutdownGracefully();
    }

    @BeforeEach
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.server = new DefaultHttp2Connection(true);
        this.client = new DefaultHttp2Connection(false);
        this.client.addListener(this.clientListener);
        ((Http2Connection.Listener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Assertions.assertNotNull((Object)DefaultHttp2ConnectionTest.this.client.stream(((Http2Stream)invocation.getArgument(0)).id()));
                return null;
            }
        }).when((Object)this.clientListener)).onStreamClosed((Http2Stream)Mockito.any(Http2Stream.class));
        ((Http2Connection.Listener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Assertions.assertNull((Object)DefaultHttp2ConnectionTest.this.client.stream(((Http2Stream)invocation.getArgument(0)).id()));
                return null;
            }
        }).when((Object)this.clientListener)).onStreamRemoved((Http2Stream)Mockito.any(Http2Stream.class));
    }

    @Test
    public void getStreamWithoutStreamShouldReturnNull() {
        Assertions.assertNull((Object)this.server.stream(100));
    }

    @Test
    public void removeAllStreamsWithEmptyStreams() throws InterruptedException {
        this.testRemoveAllStreams();
    }

    @Test
    public void removeAllStreamsWithJustOneLocalStream() throws Exception {
        this.client.local().createStream(3, false);
        this.testRemoveAllStreams();
    }

    @Test
    public void removeAllStreamsWithJustOneRemoveStream() throws Exception {
        this.client.remote().createStream(2, false);
        this.testRemoveAllStreams();
    }

    @Test
    public void removeAllStreamsWithManyActiveStreams() throws Exception {
        Http2Connection.Endpoint remote = this.client.remote();
        Http2Connection.Endpoint local = this.client.local();
        int c = 3;
        int s = 2;
        while (c < 5000) {
            local.createStream(c, false);
            remote.createStream(s, false);
            c += 2;
            s += 2;
        }
        this.testRemoveAllStreams();
    }

    @Test
    public void removeIndividualStreamsWhileCloseDoesNotNPE() throws Exception {
        final Http2Stream streamA = this.client.local().createStream(3, false);
        final Http2Stream streamB = this.client.remote().createStream(2, false);
        ((Http2Connection.Listener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                streamA.close();
                streamB.close();
                return null;
            }
        }).when((Object)this.clientListener2)).onStreamClosed((Http2Stream)Mockito.any(Http2Stream.class));
        try {
            this.client.addListener(this.clientListener2);
            this.testRemoveAllStreams();
        }
        finally {
            this.client.removeListener(this.clientListener2);
        }
    }

    @Test
    public void removeAllStreamsWhileIteratingActiveStreams() throws Exception {
        Http2Connection.Endpoint remote = this.client.remote();
        Http2Connection.Endpoint local = this.client.local();
        int c = 3;
        int s = 2;
        while (c < 5000) {
            local.createStream(c, false);
            remote.createStream(s, false);
            c += 2;
            s += 2;
        }
        final Promise promise = group.next().newPromise();
        final CountDownLatch latch = new CountDownLatch(this.client.numActiveStreams());
        this.client.forEachActiveStream(new Http2StreamVisitor(){

            public boolean visit(Http2Stream stream) {
                DefaultHttp2ConnectionTest.this.client.close(promise).addListener((GenericFutureListener)new FutureListener<Void>(){

                    public void operationComplete(Future<Void> future) throws Exception {
                        Assertions.assertTrue((boolean)promise.isDone());
                        latch.countDown();
                    }
                });
                return true;
            }
        });
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void removeAllStreamsWhileIteratingActiveStreamsAndExceptionOccurs() throws Exception {
        final Http2Connection.Endpoint remote = this.client.remote();
        Http2Connection.Endpoint local = this.client.local();
        int c = 3;
        int s = 2;
        while (c < 5000) {
            local.createStream(c, false);
            remote.createStream(s, false);
            c += 2;
            s += 2;
        }
        final Promise promise = group.next().newPromise();
        final CountDownLatch latch = new CountDownLatch(1);
        try {
            this.client.forEachActiveStream(new Http2StreamVisitor(){

                public boolean visit(Http2Stream stream) throws Http2Exception {
                    DefaultHttp2ConnectionTest.this.client.close(promise);
                    remote.createStream(3, false);
                    return true;
                }
            });
        }
        catch (Http2Exception ignored) {
            this.client.close(promise).addListener((GenericFutureListener)new FutureListener<Void>(){

                public void operationComplete(Future<Void> future) throws Exception {
                    Assertions.assertTrue((boolean)promise.isDone());
                    latch.countDown();
                }
            });
        }
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void goAwayReceivedShouldCloseStreamsGreaterThanLastStream() throws Exception {
        Http2Stream stream1 = this.client.local().createStream(3, false);
        Http2Stream stream2 = this.client.local().createStream(5, false);
        Http2Stream remoteStream = this.client.remote().createStream(4, false);
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream1.state());
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream2.state());
        this.client.goAwayReceived(3, 8L, null);
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream1.state());
        Assertions.assertEquals((Object)Http2Stream.State.CLOSED, (Object)stream2.state());
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)remoteStream.state());
        Assertions.assertEquals((int)3, (int)this.client.local().lastStreamKnownByPeer());
        Assertions.assertEquals((int)5, (int)this.client.local().lastStreamCreated());
        Assertions.assertEquals((int)-1, (int)this.client.remote().lastStreamKnownByPeer());
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)remoteStream.state());
    }

    @Test
    public void goAwaySentShouldCloseStreamsGreaterThanLastStream() throws Exception {
        Http2Stream stream1 = this.server.remote().createStream(3, false);
        Http2Stream stream2 = this.server.remote().createStream(5, false);
        Http2Stream localStream = this.server.local().createStream(4, false);
        this.server.goAwaySent(3, 8L, null);
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream1.state());
        Assertions.assertEquals((Object)Http2Stream.State.CLOSED, (Object)stream2.state());
        Assertions.assertEquals((int)3, (int)this.server.remote().lastStreamKnownByPeer());
        Assertions.assertEquals((int)5, (int)this.server.remote().lastStreamCreated());
        Assertions.assertEquals((int)-1, (int)this.server.local().lastStreamKnownByPeer());
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)localStream.state());
    }

    @Test
    public void serverCreateStreamShouldSucceed() throws Http2Exception {
        Http2Stream stream = this.server.local().createStream(2, false);
        Assertions.assertEquals((int)2, (int)stream.id());
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream.state());
        Assertions.assertEquals((int)1, (int)this.server.numActiveStreams());
        Assertions.assertEquals((int)2, (int)this.server.local().lastStreamCreated());
        stream = this.server.local().createStream(4, true);
        Assertions.assertEquals((int)4, (int)stream.id());
        Assertions.assertEquals((Object)Http2Stream.State.HALF_CLOSED_LOCAL, (Object)stream.state());
        Assertions.assertEquals((int)2, (int)this.server.numActiveStreams());
        Assertions.assertEquals((int)4, (int)this.server.local().lastStreamCreated());
        stream = this.server.remote().createStream(3, true);
        Assertions.assertEquals((int)3, (int)stream.id());
        Assertions.assertEquals((Object)Http2Stream.State.HALF_CLOSED_REMOTE, (Object)stream.state());
        Assertions.assertEquals((int)3, (int)this.server.numActiveStreams());
        Assertions.assertEquals((int)3, (int)this.server.remote().lastStreamCreated());
        stream = this.server.remote().createStream(5, false);
        Assertions.assertEquals((int)5, (int)stream.id());
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream.state());
        Assertions.assertEquals((int)4, (int)this.server.numActiveStreams());
        Assertions.assertEquals((int)5, (int)this.server.remote().lastStreamCreated());
    }

    @Test
    public void clientCreateStreamShouldSucceed() throws Http2Exception {
        Http2Stream stream = this.client.remote().createStream(2, false);
        Assertions.assertEquals((int)2, (int)stream.id());
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream.state());
        Assertions.assertEquals((int)1, (int)this.client.numActiveStreams());
        Assertions.assertEquals((int)2, (int)this.client.remote().lastStreamCreated());
        stream = this.client.remote().createStream(4, true);
        Assertions.assertEquals((int)4, (int)stream.id());
        Assertions.assertEquals((Object)Http2Stream.State.HALF_CLOSED_REMOTE, (Object)stream.state());
        Assertions.assertEquals((int)2, (int)this.client.numActiveStreams());
        Assertions.assertEquals((int)4, (int)this.client.remote().lastStreamCreated());
        Assertions.assertTrue((boolean)stream.isHeadersReceived());
        stream = this.client.local().createStream(3, true);
        Assertions.assertEquals((int)3, (int)stream.id());
        Assertions.assertEquals((Object)Http2Stream.State.HALF_CLOSED_LOCAL, (Object)stream.state());
        Assertions.assertEquals((int)3, (int)this.client.numActiveStreams());
        Assertions.assertEquals((int)3, (int)this.client.local().lastStreamCreated());
        Assertions.assertTrue((boolean)stream.isHeadersSent());
        stream = this.client.local().createStream(5, false);
        Assertions.assertEquals((int)5, (int)stream.id());
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream.state());
        Assertions.assertEquals((int)4, (int)this.client.numActiveStreams());
        Assertions.assertEquals((int)5, (int)this.client.local().lastStreamCreated());
    }

    @Test
    public void serverReservePushStreamShouldSucceed() throws Http2Exception {
        Http2Stream stream = this.server.remote().createStream(3, true);
        Http2Stream pushStream = this.server.local().reservePushStream(2, stream);
        Assertions.assertEquals((int)2, (int)pushStream.id());
        Assertions.assertEquals((Object)Http2Stream.State.RESERVED_LOCAL, (Object)pushStream.state());
        Assertions.assertEquals((int)1, (int)this.server.numActiveStreams());
        Assertions.assertEquals((int)2, (int)this.server.local().lastStreamCreated());
    }

    @Test
    public void clientReservePushStreamShouldSucceed() throws Http2Exception {
        Http2Stream stream = this.server.remote().createStream(3, true);
        Http2Stream pushStream = this.server.local().reservePushStream(4, stream);
        Assertions.assertEquals((int)4, (int)pushStream.id());
        Assertions.assertEquals((Object)Http2Stream.State.RESERVED_LOCAL, (Object)pushStream.state());
        Assertions.assertEquals((int)1, (int)this.server.numActiveStreams());
        Assertions.assertEquals((int)4, (int)this.server.local().lastStreamCreated());
    }

    @Test
    public void serverRemoteIncrementAndGetStreamShouldSucceed() throws Http2Exception {
        DefaultHttp2ConnectionTest.incrementAndGetStreamShouldSucceed(this.server.remote());
    }

    @Test
    public void serverLocalIncrementAndGetStreamShouldSucceed() throws Http2Exception {
        DefaultHttp2ConnectionTest.incrementAndGetStreamShouldSucceed(this.server.local());
    }

    @Test
    public void clientRemoteIncrementAndGetStreamShouldSucceed() throws Http2Exception {
        DefaultHttp2ConnectionTest.incrementAndGetStreamShouldSucceed(this.client.remote());
    }

    @Test
    public void clientLocalIncrementAndGetStreamShouldSucceed() throws Http2Exception {
        DefaultHttp2ConnectionTest.incrementAndGetStreamShouldSucceed(this.client.local());
    }

    @Test
    public void serverRemoteIncrementAndGetStreamShouldRespectOverflow() throws Http2Exception {
        DefaultHttp2ConnectionTest.incrementAndGetStreamShouldRespectOverflow(this.server.remote(), Integer.MAX_VALUE);
    }

    @Test
    public void serverLocalIncrementAndGetStreamShouldRespectOverflow() throws Http2Exception {
        DefaultHttp2ConnectionTest.incrementAndGetStreamShouldRespectOverflow(this.server.local(), 0x7FFFFFFE);
    }

    @Test
    public void clientRemoteIncrementAndGetStreamShouldRespectOverflow() throws Http2Exception {
        DefaultHttp2ConnectionTest.incrementAndGetStreamShouldRespectOverflow(this.client.remote(), 0x7FFFFFFE);
    }

    @Test
    public void clientLocalIncrementAndGetStreamShouldRespectOverflow() throws Http2Exception {
        DefaultHttp2ConnectionTest.incrementAndGetStreamShouldRespectOverflow(this.client.local(), Integer.MAX_VALUE);
    }

    @Test
    public void clientLocalCreateStreamExhaustedSpace() throws Http2Exception {
        this.client.local().createStream(Integer.MAX_VALUE, true);
        Http2Exception expected = (Http2Exception)Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionTest.this.client.local().createStream(Integer.MAX_VALUE, true);
            }
        });
        Assertions.assertEquals((Object)Http2Error.REFUSED_STREAM, (Object)expected.error());
        Assertions.assertEquals((Object)Http2Exception.ShutdownHint.GRACEFUL_SHUTDOWN, (Object)expected.shutdownHint());
    }

    @Test
    public void newStreamBehindExpectedShouldThrow() throws Http2Exception {
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionTest.this.server.local().createStream(0, true);
            }
        });
    }

    @Test
    public void newStreamNotForServerShouldThrow() throws Http2Exception {
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionTest.this.server.local().createStream(11, true);
            }
        });
    }

    @Test
    public void newStreamNotForClientShouldThrow() throws Http2Exception {
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionTest.this.client.local().createStream(10, true);
            }
        });
    }

    @Test
    public void createShouldThrowWhenMaxAllowedStreamsOpenExceeded() throws Http2Exception {
        this.server.local().maxActiveStreams(0);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionTest.this.server.local().createStream(2, true);
            }
        });
    }

    @Test
    public void serverCreatePushShouldFailOnRemoteEndpointWhenMaxAllowedStreamsExceeded() throws Http2Exception {
        this.server = new DefaultHttp2Connection(true, 0);
        this.server.remote().maxActiveStreams(1);
        final Http2Stream requestStream = this.server.remote().createStream(3, false);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionTest.this.server.remote().reservePushStream(2, requestStream);
            }
        });
    }

    @Test
    public void clientCreatePushShouldFailOnRemoteEndpointWhenMaxAllowedStreamsExceeded() throws Http2Exception {
        this.client = new DefaultHttp2Connection(false, 0);
        this.client.remote().maxActiveStreams(1);
        final Http2Stream requestStream = this.client.remote().createStream(2, false);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionTest.this.client.remote().reservePushStream(4, requestStream);
            }
        });
    }

    @Test
    public void serverCreatePushShouldSucceedOnLocalEndpointWhenMaxAllowedStreamsExceeded() throws Http2Exception {
        this.server = new DefaultHttp2Connection(true, 0);
        this.server.local().maxActiveStreams(1);
        Http2Stream requestStream = this.server.remote().createStream(3, false);
        Assertions.assertNotNull((Object)this.server.local().reservePushStream(2, requestStream));
    }

    @Test
    public void reserveWithPushDisallowedShouldThrow() throws Http2Exception {
        final Http2Stream stream = this.server.remote().createStream(3, true);
        this.server.remote().allowPushTo(false);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionTest.this.server.local().reservePushStream(2, stream);
            }
        });
    }

    @Test
    public void goAwayReceivedShouldDisallowLocalCreation() throws Http2Exception {
        this.server.goAwayReceived(0, 1L, Unpooled.EMPTY_BUFFER);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionTest.this.server.local().createStream(3, true);
            }
        });
    }

    @Test
    public void goAwayReceivedShouldAllowRemoteCreation() throws Http2Exception {
        this.server.goAwayReceived(0, 1L, Unpooled.EMPTY_BUFFER);
        this.server.remote().createStream(3, true);
    }

    @Test
    public void goAwaySentShouldDisallowRemoteCreation() throws Http2Exception {
        this.server.goAwaySent(0, 1L, Unpooled.EMPTY_BUFFER);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionTest.this.server.remote().createStream(2, true);
            }
        });
    }

    @Test
    public void goAwaySentShouldAllowLocalCreation() throws Http2Exception {
        this.server.goAwaySent(0, 1L, Unpooled.EMPTY_BUFFER);
        this.server.local().createStream(2, true);
    }

    @Test
    public void closeShouldSucceed() throws Http2Exception {
        Http2Stream stream = this.server.remote().createStream(3, true);
        stream.close();
        Assertions.assertEquals((Object)Http2Stream.State.CLOSED, (Object)stream.state());
        Assertions.assertEquals((int)0, (int)this.server.numActiveStreams());
    }

    @Test
    public void closeLocalWhenOpenShouldSucceed() throws Http2Exception {
        Http2Stream stream = this.server.remote().createStream(3, false);
        stream.closeLocalSide();
        Assertions.assertEquals((Object)Http2Stream.State.HALF_CLOSED_LOCAL, (Object)stream.state());
        Assertions.assertEquals((int)1, (int)this.server.numActiveStreams());
    }

    @Test
    public void closeRemoteWhenOpenShouldSucceed() throws Http2Exception {
        Http2Stream stream = this.server.remote().createStream(3, false);
        stream.closeRemoteSide();
        Assertions.assertEquals((Object)Http2Stream.State.HALF_CLOSED_REMOTE, (Object)stream.state());
        Assertions.assertEquals((int)1, (int)this.server.numActiveStreams());
    }

    @Test
    public void closeOnlyOpenSideShouldClose() throws Http2Exception {
        Http2Stream stream = this.server.remote().createStream(3, true);
        stream.closeLocalSide();
        Assertions.assertEquals((Object)Http2Stream.State.CLOSED, (Object)stream.state());
        Assertions.assertEquals((int)0, (int)this.server.numActiveStreams());
    }

    @Test
    public void localStreamInvalidStreamIdShouldThrow() {
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionTest.this.client.local().createStream(-2147483647, false);
            }
        });
    }

    @Test
    public void remoteStreamInvalidStreamIdShouldThrow() {
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionTest.this.client.remote().createStream(Integer.MIN_VALUE, false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listenerThrowShouldNotPreventOtherListenersFromBeingNotified() throws Http2Exception {
        boolean[] calledArray = new boolean[128];
        int methodIndex = 0;
        ((Http2Connection.Listener)Mockito.doAnswer((Answer)new ListenerExceptionThrower(calledArray, methodIndex)).when((Object)this.clientListener)).onStreamAdded((Http2Stream)Mockito.any(Http2Stream.class));
        ((Http2Connection.Listener)Mockito.doAnswer((Answer)new ListenerVerifyCallAnswer(calledArray, methodIndex++)).when((Object)this.clientListener2)).onStreamAdded((Http2Stream)Mockito.any(Http2Stream.class));
        ((Http2Connection.Listener)Mockito.doAnswer((Answer)new ListenerExceptionThrower(calledArray, methodIndex)).when((Object)this.clientListener)).onStreamActive((Http2Stream)Mockito.any(Http2Stream.class));
        ((Http2Connection.Listener)Mockito.doAnswer((Answer)new ListenerVerifyCallAnswer(calledArray, methodIndex++)).when((Object)this.clientListener2)).onStreamActive((Http2Stream)Mockito.any(Http2Stream.class));
        ((Http2Connection.Listener)Mockito.doAnswer((Answer)new ListenerExceptionThrower(calledArray, methodIndex)).when((Object)this.clientListener)).onStreamHalfClosed((Http2Stream)Mockito.any(Http2Stream.class));
        ((Http2Connection.Listener)Mockito.doAnswer((Answer)new ListenerVerifyCallAnswer(calledArray, methodIndex++)).when((Object)this.clientListener2)).onStreamHalfClosed((Http2Stream)Mockito.any(Http2Stream.class));
        ((Http2Connection.Listener)Mockito.doAnswer((Answer)new ListenerExceptionThrower(calledArray, methodIndex)).when((Object)this.clientListener)).onStreamClosed((Http2Stream)Mockito.any(Http2Stream.class));
        ((Http2Connection.Listener)Mockito.doAnswer((Answer)new ListenerVerifyCallAnswer(calledArray, methodIndex++)).when((Object)this.clientListener2)).onStreamClosed((Http2Stream)Mockito.any(Http2Stream.class));
        ((Http2Connection.Listener)Mockito.doAnswer((Answer)new ListenerExceptionThrower(calledArray, methodIndex)).when((Object)this.clientListener)).onStreamRemoved((Http2Stream)Mockito.any(Http2Stream.class));
        ((Http2Connection.Listener)Mockito.doAnswer((Answer)new ListenerVerifyCallAnswer(calledArray, methodIndex++)).when((Object)this.clientListener2)).onStreamRemoved((Http2Stream)Mockito.any(Http2Stream.class));
        ((Http2Connection.Listener)Mockito.doAnswer((Answer)new ListenerExceptionThrower(calledArray, methodIndex)).when((Object)this.clientListener)).onGoAwaySent(Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        ((Http2Connection.Listener)Mockito.doAnswer((Answer)new ListenerVerifyCallAnswer(calledArray, methodIndex++)).when((Object)this.clientListener2)).onGoAwaySent(Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        ((Http2Connection.Listener)Mockito.doAnswer((Answer)new ListenerExceptionThrower(calledArray, methodIndex)).when((Object)this.clientListener)).onGoAwayReceived(Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        ((Http2Connection.Listener)Mockito.doAnswer((Answer)new ListenerVerifyCallAnswer(calledArray, methodIndex++)).when((Object)this.clientListener2)).onGoAwayReceived(Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        ((Http2Connection.Listener)Mockito.doAnswer((Answer)new ListenerExceptionThrower(calledArray, methodIndex)).when((Object)this.clientListener)).onStreamAdded((Http2Stream)Mockito.any(Http2Stream.class));
        ((Http2Connection.Listener)Mockito.doAnswer((Answer)new ListenerVerifyCallAnswer(calledArray, methodIndex++)).when((Object)this.clientListener2)).onStreamAdded((Http2Stream)Mockito.any(Http2Stream.class));
        try {
            this.client.addListener(this.clientListener2);
            Http2Stream stream = this.client.local().createStream(3, false);
            ((Http2Connection.Listener)Mockito.verify((Object)this.clientListener)).onStreamAdded((Http2Stream)Mockito.any(Http2Stream.class));
            ((Http2Connection.Listener)Mockito.verify((Object)this.clientListener2)).onStreamAdded((Http2Stream)Mockito.any(Http2Stream.class));
            ((Http2Connection.Listener)Mockito.verify((Object)this.clientListener)).onStreamActive((Http2Stream)Mockito.any(Http2Stream.class));
            ((Http2Connection.Listener)Mockito.verify((Object)this.clientListener2)).onStreamActive((Http2Stream)Mockito.any(Http2Stream.class));
            Http2Stream reservedStream = this.client.remote().reservePushStream(2, stream);
            ((Http2Connection.Listener)Mockito.verify((Object)this.clientListener, (VerificationMode)Mockito.never())).onStreamActive(DefaultHttp2ConnectionTest.streamEq(reservedStream));
            ((Http2Connection.Listener)Mockito.verify((Object)this.clientListener2, (VerificationMode)Mockito.never())).onStreamActive(DefaultHttp2ConnectionTest.streamEq(reservedStream));
            reservedStream.open(false);
            ((Http2Connection.Listener)Mockito.verify((Object)this.clientListener)).onStreamActive(DefaultHttp2ConnectionTest.streamEq(reservedStream));
            ((Http2Connection.Listener)Mockito.verify((Object)this.clientListener2)).onStreamActive(DefaultHttp2ConnectionTest.streamEq(reservedStream));
            stream.closeLocalSide();
            ((Http2Connection.Listener)Mockito.verify((Object)this.clientListener)).onStreamHalfClosed((Http2Stream)Mockito.any(Http2Stream.class));
            ((Http2Connection.Listener)Mockito.verify((Object)this.clientListener2)).onStreamHalfClosed((Http2Stream)Mockito.any(Http2Stream.class));
            stream.close();
            ((Http2Connection.Listener)Mockito.verify((Object)this.clientListener)).onStreamClosed((Http2Stream)Mockito.any(Http2Stream.class));
            ((Http2Connection.Listener)Mockito.verify((Object)this.clientListener2)).onStreamClosed((Http2Stream)Mockito.any(Http2Stream.class));
            ((Http2Connection.Listener)Mockito.verify((Object)this.clientListener)).onStreamRemoved((Http2Stream)Mockito.any(Http2Stream.class));
            ((Http2Connection.Listener)Mockito.verify((Object)this.clientListener2)).onStreamRemoved((Http2Stream)Mockito.any(Http2Stream.class));
            this.client.goAwaySent(this.client.connectionStream().id(), Http2Error.INTERNAL_ERROR.code(), Unpooled.EMPTY_BUFFER);
            ((Http2Connection.Listener)Mockito.verify((Object)this.clientListener)).onGoAwaySent(Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
            ((Http2Connection.Listener)Mockito.verify((Object)this.clientListener2)).onGoAwaySent(Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
            this.client.goAwayReceived(this.client.connectionStream().id(), Http2Error.INTERNAL_ERROR.code(), Unpooled.EMPTY_BUFFER);
            ((Http2Connection.Listener)Mockito.verify((Object)this.clientListener)).onGoAwayReceived(Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
            ((Http2Connection.Listener)Mockito.verify((Object)this.clientListener2)).onGoAwayReceived(Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        }
        finally {
            this.client.removeListener(this.clientListener2);
        }
    }

    private void testRemoveAllStreams() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final Promise promise = group.next().newPromise();
        this.client.close(promise).addListener((GenericFutureListener)new FutureListener<Void>(){

            public void operationComplete(Future<Void> future) throws Exception {
                Assertions.assertTrue((boolean)promise.isDone());
                latch.countDown();
            }
        });
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
    }

    private static void incrementAndGetStreamShouldRespectOverflow(final Http2Connection.Endpoint<?> endpoint, int streamId) {
        Assertions.assertTrue((streamId > 0 ? 1 : 0) != 0);
        try {
            endpoint.createStream(streamId, true);
            streamId = endpoint.incrementAndGetNextStreamId();
        }
        catch (Throwable t) {
            Assertions.fail((Throwable)t);
        }
        Assertions.assertTrue((streamId < 0 ? 1 : 0) != 0);
        final int finalStreamId = streamId;
        Assertions.assertThrows(Http2NoMoreStreamIdsException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                endpoint.createStream(finalStreamId, true);
            }
        });
    }

    private static void incrementAndGetStreamShouldSucceed(Http2Connection.Endpoint<?> endpoint) throws Http2Exception {
        Http2Stream streamA = endpoint.createStream(endpoint.incrementAndGetNextStreamId(), true);
        Http2Stream streamB = endpoint.createStream(streamA.id() + 2, true);
        Http2Stream streamC = endpoint.createStream(endpoint.incrementAndGetNextStreamId(), true);
        Assertions.assertEquals((int)(streamB.id() + 2), (int)streamC.id());
        endpoint.createStream(streamC.id() + 2, true);
    }

    private static <T> T streamEq(T stream) {
        return (T)(stream == null ? ArgumentMatchers.isNull() : Mockito.eq(stream));
    }

    private static final class ListenerVerifyCallAnswer
    implements Answer<Void> {
        private final boolean[] array;
        private final int index;

        ListenerVerifyCallAnswer(boolean[] array, int index) {
            this.array = array;
            this.index = index;
        }

        public Void answer(InvocationOnMock invocation) throws Throwable {
            Assertions.assertTrue((boolean)this.array[this.index]);
            return null;
        }
    }

    private static final class ListenerExceptionThrower
    implements Answer<Void> {
        private static final RuntimeException FAKE_EXCEPTION = new RuntimeException("Fake Exception");
        private final boolean[] array;
        private final int index;

        ListenerExceptionThrower(boolean[] array, int index) {
            this.array = array;
            this.index = index;
        }

        public Void answer(InvocationOnMock invocation) throws Throwable {
            this.array[this.index] = true;
            throw FAKE_EXCEPTION;
        }
    }
}

