/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.channel.unix;

import java.util.Collections;
import java.util.LinkedList;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.ByteBufAllocator;
import org.apache.hive.druid.io.netty.buffer.CompositeByteBuf;
import org.apache.hive.druid.io.netty.buffer.PooledByteBufAllocator;
import org.apache.hive.druid.io.netty.buffer.UnpooledByteBufAllocator;
import org.apache.hive.druid.io.netty.channel.unix.UnixChannelUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnixChannelUtilTest {
    private static final int IOV_MAX = 1024;

    @Test
    public void testPooledAllocatorIsBufferCopyNeededForWrite() {
        UnixChannelUtilTest.testIsBufferCopyNeededForWrite((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
    }

    @Test
    public void testUnPooledAllocatorIsBufferCopyNeededForWrite() {
        UnixChannelUtilTest.testIsBufferCopyNeededForWrite((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
    }

    private static void testIsBufferCopyNeededForWrite(ByteBufAllocator alloc) {
        ByteBuf byteBuf = alloc.directBuffer();
        Assertions.assertFalse((boolean)UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf, (int)1024));
        Assertions.assertFalse((boolean)UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf.asReadOnly(), (int)1024));
        Assertions.assertTrue((boolean)byteBuf.release());
        byteBuf = alloc.heapBuffer();
        Assertions.assertTrue((boolean)UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf, (int)1024));
        Assertions.assertTrue((boolean)UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf.asReadOnly(), (int)1024));
        Assertions.assertTrue((boolean)byteBuf.release());
        UnixChannelUtilTest.assertCompositeByteBufIsBufferCopyNeededForWrite(alloc, 2, 0, false);
        UnixChannelUtilTest.assertCompositeByteBufIsBufferCopyNeededForWrite(alloc, 1025, 0, true);
        UnixChannelUtilTest.assertCompositeByteBufIsBufferCopyNeededForWrite(alloc, 0, 2, true);
        UnixChannelUtilTest.assertCompositeByteBufIsBufferCopyNeededForWrite(alloc, 1, 1, true);
    }

    private static void assertCompositeByteBufIsBufferCopyNeededForWrite(ByteBufAllocator alloc, int numDirect, int numHeap, boolean expected) {
        CompositeByteBuf comp = alloc.compositeBuffer(numDirect + numHeap);
        LinkedList<ByteBuf> byteBufs = new LinkedList<ByteBuf>();
        while (numDirect > 0) {
            byteBufs.add(alloc.directBuffer(1));
            --numDirect;
        }
        while (numHeap > 0) {
            byteBufs.add(alloc.heapBuffer(1));
            --numHeap;
        }
        Collections.shuffle(byteBufs);
        for (ByteBuf byteBuf : byteBufs) {
            comp.addComponent(byteBuf);
        }
        Assertions.assertEquals((Object)expected, (Object)UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)comp, (int)1024), (String)((Object)byteBufs).toString());
        Assertions.assertTrue((boolean)comp.release());
    }
}

