/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.channel.epoll;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hive.druid.io.netty.bootstrap.ServerBootstrap;
import org.apache.hive.druid.io.netty.channel.epoll.EpollSocketTestPermutation;
import org.apache.hive.druid.io.netty.channel.epoll.LinuxSocket;
import org.apache.hive.druid.io.netty.channel.unix.Buffer;
import org.apache.hive.druid.io.netty.testsuite.transport.TestsuitePermutation;
import org.apache.hive.druid.io.netty.testsuite.transport.socket.AbstractSocketShutdownOutputByPeerTest;

public class EpollDomainSocketShutdownOutputByPeerTest
extends AbstractSocketShutdownOutputByPeerTest<LinuxSocket> {
    protected List<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> newFactories() {
        return EpollSocketTestPermutation.INSTANCE.serverDomainSocket();
    }

    protected SocketAddress newSocketAddress() {
        return EpollSocketTestPermutation.newDomainSocketAddress();
    }

    protected void shutdownOutput(LinuxSocket s) throws IOException {
        s.shutdown(false, true);
    }

    protected void connect(LinuxSocket s, SocketAddress address) throws IOException {
        s.connect(address);
    }

    protected void close(LinuxSocket s) throws IOException {
        s.close();
    }

    protected void write(LinuxSocket s, int data) throws IOException {
        ByteBuffer buf = Buffer.allocateDirectWithNativeOrder((int)4);
        buf.putInt(data);
        buf.flip();
        s.send(buf, buf.position(), buf.limit());
        Buffer.free((ByteBuffer)buf);
    }

    protected LinuxSocket newSocket() {
        return LinuxSocket.newSocketDomain();
    }
}

