/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.channel.epoll;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hive.druid.io.netty.bootstrap.Bootstrap;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.CompositeByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.channel.ChannelOption;
import org.apache.hive.druid.io.netty.channel.FixedRecvByteBufAllocator;
import org.apache.hive.druid.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hive.druid.io.netty.channel.epoll.EpollChannelOption;
import org.apache.hive.druid.io.netty.channel.epoll.EpollDatagramChannel;
import org.apache.hive.druid.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.hive.druid.io.netty.channel.epoll.EpollSocketTestPermutation;
import org.apache.hive.druid.io.netty.channel.socket.DatagramPacket;
import org.apache.hive.druid.io.netty.channel.socket.InternetProtocolFamily;
import org.apache.hive.druid.io.netty.channel.unix.SegmentedDatagramPacket;
import org.apache.hive.druid.io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import org.apache.hive.druid.io.netty.testsuite.transport.TestsuitePermutation;
import org.apache.hive.druid.io.netty.testsuite.transport.socket.DatagramUnicastInetTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class EpollDatagramUnicastTest
extends DatagramUnicastInetTest {
    protected List<TestsuitePermutation.BootstrapComboFactory<Bootstrap, Bootstrap>> newFactories() {
        return EpollSocketTestPermutation.INSTANCE.datagram(InternetProtocolFamily.IPv4);
    }

    public void testSimpleSendWithConnect(Bootstrap sb, Bootstrap cb) throws Throwable {
        sb.option(EpollChannelOption.IP_RECVORIGDSTADDR, (Object)true);
        super.testSimpleSendWithConnect(sb, cb);
        sb.option(EpollChannelOption.IP_RECVORIGDSTADDR, (Object)false);
    }

    @Test
    public void testSendSegmentedDatagramPacket(TestInfo testInfo) throws Throwable {
        this.run(testInfo, (AbstractComboTestsuiteTest.Runner)new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                EpollDatagramUnicastTest.this.testSendSegmentedDatagramPacket(bootstrap, bootstrap2);
            }
        });
    }

    public void testSendSegmentedDatagramPacket(Bootstrap sb, Bootstrap cb) throws Throwable {
        this.testSegmentedDatagramPacket(sb, cb, false, false);
    }

    @Test
    public void testSendSegmentedDatagramPacketComposite(TestInfo testInfo) throws Throwable {
        this.run(testInfo, (AbstractComboTestsuiteTest.Runner)new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                EpollDatagramUnicastTest.this.testSendSegmentedDatagramPacketComposite(bootstrap, bootstrap2);
            }
        });
    }

    public void testSendSegmentedDatagramPacketComposite(Bootstrap sb, Bootstrap cb) throws Throwable {
        this.testSegmentedDatagramPacket(sb, cb, true, false);
    }

    @Test
    public void testSendAndReceiveSegmentedDatagramPacket(TestInfo testInfo) throws Throwable {
        this.run(testInfo, (AbstractComboTestsuiteTest.Runner)new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                EpollDatagramUnicastTest.this.testSendAndReceiveSegmentedDatagramPacket(bootstrap, bootstrap2);
            }
        });
    }

    public void testSendAndReceiveSegmentedDatagramPacket(Bootstrap sb, Bootstrap cb) throws Throwable {
        this.testSegmentedDatagramPacket(sb, cb, false, true);
    }

    @Test
    public void testSendAndReceiveSegmentedDatagramPacketComposite(TestInfo testInfo) throws Throwable {
        this.run(testInfo, (AbstractComboTestsuiteTest.Runner)new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                EpollDatagramUnicastTest.this.testSendAndReceiveSegmentedDatagramPacketComposite(bootstrap, bootstrap2);
            }
        });
    }

    public void testSendAndReceiveSegmentedDatagramPacketComposite(Bootstrap sb, Bootstrap cb) throws Throwable {
        this.testSegmentedDatagramPacket(sb, cb, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSegmentedDatagramPacket(Bootstrap sb, Bootstrap cb, boolean composite, boolean gro) throws Throwable {
        if (!(cb.group() instanceof EpollEventLoopGroup)) {
            return;
        }
        if (gro && !(sb.group() instanceof EpollEventLoopGroup)) {
            return;
        }
        Assumptions.assumeTrue((boolean)EpollDatagramChannel.isSegmentedDatagramPacketSupported());
        Channel sc = null;
        Channel cc = null;
        try {
            ByteBuf buffer;
            cb.handler((ChannelHandler)new SimpleChannelInboundHandler<Object>(){

                public void channelRead0(ChannelHandlerContext ctx, Object msgs) {
                }
            });
            cc = cb.bind(this.newSocketAddress()).sync().channel();
            int numBuffers = 16;
            int segmentSize = 512;
            int bufferCapacity = 8192;
            final CountDownLatch latch = new CountDownLatch(16);
            AtomicReference errorRef = new AtomicReference();
            if (gro) {
                sb.option(EpollChannelOption.UDP_GRO, (Object)true);
                sb.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(bufferCapacity));
            }
            if ((sc = ((Bootstrap)sb.handler((ChannelHandler)new SimpleChannelInboundHandler<DatagramPacket>(){

                public void channelRead0(ChannelHandlerContext ctx, DatagramPacket packet) {
                    if (((ByteBuf)packet.content()).readableBytes() == 512) {
                        latch.countDown();
                    }
                }
            })).bind(this.newSocketAddress()).sync().channel()) instanceof EpollDatagramChannel) {
                Assertions.assertEquals((Object)gro, (Object)sc.config().getOption(EpollChannelOption.UDP_GRO));
            }
            InetSocketAddress addr = this.sendToAddress((InetSocketAddress)sc.localAddress());
            if (composite) {
                CompositeByteBuf compositeBuffer = Unpooled.compositeBuffer();
                for (int i = 0; i < 16; ++i) {
                    compositeBuffer.addComponent(true, Unpooled.directBuffer((int)512).writeZero(512));
                }
                buffer = compositeBuffer;
            } else {
                buffer = Unpooled.directBuffer((int)bufferCapacity).writeZero(bufferCapacity);
            }
            cc.writeAndFlush((Object)new SegmentedDatagramPacket(buffer, 512, addr)).sync();
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                Throwable error = (Throwable)errorRef.get();
                if (error != null) {
                    throw error;
                }
                Assertions.fail();
            }
        }
        finally {
            if (cc != null) {
                cc.close().sync();
            }
            if (sc != null) {
                sc.close().sync();
            }
        }
    }
}

