/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.metrics;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.guice.GuiceInjectors;
import org.apache.hive.druid.io.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.io.druid.guice.annotations.Self;
import org.apache.hive.druid.io.druid.initialization.Initialization;
import org.apache.hive.druid.io.druid.server.DruidNode;
import org.apache.hive.druid.io.druid.server.metrics.DataSourceTaskIdHolder;
import org.junit.Assert;
import org.junit.Test;

public class MetricsModuleTest {
    @Test
    public void testSimpleInjection() {
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("test-inject", null, null, null, true, false));
            }
        }));
        DataSourceTaskIdHolder dimensionIdHolder = new DataSourceTaskIdHolder();
        injector.injectMembers((Object)dimensionIdHolder);
        Assert.assertNull((Object)dimensionIdHolder.getDataSource());
        Assert.assertNull((Object)dimensionIdHolder.getTaskId());
    }

    @Test
    public void testSimpleInjectionWithValues() {
        String dataSource = "some datasource";
        String taskId = "some task";
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("test-inject", null, null, null, true, false));
                binder.bind(Key.get(String.class, (Annotation)Names.named((String)"druidDataSource"))).toInstance((Object)"some datasource");
                binder.bind(Key.get(String.class, (Annotation)Names.named((String)"druidTaskId"))).toInstance((Object)"some task");
            }
        }));
        DataSourceTaskIdHolder dimensionIdHolder = new DataSourceTaskIdHolder();
        injector.injectMembers((Object)dimensionIdHolder);
        Assert.assertEquals((Object)"some datasource", (Object)dimensionIdHolder.getDataSource());
        Assert.assertEquals((Object)"some task", (Object)dimensionIdHolder.getTaskId());
    }
}

