/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.log;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.jackson.JacksonUtils;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.LegacyDataSource;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QuerySegmentWalker;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.io.druid.server.QueryStats;
import org.apache.hive.druid.io.druid.server.RequestLogLine;
import org.apache.hive.druid.io.druid.server.log.FakeQuery;
import org.apache.hive.druid.io.druid.server.log.LoggingRequestLogger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.OutputStreamAppender;
import org.apache.logging.log4j.core.layout.JsonLayout;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class LoggingRequestLoggerTest {
    private static final ObjectMapper mapper = new DefaultObjectMapper();
    private static final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private static Appender appender;
    final DateTime timestamp = DateTimes.of((String)"2016-01-01T00:00:00Z");
    final String remoteAddr = "some.host.tld";
    final Map<String, Object> queryContext = ImmutableMap.of((Object)"foo", (Object)"bar");
    final Query query = new FakeQuery((DataSource)new LegacyDataSource("datasource"), new QuerySegmentSpec(){

        public List<Interval> getIntervals() {
            return Collections.singletonList(Intervals.of((String)"2016-01-01T00Z/2016-01-02T00Z"));
        }

        public <T> QueryRunner<T> lookup(Query<T> query, QuerySegmentWalker walker) {
            return null;
        }
    }, false, this.queryContext);
    final QueryStats queryStats = new QueryStats((Map)ImmutableMap.of());
    final RequestLogLine logLine = new RequestLogLine(this.timestamp, "some.host.tld", this.query, this.queryStats);

    @BeforeClass
    public static void setUpStatic() throws Exception {
        appender = OutputStreamAppender.newBuilder().setName("test stream").setTarget((OutputStream)baos).setLayout((Layout)JsonLayout.createLayout((boolean)false, (boolean)true, (boolean)false, (boolean)true, (boolean)true, (Charset)Charsets.UTF_8)).build();
        Logger logger = (Logger)LogManager.getLogger(LoggingRequestLogger.class);
        appender.start();
        logger.addAppender(appender);
    }

    @After
    public void tearDown() {
        baos.reset();
    }

    @AfterClass
    public static void tearDownStatic() {
        Logger logger = (Logger)LogManager.getLogger(LoggingRequestLogger.class);
        logger.removeAppender(appender);
        appender.stop();
    }

    @Test
    public void testSimpleLogging() throws Exception {
        LoggingRequestLogger requestLogger = new LoggingRequestLogger((ObjectMapper)new DefaultObjectMapper(), false, false);
        requestLogger.log(this.logLine);
    }

    @Test
    public void testLoggingMDC() throws Exception {
        LoggingRequestLogger requestLogger = new LoggingRequestLogger((ObjectMapper)new DefaultObjectMapper(), true, false);
        requestLogger.log(this.logLine);
        Map<String, Object> map = LoggingRequestLoggerTest.readContextMap(baos.toByteArray());
        Assert.assertEquals((Object)"datasource", (Object)map.get("dataSource"));
        Assert.assertEquals((Object)"PT86400S", (Object)map.get("duration"));
        Assert.assertEquals((Object)"false", (Object)map.get("hasFilters"));
        Assert.assertEquals((Object)"fake", (Object)map.get("queryType"));
        Assert.assertEquals((Object)"some.host.tld", (Object)map.get("remoteAddr"));
        Assert.assertEquals((Object)"false", (Object)map.get("descending"));
        Assert.assertNull((Object)map.get("foo"));
    }

    @Test
    public void testLoggingMDCContext() throws Exception {
        LoggingRequestLogger requestLogger = new LoggingRequestLogger((ObjectMapper)new DefaultObjectMapper(), true, true);
        requestLogger.log(this.logLine);
        Map<String, Object> map = LoggingRequestLoggerTest.readContextMap(baos.toByteArray());
        Assert.assertEquals((Object)"datasource", (Object)map.get("dataSource"));
        Assert.assertEquals((Object)"PT86400S", (Object)map.get("duration"));
        Assert.assertEquals((Object)"false", (Object)map.get("hasFilters"));
        Assert.assertEquals((Object)"fake", (Object)map.get("queryType"));
        Assert.assertEquals((Object)"some.host.tld", (Object)map.get("remoteAddr"));
        Assert.assertEquals((Object)"false", (Object)map.get("descending"));
        Assert.assertEquals((Object)"bar", (Object)map.get("foo"));
    }

    private static Map<String, Object> readContextMap(byte[] bytes) throws Exception {
        Map rawMap = (Map)mapper.readValue(bytes, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        Object contextMap = rawMap.get("contextMap");
        if (contextMap == null) {
            return null;
        }
        Collection contextList = (Collection)contextMap;
        HashMap context = new HashMap();
        for (Map microContext : contextList) {
            String key = microContext.get("key").toString();
            Object value = microContext.get("value");
            if (key == null || value == null) continue;
            context.put(key, value);
        }
        return ImmutableMap.copyOf(context);
    }
}

