/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.listener.announcer;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.api.GetDataWatchBackgroundStatable;
import org.apache.curator.utils.ZKPaths;
import org.apache.hive.druid.io.druid.curator.CuratorTestBase;
import org.apache.hive.druid.io.druid.curator.announcement.Announcer;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.io.druid.segment.CloserRule;
import org.apache.hive.druid.io.druid.server.http.HostAndPortWithScheme;
import org.apache.hive.druid.io.druid.server.initialization.ZkPathsConfig;
import org.apache.hive.druid.io.druid.server.listener.announcer.ListenerResourceAnnouncer;
import org.apache.hive.druid.io.druid.server.listener.announcer.ListeningAnnouncerConfig;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ListenerResourceAnnouncerTest
extends CuratorTestBase {
    private final ListeningAnnouncerConfig listeningAnnouncerConfig = new ListeningAnnouncerConfig(new ZkPathsConfig());
    private final String listenerKey = "someKey";
    private final String announcePath = this.listeningAnnouncerConfig.getAnnouncementPath("someKey");
    @Rule
    public CloserRule closerRule = new CloserRule(true);
    private ExecutorService executorService;

    @Before
    public void setUp() {
        this.executorService = Execs.singleThreaded((String)"listener-resource--%d");
    }

    @After
    public void tearDown() {
        this.executorService.shutdownNow();
    }

    @Test
    public void testAnnouncerBehaves() throws Exception {
        this.setupServerAndCurator();
        this.closerRule.closeLater(this.server);
        this.curator.start();
        this.closerRule.closeLater(this.curator);
        Assert.assertNotNull((Object)this.curator.create().forPath("/druid"));
        Assert.assertTrue((boolean)this.curator.blockUntilConnected(10, TimeUnit.SECONDS));
        final Announcer announcer = new Announcer(this.curator, this.executorService);
        HostAndPortWithScheme node = HostAndPortWithScheme.fromString((String)"localhost");
        ListenerResourceAnnouncer listenerResourceAnnouncer = new ListenerResourceAnnouncer(announcer, this.listeningAnnouncerConfig, "someKey", node){};
        listenerResourceAnnouncer.start();
        announcer.start();
        this.closerRule.closeLater(new Closeable(){

            @Override
            public void close() throws IOException {
                announcer.stop();
            }
        });
        Assert.assertNotNull((Object)this.curator.checkExists().forPath(this.announcePath));
        String nodePath = ZKPaths.makePath((String)this.announcePath, (String)StringUtils.format((String)"%s:%s", (Object[])new Object[]{node.getScheme(), node.getHostText()}));
        Assert.assertNotNull((Object)this.curator.checkExists().forPath(nodePath));
        Assert.assertEquals((long)8L, (long)((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath(nodePath)).length);
        Assert.assertNull((Object)this.curator.checkExists().forPath(this.listeningAnnouncerConfig.getAnnouncementPath("someKeyFOO")));
        listenerResourceAnnouncer.stop();
        listenerResourceAnnouncer.start();
        listenerResourceAnnouncer.start();
        listenerResourceAnnouncer.stop();
        listenerResourceAnnouncer.stop();
        listenerResourceAnnouncer.start();
        listenerResourceAnnouncer.stop();
        listenerResourceAnnouncer.start();
        listenerResourceAnnouncer.stop();
        Assert.assertNull((Object)this.curator.checkExists().forPath(nodePath));
    }

    @Test
    public void testStartCorrect() throws Exception {
        Announcer announcer = (Announcer)EasyMock.createStrictMock(Announcer.class);
        HostAndPortWithScheme node = HostAndPortWithScheme.fromString((String)"some_host");
        ListenerResourceAnnouncer resourceAnnouncer = new ListenerResourceAnnouncer(announcer, this.listeningAnnouncerConfig, "someKey", node){};
        announcer.announce((String)EasyMock.eq((Object)ZKPaths.makePath((String)this.announcePath, (String)StringUtils.format((String)"%s:%s", (Object[])new Object[]{node.getScheme(), node.getHostText()}))), EasyMock.aryEq((byte[])resourceAnnouncer.getAnnounceBytes()));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{announcer});
        resourceAnnouncer.start();
        EasyMock.verify((Object[])new Object[]{announcer});
    }
}

