/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.http.security;

import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.server.security.AllowAllAuthenticator;
import org.apache.hive.druid.io.druid.server.security.AuthenticationResult;
import org.apache.hive.druid.io.druid.server.security.Authenticator;
import org.apache.hive.druid.io.druid.server.security.PreResponseAuthorizationCheckFilter;
import org.easymock.EasyMock;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class PreResponseAuthorizationCheckFilterTest {
    private static List<Authenticator> authenticators = Lists.newArrayList((Object[])new Authenticator[]{new AllowAllAuthenticator()});
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testValidRequest() throws Exception {
        AuthenticationResult authenticationResult = new AuthenticationResult("so-very-valid", "so-very-valid", null);
        HttpServletRequest req = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        HttpServletResponse resp = (HttpServletResponse)EasyMock.createStrictMock(HttpServletResponse.class);
        FilterChain filterChain = (FilterChain)EasyMock.createNiceMock(FilterChain.class);
        ServletOutputStream outputStream = (ServletOutputStream)EasyMock.createNiceMock(ServletOutputStream.class);
        EasyMock.expect((Object)req.getAttribute("Druid-Authentication-Result")).andReturn((Object)authenticationResult).once();
        EasyMock.expect((Object)req.getAttribute("Druid-Authorization-Checked")).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{req, resp, filterChain, outputStream});
        PreResponseAuthorizationCheckFilter filter = new PreResponseAuthorizationCheckFilter(authenticators, (ObjectMapper)new DefaultObjectMapper());
        filter.doFilter((ServletRequest)req, (ServletResponse)resp, filterChain);
        EasyMock.verify((Object[])new Object[]{req, resp, filterChain, outputStream});
    }

    @Test
    public void testAuthenticationFailedRequest() throws Exception {
        HttpServletRequest req = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        HttpServletResponse resp = (HttpServletResponse)EasyMock.createStrictMock(HttpServletResponse.class);
        FilterChain filterChain = (FilterChain)EasyMock.createNiceMock(FilterChain.class);
        ServletOutputStream outputStream = (ServletOutputStream)EasyMock.createNiceMock(ServletOutputStream.class);
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).once();
        EasyMock.expect((Object)req.getAttribute("Druid-Authentication-Result")).andReturn(null).once();
        resp.setStatus(401);
        EasyMock.expectLastCall().once();
        resp.setContentType("application/json");
        EasyMock.expectLastCall().once();
        resp.setCharacterEncoding("UTF-8");
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{req, resp, filterChain, outputStream});
        PreResponseAuthorizationCheckFilter filter = new PreResponseAuthorizationCheckFilter(authenticators, (ObjectMapper)new DefaultObjectMapper());
        filter.doFilter((ServletRequest)req, (ServletResponse)resp, filterChain);
        EasyMock.verify((Object[])new Object[]{req, resp, filterChain, outputStream});
    }

    @Test
    public void testMissingAuthorizationCheck() throws Exception {
        EmittingLogger.registerEmitter((ServiceEmitter)((ServiceEmitter)EasyMock.createNiceMock(ServiceEmitter.class)));
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage("Request did not have an authorization check performed.");
        AuthenticationResult authenticationResult = new AuthenticationResult("so-very-valid", "so-very-valid", null);
        HttpServletRequest req = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        HttpServletResponse resp = (HttpServletResponse)EasyMock.createStrictMock(HttpServletResponse.class);
        FilterChain filterChain = (FilterChain)EasyMock.createNiceMock(FilterChain.class);
        ServletOutputStream outputStream = (ServletOutputStream)EasyMock.createNiceMock(ServletOutputStream.class);
        EasyMock.expect((Object)req.getAttribute("Druid-Authentication-Result")).andReturn((Object)authenticationResult).once();
        EasyMock.expect((Object)req.getAttribute("Druid-Authorization-Checked")).andReturn(null).once();
        EasyMock.expect((Object)resp.getStatus()).andReturn((Object)200).once();
        EasyMock.expect((Object)req.getRequestURI()).andReturn((Object)"uri").once();
        EasyMock.expect((Object)req.getMethod()).andReturn((Object)"GET").once();
        EasyMock.expect((Object)req.getRemoteAddr()).andReturn((Object)"1.2.3.4").once();
        EasyMock.expect((Object)req.getRemoteHost()).andReturn((Object)"ahostname").once();
        EasyMock.expect((Object)resp.isCommitted()).andReturn((Object)true).once();
        resp.setStatus(403);
        EasyMock.expectLastCall().once();
        resp.setContentType("application/json");
        EasyMock.expectLastCall().once();
        resp.setCharacterEncoding("UTF-8");
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{req, resp, filterChain, outputStream});
        PreResponseAuthorizationCheckFilter filter = new PreResponseAuthorizationCheckFilter(authenticators, (ObjectMapper)new DefaultObjectMapper());
        filter.doFilter((ServletRequest)req, (ServletResponse)resp, filterChain);
        EasyMock.verify((Object[])new Object[]{req, resp, filterChain, outputStream});
    }

    @Test
    public void testMissingAuthorizationCheckWithError() throws Exception {
        EmittingLogger.registerEmitter((ServiceEmitter)((ServiceEmitter)EasyMock.createNiceMock(ServiceEmitter.class)));
        AuthenticationResult authenticationResult = new AuthenticationResult("so-very-valid", "so-very-valid", null);
        HttpServletRequest req = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        HttpServletResponse resp = (HttpServletResponse)EasyMock.createStrictMock(HttpServletResponse.class);
        FilterChain filterChain = (FilterChain)EasyMock.createNiceMock(FilterChain.class);
        ServletOutputStream outputStream = (ServletOutputStream)EasyMock.createNiceMock(ServletOutputStream.class);
        EasyMock.expect((Object)req.getAttribute("Druid-Authentication-Result")).andReturn((Object)authenticationResult).once();
        EasyMock.expect((Object)req.getAttribute("Druid-Authorization-Checked")).andReturn(null).once();
        EasyMock.expect((Object)resp.getStatus()).andReturn((Object)404).once();
        EasyMock.replay((Object[])new Object[]{req, resp, filterChain, outputStream});
        PreResponseAuthorizationCheckFilter filter = new PreResponseAuthorizationCheckFilter(authenticators, (ObjectMapper)new DefaultObjectMapper());
        filter.doFilter((ServletRequest)req, (ServletResponse)resp, filterChain);
        EasyMock.verify((Object[])new Object[]{req, resp, filterChain, outputStream});
    }
}

