/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.utils.ZKPaths;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.client.DruidDataSource;
import org.apache.hive.druid.io.druid.client.DruidServer;
import org.apache.hive.druid.io.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.io.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.io.druid.client.ServerInventoryView;
import org.apache.hive.druid.io.druid.client.SingleServerInventoryView;
import org.apache.hive.druid.io.druid.common.config.JacksonConfigManager;
import org.apache.hive.druid.io.druid.curator.CuratorTestBase;
import org.apache.hive.druid.io.druid.curator.discovery.NoopServiceAnnouncer;
import org.apache.hive.druid.io.druid.curator.discovery.ServiceAnnouncer;
import org.apache.hive.druid.io.druid.discovery.DruidLeaderSelector;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.metadata.MetadataRuleManager;
import org.apache.hive.druid.io.druid.metadata.MetadataSegmentManager;
import org.apache.hive.druid.io.druid.server.DruidNode;
import org.apache.hive.druid.io.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.io.druid.server.coordination.ServerType;
import org.apache.hive.druid.io.druid.server.coordinator.BalancerStrategyFactory;
import org.apache.hive.druid.io.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.hive.druid.io.druid.server.coordinator.CostBalancerStrategyFactory;
import org.apache.hive.druid.io.druid.server.coordinator.CuratorLoadQueuePeon;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinator;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.hive.druid.io.druid.server.coordinator.LoadPeonCallback;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeon;
import org.apache.hive.druid.io.druid.server.coordinator.TestDruidCoordinatorConfig;
import org.apache.hive.druid.io.druid.server.coordinator.rules.ForeverLoadRule;
import org.apache.hive.druid.io.druid.server.initialization.ZkPathsConfig;
import org.apache.hive.druid.io.druid.server.lookup.cache.LookupCoordinatorManager;
import org.apache.hive.druid.io.druid.server.metrics.NoopServiceEmitter;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DruidCoordinatorTest
extends CuratorTestBase {
    private DruidCoordinator coordinator;
    private MetadataSegmentManager databaseSegmentManager;
    private SingleServerInventoryView serverInventoryView;
    private ScheduledExecutorFactory scheduledExecutorFactory;
    private DruidServer druidServer;
    private DruidServer druidServer2;
    private DataSegment segment;
    private ConcurrentMap<String, LoadQueuePeon> loadManagementPeons;
    private LoadQueuePeon loadQueuePeon;
    private MetadataRuleManager metadataRuleManager;
    private CountDownLatch leaderAnnouncerLatch;
    private CountDownLatch leaderUnannouncerLatch;
    private PathChildrenCache pathChildrenCache;
    private DruidCoordinatorConfig druidCoordinatorConfig;
    private ObjectMapper objectMapper;
    private JacksonConfigManager configManager;
    private DruidNode druidNode;
    private static final String LOADPATH = "/druid/loadqueue/localhost:1234";
    private static final long COORDINATOR_START_DELAY = 1L;
    private static final long COORDINATOR_PERIOD = 100L;

    @Before
    public void setUp() throws Exception {
        this.druidServer = (DruidServer)EasyMock.createMock(DruidServer.class);
        this.serverInventoryView = (SingleServerInventoryView)EasyMock.createMock(SingleServerInventoryView.class);
        this.databaseSegmentManager = (MetadataSegmentManager)EasyMock.createNiceMock(MetadataSegmentManager.class);
        this.metadataRuleManager = (MetadataRuleManager)EasyMock.createNiceMock(MetadataRuleManager.class);
        this.configManager = (JacksonConfigManager)EasyMock.createNiceMock(JacksonConfigManager.class);
        EasyMock.expect((Object)this.configManager.watch(EasyMock.anyString(), (Class)EasyMock.anyObject(Class.class), EasyMock.anyObject())).andReturn(new AtomicReference<CoordinatorDynamicConfig>(new CoordinatorDynamicConfig.Builder().build())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.configManager});
        this.setupServerAndCurator();
        this.curator.start();
        this.curator.blockUntilConnected();
        this.curator.create().creatingParentsIfNeeded().forPath(LOADPATH);
        this.objectMapper = new DefaultObjectMapper();
        this.druidCoordinatorConfig = new TestDruidCoordinatorConfig(new Duration(1L), new Duration(100L), null, null, new Duration(100L), null, 10, null, false, false, new Duration((Object)"PT0s"));
        this.pathChildrenCache = new PathChildrenCache(this.curator, LOADPATH, true, true, Execs.singleThreaded((String)"coordinator_test_path_children_cache-%d"));
        this.loadQueuePeon = new CuratorLoadQueuePeon(this.curator, LOADPATH, this.objectMapper, Execs.scheduledSingleThreaded((String)"coordinator_test_load_queue_peon_scheduled-%d"), Execs.singleThreaded((String)"coordinator_test_load_queue_peon-%d"), this.druidCoordinatorConfig);
        this.loadQueuePeon.start();
        this.druidNode = new DruidNode("hey", "what", Integer.valueOf(1234), null, true, false);
        this.loadManagementPeons = new ConcurrentHashMap<String, LoadQueuePeon>();
        this.scheduledExecutorFactory = new ScheduledExecutorFactory(){

            public ScheduledExecutorService create(int corePoolSize, String nameFormat) {
                return Executors.newSingleThreadScheduledExecutor();
            }
        };
        this.leaderAnnouncerLatch = new CountDownLatch(1);
        this.leaderUnannouncerLatch = new CountDownLatch(1);
        this.coordinator = new DruidCoordinator(this.druidCoordinatorConfig, new ZkPathsConfig(){

            public String getBase() {
                return "druid";
            }
        }, this.configManager, this.databaseSegmentManager, (ServerInventoryView)this.serverInventoryView, this.metadataRuleManager, this.curator, (ServiceEmitter)new NoopServiceEmitter(), this.scheduledExecutorFactory, null, null, (ServiceAnnouncer)new NoopServiceAnnouncer(){

            public void announce(DruidNode node) {
                DruidCoordinatorTest.this.leaderAnnouncerLatch.countDown();
            }

            public void unannounce(DruidNode node) {
                DruidCoordinatorTest.this.leaderUnannouncerLatch.countDown();
            }
        }, this.druidNode, this.loadManagementPeons, null, (BalancerStrategyFactory)new CostBalancerStrategyFactory(), (LookupCoordinatorManager)EasyMock.createNiceMock(LookupCoordinatorManager.class), (DruidLeaderSelector)new TestDruidLeaderSelector());
    }

    @After
    public void tearDown() throws Exception {
        this.loadQueuePeon.stop();
        this.pathChildrenCache.close();
        this.tearDownServerAndCurator();
    }

    @Test
    public void testMoveSegment() throws Exception {
        this.segment = (DataSegment)EasyMock.createNiceMock(DataSegment.class);
        EasyMock.expect((Object)this.segment.getIdentifier()).andReturn((Object)"dummySegment");
        EasyMock.expect((Object)this.segment.getDataSource()).andReturn((Object)"dummyDataSource");
        EasyMock.replay((Object[])new Object[]{this.segment});
        this.loadQueuePeon = (LoadQueuePeon)EasyMock.createNiceMock(LoadQueuePeon.class);
        EasyMock.expect((Object)this.loadQueuePeon.getLoadQueueSize()).andReturn((Object)new Long(1L));
        this.loadQueuePeon.markSegmentToDrop(this.segment);
        EasyMock.expectLastCall().once();
        Capture loadCallbackCapture = Capture.newInstance();
        Capture dropCallbackCapture = Capture.newInstance();
        this.loadQueuePeon.loadSegment((DataSegment)EasyMock.anyObject(DataSegment.class), (LoadPeonCallback)EasyMock.capture((Capture)loadCallbackCapture));
        EasyMock.expectLastCall().once();
        this.loadQueuePeon.dropSegment((DataSegment)EasyMock.anyObject(DataSegment.class), (LoadPeonCallback)EasyMock.capture((Capture)dropCallbackCapture));
        EasyMock.expectLastCall().once();
        this.loadQueuePeon.unmarkSegmentToDrop(this.segment);
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)this.loadQueuePeon.getSegmentsToDrop()).andReturn(new HashSet()).once();
        EasyMock.replay((Object[])new Object[]{this.loadQueuePeon});
        ImmutableDruidDataSource druidDataSource = (ImmutableDruidDataSource)EasyMock.createNiceMock(ImmutableDruidDataSource.class);
        EasyMock.expect((Object)druidDataSource.getSegment(EasyMock.anyString())).andReturn((Object)this.segment);
        EasyMock.replay((Object[])new Object[]{druidDataSource});
        EasyMock.expect((Object)this.databaseSegmentManager.getInventoryValue(EasyMock.anyString())).andReturn((Object)druidDataSource);
        EasyMock.replay((Object[])new Object[]{this.databaseSegmentManager});
        this.scheduledExecutorFactory = (ScheduledExecutorFactory)EasyMock.createNiceMock(ScheduledExecutorFactory.class);
        EasyMock.replay((Object[])new Object[]{this.scheduledExecutorFactory});
        EasyMock.replay((Object[])new Object[]{this.metadataRuleManager});
        EasyMock.expect((Object)this.druidServer.toImmutableDruidServer()).andReturn((Object)new ImmutableDruidServer(new DruidServerMetadata("from", null, null, 5L, ServerType.HISTORICAL, null, 0), 1L, null, ImmutableMap.of((Object)"dummySegment", (Object)this.segment))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.druidServer});
        this.druidServer2 = (DruidServer)EasyMock.createMock(DruidServer.class);
        EasyMock.expect((Object)this.druidServer2.toImmutableDruidServer()).andReturn((Object)new ImmutableDruidServer(new DruidServerMetadata("to", null, null, 5L, ServerType.HISTORICAL, null, 0), 1L, null, ImmutableMap.of((Object)"dummySegment2", (Object)this.segment))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.druidServer2});
        this.loadManagementPeons.put("from", this.loadQueuePeon);
        this.loadManagementPeons.put("to", this.loadQueuePeon);
        EasyMock.expect((Object)this.serverInventoryView.isSegmentLoadedByServer("to", this.segment)).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{this.serverInventoryView});
        this.coordinator.moveSegment(this.druidServer.toImmutableDruidServer(), this.druidServer2.toImmutableDruidServer(), this.segment, null);
        LoadPeonCallback loadCallback = (LoadPeonCallback)loadCallbackCapture.getValue();
        loadCallback.execute();
        LoadPeonCallback dropCallback = (LoadPeonCallback)dropCallbackCapture.getValue();
        dropCallback.execute();
        EasyMock.verify((Object[])new Object[]{this.druidServer});
        EasyMock.verify((Object[])new Object[]{this.druidServer2});
        EasyMock.verify((Object[])new Object[]{this.loadQueuePeon});
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView});
        EasyMock.verify((Object[])new Object[]{this.metadataRuleManager});
    }

    @Test(timeout=60000L)
    public void testCoordinatorRun() throws Exception {
        String dataSource = "dataSource1";
        String tier = "hot";
        ForeverLoadRule foreverLoadRule = new ForeverLoadRule((Map)ImmutableMap.of((Object)tier, (Object)2));
        EasyMock.expect((Object)this.metadataRuleManager.getRulesWithDefault(EasyMock.anyString())).andReturn((Object)ImmutableList.of((Object)foreverLoadRule)).atLeastOnce();
        this.metadataRuleManager.stop();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.metadataRuleManager});
        DruidDataSource[] druidDataSources = new DruidDataSource[]{new DruidDataSource(dataSource, Collections.emptyMap())};
        final DataSegment dataSegment = new DataSegment(dataSource, Intervals.of((String)"2010-01-01/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L);
        druidDataSources[0].addSegment(dataSegment);
        EasyMock.expect((Object)this.databaseSegmentManager.isStarted()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.databaseSegmentManager.getInventory()).andReturn((Object)ImmutableList.of((Object)druidDataSources[0].toImmutableDruidDataSource())).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseSegmentManager});
        ImmutableDruidDataSource immutableDruidDataSource = (ImmutableDruidDataSource)EasyMock.createNiceMock(ImmutableDruidDataSource.class);
        EasyMock.expect((Object)immutableDruidDataSource.getSegments()).andReturn((Object)ImmutableSet.of((Object)dataSegment)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{immutableDruidDataSource});
        this.druidServer = new DruidServer("server1", "localhost", null, 5L, ServerType.HISTORICAL, tier, 0);
        this.loadManagementPeons.put("server1", this.loadQueuePeon);
        EasyMock.expect((Object)this.serverInventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.druidServer)).atLeastOnce();
        EasyMock.expect((Object)this.serverInventoryView.isStarted()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.serverInventoryView});
        this.coordinator.start();
        this.leaderAnnouncerLatch.await();
        Assert.assertTrue((boolean)this.coordinator.isLeader());
        Assert.assertEquals((Object)this.druidNode.getHostAndPort(), (Object)this.coordinator.getCurrentLeader());
        final CountDownLatch assignSegmentLatch = new CountDownLatch(1);
        this.pathChildrenCache.getListenable().addListener((Object)new PathChildrenCacheListener(){

            public void childEvent(CuratorFramework curatorFramework, PathChildrenCacheEvent pathChildrenCacheEvent) throws Exception {
                if (pathChildrenCacheEvent.getType().equals((Object)PathChildrenCacheEvent.Type.CHILD_ADDED)) {
                    if (assignSegmentLatch.getCount() > 0L) {
                        DruidCoordinatorTest.this.druidServer.addDataSegment(dataSegment);
                        assignSegmentLatch.countDown();
                    } else {
                        Assert.fail((String)"The same segment is assigned to the same server multiple times");
                    }
                }
            }
        });
        this.pathChildrenCache.start();
        assignSegmentLatch.await();
        Assert.assertEquals((Object)ImmutableMap.of((Object)dataSource, (Object)100.0), (Object)this.coordinator.getLoadStatus());
        ((ChildrenDeletable)this.curator.delete().guaranteed()).forPath(ZKPaths.makePath((String)LOADPATH, (String)dataSegment.getIdentifier()));
        while (this.coordinator.getSegmentAvailability().getLong((Object)dataSource) != 0L) {
            Thread.sleep(50L);
        }
        Object2LongMap segmentAvailability = this.coordinator.getSegmentAvailability();
        Assert.assertEquals((long)1L, (long)segmentAvailability.size());
        Assert.assertEquals((Object)0L, segmentAvailability.get(dataSource));
        while (this.coordinator.hasLoadPending(dataSource)) {
            Thread.sleep(50L);
        }
        long startMillis = System.currentTimeMillis();
        long coordinatorRunPeriodMillis = this.druidCoordinatorConfig.getCoordinatorPeriod().getMillis();
        while (System.currentTimeMillis() - startMillis < coordinatorRunPeriodMillis) {
            Thread.sleep(100L);
        }
        Map replicationStatus = this.coordinator.getReplicationStatus();
        Assert.assertNotNull((Object)replicationStatus);
        Assert.assertEquals((long)1L, (long)replicationStatus.entrySet().size());
        Object2LongMap dataSourceMap = (Object2LongMap)replicationStatus.get(tier);
        Assert.assertNotNull((Object)dataSourceMap);
        Assert.assertEquals((long)1L, (long)dataSourceMap.size());
        Assert.assertNotNull((Object)dataSourceMap.get((Object)dataSource));
        Assert.assertEquals((long)1L, (long)dataSourceMap.getLong((Object)dataSource));
        this.coordinator.stop();
        this.leaderUnannouncerLatch.await();
        Assert.assertFalse((boolean)this.coordinator.isLeader());
        Assert.assertNull((Object)this.coordinator.getCurrentLeader());
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView});
        EasyMock.verify((Object[])new Object[]{this.metadataRuleManager});
    }

    @Test
    public void testOrderedAvailableDataSegments() {
        DataSegment[] segments;
        DruidDataSource dataSource = new DruidDataSource("test", new HashMap());
        for (DataSegment segment : segments = new DataSegment[]{this.getSegment("test", Intervals.of((String)"2016-01-10T03:00:00Z/2016-01-10T04:00:00Z")), this.getSegment("test", Intervals.of((String)"2016-01-11T01:00:00Z/2016-01-11T02:00:00Z")), this.getSegment("test", Intervals.of((String)"2016-01-09T10:00:00Z/2016-01-09T11:00:00Z")), this.getSegment("test", Intervals.of((String)"2016-01-09T10:00:00Z/2016-01-09T12:00:00Z"))}) {
            dataSource.addSegment(segment);
        }
        EasyMock.expect((Object)this.databaseSegmentManager.getInventory()).andReturn((Object)ImmutableList.of((Object)dataSource.toImmutableDruidDataSource())).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseSegmentManager});
        Set availableSegments = this.coordinator.getOrderedAvailableDataSegments();
        Object[] expected = new DataSegment[]{this.getSegment("test", Intervals.of((String)"2016-01-11T01:00:00Z/2016-01-11T02:00:00Z")), this.getSegment("test", Intervals.of((String)"2016-01-10T03:00:00Z/2016-01-10T04:00:00Z")), this.getSegment("test", Intervals.of((String)"2016-01-09T10:00:00Z/2016-01-09T12:00:00Z")), this.getSegment("test", Intervals.of((String)"2016-01-09T10:00:00Z/2016-01-09T11:00:00Z"))};
        Assert.assertEquals((long)expected.length, (long)availableSegments.size());
        Assert.assertEquals((Object[])expected, (Object[])availableSegments.toArray());
        EasyMock.verify((Object[])new Object[]{this.databaseSegmentManager});
    }

    private DataSegment getSegment(String dataSource, Interval interval) {
        DataSegment segment = new DataSegment(dataSource, interval, "dummy_version", new ConcurrentHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), null, Integer.valueOf(0), 0L);
        return segment;
    }

    private static class TestDruidLeaderSelector
    implements DruidLeaderSelector {
        private volatile DruidLeaderSelector.Listener listener;
        private volatile String leader;

        private TestDruidLeaderSelector() {
        }

        public String getCurrentLeader() {
            return this.leader;
        }

        public boolean isLeader() {
            return this.leader != null;
        }

        public int localTerm() {
            return 0;
        }

        public void registerListener(DruidLeaderSelector.Listener listener) {
            this.listener = listener;
            this.leader = "what:1234";
            listener.becomeLeader();
        }

        public void unregisterListener() {
            this.leader = null;
            this.listener.stopBeingLeader();
        }
    }
}

