/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import java.util.HashMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.server.coordinator.CoordinatorStats;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoordinatorStatsTest {
    private CoordinatorStats stats;

    @Before
    public void setUp() throws Exception {
        this.stats = new CoordinatorStats();
    }

    @After
    public void tearDown() throws Exception {
        this.stats = null;
    }

    @Test
    public void addToGlobalStat() throws Exception {
        Assert.assertEquals((long)0L, (long)this.stats.getGlobalStat("stats"));
        this.stats.addToGlobalStat("stats", 1L);
        Assert.assertEquals((long)1L, (long)this.stats.getGlobalStat("stats"));
        this.stats.addToGlobalStat("stats", -11L);
        Assert.assertEquals((long)-10L, (long)this.stats.getGlobalStat("stats"));
    }

    @Test(expected=NullPointerException.class)
    public void testAddToTieredStatNonexistentStat() throws Exception {
        this.stats.getTieredStat("stat", "tier");
    }

    @Test
    public void testAddToTieredStat() throws Exception {
        Assert.assertFalse((boolean)this.stats.hasPerTierStats());
        this.stats.addToTieredStat("stat1", "tier1", 1L);
        this.stats.addToTieredStat("stat1", "tier2", 1L);
        this.stats.addToTieredStat("stat1", "tier1", -5L);
        this.stats.addToTieredStat("stat2", "tier1", 1L);
        this.stats.addToTieredStat("stat1", "tier2", 1L);
        Assert.assertTrue((boolean)this.stats.hasPerTierStats());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"tier1", "tier2"}), (Object)this.stats.getTiers("stat1"));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"tier1"}), (Object)this.stats.getTiers("stat2"));
        Assert.assertTrue((boolean)this.stats.getTiers("stat3").isEmpty());
        Assert.assertEquals((long)-4L, (long)this.stats.getTieredStat("stat1", "tier1"));
        Assert.assertEquals((long)2L, (long)this.stats.getTieredStat("stat1", "tier2"));
        Assert.assertEquals((long)1L, (long)this.stats.getTieredStat("stat2", "tier1"));
    }

    @Test
    public void testForEachTieredStat() throws Exception {
        ImmutableMap expected = ImmutableMap.of((Object)"tier1", (Object)1L, (Object)"tier2", (Object)2L, (Object)"tier3", (Object)3L);
        HashMap actual = Maps.newHashMap();
        expected.forEach((tier, count) -> this.stats.addToTieredStat("stat", tier, count.longValue()));
        this.stats.forEachTieredStat("stat0", (tier, count) -> Assert.fail());
        this.stats.forEachTieredStat("stat", actual::put);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAccumulate() throws Exception {
        this.stats.addToGlobalStat("stat1", 1L);
        this.stats.addToGlobalStat("stat2", 1L);
        this.stats.addToTieredStat("stat1", "tier1", 1L);
        this.stats.addToTieredStat("stat1", "tier2", 1L);
        this.stats.addToTieredStat("stat2", "tier1", 1L);
        CoordinatorStats stats2 = new CoordinatorStats();
        stats2.addToGlobalStat("stat1", 1L);
        stats2.addToTieredStat("stat1", "tier2", 1L);
        stats2.addToTieredStat("stat2", "tier2", 1L);
        stats2.addToTieredStat("stat3", "tier1", 1L);
        this.stats.accumulate(stats2);
        Assert.assertEquals((long)2L, (long)this.stats.getGlobalStat("stat1"));
        Assert.assertEquals((long)1L, (long)this.stats.getGlobalStat("stat2"));
        Assert.assertEquals((long)1L, (long)this.stats.getTieredStat("stat1", "tier1"));
        Assert.assertEquals((long)2L, (long)this.stats.getTieredStat("stat1", "tier2"));
        Assert.assertEquals((long)1L, (long)this.stats.getTieredStat("stat2", "tier1"));
        Assert.assertEquals((long)1L, (long)this.stats.getTieredStat("stat2", "tier2"));
        Assert.assertEquals((long)1L, (long)this.stats.getTieredStat("stat3", "tier1"));
    }
}

