/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordination;

import java.util.Arrays;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.jackson.JacksonUtils;
import org.apache.hive.druid.io.druid.server.coordination.SegmentChangeRequestLoad;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class SegmentChangeRequestLoadTest {
    @Test
    public void testV1Serialization() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Interval interval = Intervals.of((String)"2011-10-01/2011-10-02");
        ImmutableMap loadSpec = ImmutableMap.of((Object)"something", (Object)"or_other");
        DataSegment segment = new DataSegment("something", interval, "1", (Map)loadSpec, Arrays.asList("dim1", "dim2"), Arrays.asList("met1", "met2"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 1L);
        SegmentChangeRequestLoad segmentDrop = new SegmentChangeRequestLoad(segment);
        Map objectMap = (Map)mapper.readValue(mapper.writeValueAsString((Object)segmentDrop), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        Assert.assertEquals((long)11L, (long)objectMap.size());
        Assert.assertEquals((Object)"load", objectMap.get("action"));
        Assert.assertEquals((Object)"something", objectMap.get("dataSource"));
        Assert.assertEquals((Object)interval.toString(), objectMap.get("interval"));
        Assert.assertEquals((Object)"1", objectMap.get("version"));
        Assert.assertEquals((Object)loadSpec, objectMap.get("loadSpec"));
        Assert.assertEquals((Object)"dim1,dim2", objectMap.get("dimensions"));
        Assert.assertEquals((Object)"met1,met2", objectMap.get("metrics"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"type", (Object)"none"), objectMap.get("shardSpec"));
        Assert.assertEquals((Object)9, objectMap.get("binaryVersion"));
        Assert.assertEquals((Object)1, objectMap.get("size"));
    }
}

