/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.appenderator;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.client.cache.Cache;
import org.apache.hive.druid.io.druid.client.cache.CacheConfig;
import org.apache.hive.druid.io.druid.client.cache.MapCache;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.JSONParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.MapInputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.java.util.emitter.core.Emitter;
import org.apache.hive.druid.io.druid.java.util.emitter.core.NoopEmitter;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.query.DefaultQueryRunnerFactoryConglomerate;
import org.apache.hive.druid.io.druid.query.IntervalChunkingQueryRunnerDecorator;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.IndexMerger;
import org.apache.hive.druid.io.druid.segment.IndexMergerV9;
import org.apache.hive.druid.io.druid.segment.column.ColumnConfig;
import org.apache.hive.druid.io.druid.segment.indexing.DataSchema;
import org.apache.hive.druid.io.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.hive.druid.io.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.hive.druid.io.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.hive.druid.io.druid.segment.loading.DataSegmentPusher;
import org.apache.hive.druid.io.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.Appenderator;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.Appenderators;
import org.apache.hive.druid.io.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.LinearShardSpec;

public class AppenderatorTester
implements AutoCloseable {
    public static final String DATASOURCE = "foo";
    private final DataSchema schema;
    private final RealtimeTuningConfig tuningConfig;
    private final FireDepartmentMetrics metrics;
    private final DataSegmentPusher dataSegmentPusher;
    private final ObjectMapper objectMapper;
    private final Appenderator appenderator;
    private final ExecutorService queryExecutor;
    private final IndexIO indexIO;
    private final IndexMerger indexMerger;
    private final ServiceEmitter emitter;
    private final List<DataSegment> pushedSegments = new CopyOnWriteArrayList<DataSegment>();

    public AppenderatorTester(int maxRowsInMemory) {
        this(maxRowsInMemory, null, false);
    }

    public AppenderatorTester(int maxRowsInMemory, boolean enablePushFailure) {
        this(maxRowsInMemory, null, enablePushFailure);
    }

    public AppenderatorTester(int maxRowsInMemory, File basePersistDirectory, final boolean enablePushFailure) {
        this.objectMapper = new DefaultObjectMapper();
        this.objectMapper.registerSubtypes(new Class[]{LinearShardSpec.class});
        Map parserMap = (Map)this.objectMapper.convertValue((Object)new MapInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("ts", "auto", null), new DimensionsSpec(null, null, null), null, null)), Map.class);
        this.schema = new DataSchema(DATASOURCE, parserMap, new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("met", "met")}, (GranularitySpec)new UniformGranularitySpec(Granularities.MINUTE, Granularities.NONE, null), null, this.objectMapper);
        this.tuningConfig = new RealtimeTuningConfig(Integer.valueOf(maxRowsInMemory), null, null, basePersistDirectory, null, null, null, null, null, null, 0, 0, null, null, null, null);
        this.metrics = new FireDepartmentMetrics();
        this.queryExecutor = Execs.singleThreaded((String)"queryExecutor(%d)");
        this.indexIO = new IndexIO(this.objectMapper, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), new ColumnConfig(){

            public int columnCacheSizeBytes() {
                return 0;
            }
        });
        this.indexMerger = new IndexMergerV9(this.objectMapper, this.indexIO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        this.emitter = new ServiceEmitter("test", "test", (Emitter)new NoopEmitter());
        this.emitter.start();
        EmittingLogger.registerEmitter((ServiceEmitter)this.emitter);
        this.dataSegmentPusher = new DataSegmentPusher(){
            private boolean mustFail = true;

            @Deprecated
            public String getPathForHadoop(String dataSource) {
                return this.getPathForHadoop();
            }

            public String getPathForHadoop() {
                throw new UnsupportedOperationException();
            }

            public DataSegment push(File file, DataSegment segment, boolean replaceExisting) throws IOException {
                if (enablePushFailure && this.mustFail) {
                    this.mustFail = false;
                    throw new IOException("Push failure test");
                }
                if (enablePushFailure) {
                    this.mustFail = true;
                }
                AppenderatorTester.this.pushedSegments.add(segment);
                return segment;
            }

            public Map<String, Object> makeLoadSpec(URI uri) {
                throw new UnsupportedOperationException();
            }
        };
        this.appenderator = Appenderators.createRealtime((DataSchema)this.schema, (AppenderatorConfig)this.tuningConfig, (FireDepartmentMetrics)this.metrics, (DataSegmentPusher)this.dataSegmentPusher, (ObjectMapper)this.objectMapper, (IndexIO)this.indexIO, (IndexMerger)this.indexMerger, (QueryRunnerFactoryConglomerate)new DefaultQueryRunnerFactoryConglomerate((Map)ImmutableMap.of(TimeseriesQuery.class, (Object)new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(new IntervalChunkingQueryRunnerDecorator(this.queryExecutor, QueryRunnerTestHelper.NOOP_QUERYWATCHER, this.emitter)), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER))), (DataSegmentAnnouncer)new DataSegmentAnnouncer(){

            public void announceSegment(DataSegment segment) throws IOException {
            }

            public void unannounceSegment(DataSegment segment) throws IOException {
            }

            public void announceSegments(Iterable<DataSegment> segments) throws IOException {
            }

            public void unannounceSegments(Iterable<DataSegment> segments) throws IOException {
            }
        }, (ServiceEmitter)this.emitter, (ExecutorService)this.queryExecutor, (Cache)MapCache.create((long)2048L), (CacheConfig)new CacheConfig());
    }

    public DataSchema getSchema() {
        return this.schema;
    }

    public RealtimeTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    public FireDepartmentMetrics getMetrics() {
        return this.metrics;
    }

    public DataSegmentPusher getDataSegmentPusher() {
        return this.dataSegmentPusher;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public Appenderator getAppenderator() {
        return this.appenderator;
    }

    public List<DataSegment> getPushedSegments() {
        return this.pushedSegments;
    }

    @Override
    public void close() throws Exception {
        this.appenderator.close();
        this.queryExecutor.shutdownNow();
        this.emitter.close();
        FileUtils.deleteDirectory((File)this.tuningConfig.getBasePersistDirectory());
    }
}

