/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.filter;

import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.MapInputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.MapLookupExtractor;
import org.apache.hive.druid.io.druid.query.extraction.TimeDimExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.ExtractionDimFilter;
import org.apache.hive.druid.io.druid.query.filter.InDimFilter;
import org.apache.hive.druid.io.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractionFn;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.io.druid.segment.IndexBuilder;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.apache.hive.druid.io.druid.segment.filter.BaseFilterTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SelectorFilterTest
extends BaseFilterTest {
    private static final String TIMESTAMP_COLUMN = "timestamp";
    private static final InputRowParser<Map<String, Object>> PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("timestamp", "iso", DateTimes.of((String)"2000")), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dim0", (Object)"dim1", (Object)"dim2", (Object)"dim3", (Object)"dim6")), null, null)));
    private static final List<InputRow> ROWS = ImmutableList.of(PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"0", (Object)"dim1", (Object)"", (Object)"dim2", (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)"dim6", (Object)"2017-07-25")).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"1", (Object)"dim1", (Object)"10", (Object)"dim2", (Object)ImmutableList.of(), (Object)"dim6", (Object)"2017-07-25")).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"2", (Object)"dim1", (Object)"2", (Object)"dim2", (Object)ImmutableList.of((Object)""), (Object)"dim6", (Object)"2017-05-25")).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"3", (Object)"dim1", (Object)"1", (Object)"dim2", (Object)ImmutableList.of((Object)"a"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"4", (Object)"dim1", (Object)"def", (Object)"dim2", (Object)ImmutableList.of((Object)"c"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"5", (Object)"dim1", (Object)"abc")).get(0));

    public SelectorFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, indexBuilder, finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(SelectorFilterTest.class.getName());
    }

    @Test
    public void testWithTimeExtractionFnNull() {
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim0", null, (ExtractionFn)new TimeDimExtractionFn("yyyy-mm-dd", "yyyy-mm")), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim6", null, (ExtractionFn)new TimeDimExtractionFn("yyyy-mm-dd", "yyyy-mm")), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim6", "2017-07", (ExtractionFn)new TimeDimExtractionFn("yyyy-mm-dd", "yyyy-mm")), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim6", "2017-05", (ExtractionFn)new TimeDimExtractionFn("yyyy-mm-dd", "yyyy-mm")), (List<String>)ImmutableList.of((Object)"2"));
    }

    @Test
    public void testSingleValueStringColumnWithoutNulls() {
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim0", null, null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim0", "", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim0", "0", null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim0", "1", null), (List<String>)ImmutableList.of((Object)"1"));
    }

    @Test
    public void testSingleValueStringColumnWithNulls() {
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", null, null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "", null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "10", null), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "2", null), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "1", null), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "def", null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "abc", null), (List<String>)ImmutableList.of((Object)"5"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "ab", null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMultiValueStringColumn() {
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim2", null, null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim2", "", null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim2", "a", null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim2", "b", null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim2", "c", null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim2", "d", null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMissingColumnSpecifiedInDimensionList() {
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim3", null, null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim3", "", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim3", "a", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim3", "b", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim3", "c", null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMissingColumnNotSpecifiedInDimensionList() {
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim4", null, null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim4", "", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim4", "a", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim4", "b", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim4", "c", null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testExpressionVirtualColumn() {
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("expr", "1.1", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("expr", "1.2", null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testSelectorWithLookupExtractionFn() {
        ImmutableMap stringMap = ImmutableMap.of((Object)"1", (Object)"HELLO", (Object)"a", (Object)"HELLO", (Object)"def", (Object)"HELLO", (Object)"abc", (Object)"UNKNOWN");
        MapLookupExtractor mapExtractor = new MapLookupExtractor((Map)stringMap, false);
        LookupExtractionFn lookupFn = new LookupExtractionFn((LookupExtractor)mapExtractor, false, "UNKNOWN", false, Boolean.valueOf(true));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim0", "HELLO", (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim0", "UNKNOWN", (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "HELLO", (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"3", (Object)"4"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "UNKNOWN", (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim2", "HELLO", (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim2", "UNKNOWN", (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim3", "HELLO", (ExtractionFn)lookupFn), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim3", "UNKNOWN", (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim4", "HELLO", (ExtractionFn)lookupFn), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim4", "UNKNOWN", (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        ImmutableMap stringMap2 = ImmutableMap.of((Object)"2", (Object)"5");
        MapLookupExtractor mapExtractor2 = new MapLookupExtractor((Map)stringMap2, false);
        LookupExtractionFn lookupFn2 = new LookupExtractionFn((LookupExtractor)mapExtractor2, true, null, false, Boolean.valueOf(true));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim0", "5", (ExtractionFn)lookupFn2), (List<String>)ImmutableList.of((Object)"2", (Object)"5"));
        ImmutableMap stringMap3 = ImmutableMap.of((Object)"1", (Object)"");
        MapLookupExtractor mapExtractor3 = new MapLookupExtractor((Map)stringMap3, false);
        LookupExtractionFn lookupFn3 = new LookupExtractionFn((LookupExtractor)mapExtractor3, false, null, false, Boolean.valueOf(true));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim0", null, (ExtractionFn)lookupFn3), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        ImmutableMap stringMap4 = ImmutableMap.of((Object)"9", (Object)"4");
        MapLookupExtractor mapExtractor4 = new MapLookupExtractor((Map)stringMap4, false);
        LookupExtractionFn lookupFn4 = new LookupExtractionFn((LookupExtractor)mapExtractor4, true, null, false, Boolean.valueOf(true));
        ImmutableMap stringMap5 = ImmutableMap.of((Object)"5", (Object)"44");
        MapLookupExtractor mapExtractor5 = new MapLookupExtractor((Map)stringMap5, false);
        LookupExtractionFn lookupFn5 = new LookupExtractionFn((LookupExtractor)mapExtractor5, true, null, false, Boolean.valueOf(true));
        ImmutableMap stringMap6 = ImmutableMap.of((Object)"5", (Object)"5");
        MapLookupExtractor mapExtractor6 = new MapLookupExtractor((Map)stringMap6, false);
        LookupExtractionFn lookupFn6 = new LookupExtractionFn((LookupExtractor)mapExtractor6, true, null, false, Boolean.valueOf(true));
        SelectorDimFilter optFilter1 = new SelectorDimFilter("dim1", "UNKNOWN", (ExtractionFn)lookupFn);
        SelectorDimFilter optFilter2 = new SelectorDimFilter("dim0", "5", (ExtractionFn)lookupFn2);
        SelectorDimFilter optFilter3 = new SelectorDimFilter("dim0", null, (ExtractionFn)lookupFn3);
        SelectorDimFilter optFilter4 = new SelectorDimFilter("dim0", "5", (ExtractionFn)lookupFn4);
        SelectorDimFilter optFilter5 = new SelectorDimFilter("dim0", "5", (ExtractionFn)lookupFn5);
        SelectorDimFilter optFilter6 = new SelectorDimFilter("dim0", "5", (ExtractionFn)lookupFn6);
        InDimFilter optFilter2Optimized = new InDimFilter("dim0", Arrays.asList("2", "5"), null);
        SelectorDimFilter optFilter4Optimized = new SelectorDimFilter("dim0", "5", null);
        SelectorDimFilter optFilter6Optimized = new SelectorDimFilter("dim0", "5", null);
        Assert.assertTrue((boolean)optFilter1.equals((Object)optFilter1.optimize()));
        Assert.assertTrue((boolean)optFilter2Optimized.equals((Object)optFilter2.optimize()));
        Assert.assertTrue((boolean)optFilter3.equals((Object)optFilter3.optimize()));
        Assert.assertTrue((boolean)optFilter4Optimized.equals((Object)optFilter4.optimize()));
        Assert.assertTrue((boolean)optFilter5.equals((Object)optFilter5.optimize()));
        Assert.assertTrue((boolean)optFilter6Optimized.equals((Object)optFilter6.optimize()));
        this.assertFilterMatches((DimFilter)optFilter1, (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"5"));
        this.assertFilterMatches((DimFilter)optFilter2, (List<String>)ImmutableList.of((Object)"2", (Object)"5"));
        this.assertFilterMatches((DimFilter)optFilter3, (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)optFilter4, (List<String>)ImmutableList.of((Object)"5"));
        this.assertFilterMatches((DimFilter)optFilter5, (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)optFilter6, (List<String>)ImmutableList.of((Object)"5"));
        this.assertFilterMatches((DimFilter)new ExtractionDimFilter("dim1", "UNKNOWN", (ExtractionFn)lookupFn, null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"5"));
        this.assertFilterMatches((DimFilter)new ExtractionDimFilter("dim0", "5", (ExtractionFn)lookupFn2, null), (List<String>)ImmutableList.of((Object)"2", (Object)"5"));
        this.assertFilterMatches((DimFilter)new ExtractionDimFilter("dim0", null, (ExtractionFn)lookupFn3, null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
    }
}

