/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.io.druid.java.util.common.io.Closer;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.Smoosh;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.hive.druid.io.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.hive.druid.io.druid.segment.data.ColumnarMultiInts;
import org.apache.hive.druid.io.druid.segment.data.CompressedColumnarIntsSerializer;
import org.apache.hive.druid.io.druid.segment.data.CompressedVSizeColumnarIntsSerializer;
import org.apache.hive.druid.io.druid.segment.data.CompressedVSizeColumnarIntsSupplier;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexedWriter;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.V3CompressedVSizeColumnarMultiIntsSerializer;
import org.apache.hive.druid.io.druid.segment.data.V3CompressedVSizeColumnarMultiIntsSupplier;
import org.apache.hive.druid.io.druid.segment.writeout.OffHeapMemorySegmentWriteOutMedium;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.hive.druid.io.druid.segment.writeout.WriteOutBytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class V3CompressedVSizeColumnarMultiIntsSerializerTest {
    private static final int[] OFFSET_CHUNK_FACTORS = new int[]{1, 2, 100, 16384};
    private static final int[] MAX_VALUES = new int[]{255, 65535, 0xFFFFFF, 0xFFFFFFF};
    private final CompressionStrategy compressionStrategy;
    private final ByteOrder byteOrder;
    private final Random rand = new Random(0L);
    private List<int[]> vals;

    public V3CompressedVSizeColumnarMultiIntsSerializerTest(CompressionStrategy compressionStrategy, ByteOrder byteOrder) {
        this.compressionStrategy = compressionStrategy;
        this.byteOrder = byteOrder;
    }

    @Parameterized.Parameters(name="{index}: compression={0}, byteOrder={1}")
    public static Iterable<Object[]> compressionStrategiesAndByteOrders() {
        Set combinations = Sets.cartesianProduct((Set[])new Set[]{Sets.newHashSet((Object[])CompressionStrategy.noNoneValues()), Sets.newHashSet((Object[])new ByteOrder[]{ByteOrder.BIG_ENDIAN, ByteOrder.LITTLE_ENDIAN})});
        return Iterables.transform((Iterable)combinations, (Function)new Function<List, Object[]>(){

            public Object[] apply(List input) {
                return new Object[]{input.get(0), input.get(1)};
            }
        });
    }

    private void generateVals(int totalSize, int maxValue) throws IOException {
        this.vals = new ArrayList<int[]>(totalSize);
        for (int i = 0; i < totalSize; ++i) {
            int len = this.rand.nextInt(2) + 1;
            int[] subVals = new int[len];
            for (int j = 0; j < len; ++j) {
                subVals[j] = this.rand.nextInt(maxValue);
            }
            this.vals.add(subVals);
        }
    }

    private void checkSerializedSizeAndData(int offsetChunkFactor, int valueChunkFactor) throws Exception {
        FileSmoosher smoosher = new FileSmoosher(FileUtils.getTempDirectory());
        try (OffHeapMemorySegmentWriteOutMedium segmentWriteOutMedium = new OffHeapMemorySegmentWriteOutMedium();){
            int maxValue = this.vals.size() > 0 ? this.getMaxValue(this.vals) : 0;
            CompressedColumnarIntsSerializer offsetWriter = new CompressedColumnarIntsSerializer((SegmentWriteOutMedium)segmentWriteOutMedium, "offset", offsetChunkFactor, this.byteOrder, this.compressionStrategy);
            CompressedVSizeColumnarIntsSerializer valueWriter = new CompressedVSizeColumnarIntsSerializer((SegmentWriteOutMedium)segmentWriteOutMedium, "value", maxValue, valueChunkFactor, this.byteOrder, this.compressionStrategy);
            V3CompressedVSizeColumnarMultiIntsSerializer writer = new V3CompressedVSizeColumnarMultiIntsSerializer(offsetWriter, valueWriter);
            V3CompressedVSizeColumnarMultiIntsSupplier supplierFromIterable = V3CompressedVSizeColumnarMultiIntsSupplier.fromIterable((Iterable)Iterables.transform(this.vals, ArrayBasedIndexedInts::of), (int)offsetChunkFactor, (int)maxValue, (ByteOrder)this.byteOrder, (CompressionStrategy)this.compressionStrategy, (Closer)segmentWriteOutMedium.getCloser());
            writer.open();
            for (int[] val : this.vals) {
                writer.add((Object)val);
            }
            long writtenLength = writer.getSerializedSize();
            WriteOutBytes writeOutBytes = segmentWriteOutMedium.makeWriteOutBytes();
            writer.writeTo((WritableByteChannel)writeOutBytes, smoosher);
            smoosher.close();
            Assert.assertEquals((long)writtenLength, (long)supplierFromIterable.getSerializedSize());
            V3CompressedVSizeColumnarMultiIntsSupplier supplierFromByteBuffer = V3CompressedVSizeColumnarMultiIntsSupplier.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(IOUtils.toByteArray((InputStream)writeOutBytes.asInputStream())), (ByteOrder)this.byteOrder);
            try (ColumnarMultiInts columnarMultiInts = supplierFromByteBuffer.get();){
                Assert.assertEquals((long)columnarMultiInts.size(), (long)this.vals.size());
                for (int i = 0; i < this.vals.size(); ++i) {
                    IndexedInts subVals = columnarMultiInts.get(i);
                    Assert.assertEquals((long)subVals.size(), (long)this.vals.get(i).length);
                    for (int j = 0; j < subVals.size(); ++j) {
                        Assert.assertEquals((long)subVals.get(j), (long)this.vals.get(i)[j]);
                    }
                }
            }
        }
    }

    int getMaxValue(List<int[]> vals) {
        return (Integer)Ordering.natural().max(Iterables.transform(vals, (Function)new Function<int[], Integer>(){

            @Nullable
            public Integer apply(int[] input) {
                return input.length > 0 ? Ints.max((int[])input) : 0;
            }
        }));
    }

    @Before
    public void setUp() throws Exception {
        this.vals = null;
    }

    @Test
    public void testSmallData() throws Exception {
        for (int offsetChunk : OFFSET_CHUNK_FACTORS) {
            for (int maxValue : MAX_VALUES) {
                int valueChunk = CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue((int)maxValue);
                this.generateVals(this.rand.nextInt(valueChunk), maxValue);
                this.checkSerializedSizeAndData(offsetChunk, valueChunk);
            }
        }
    }

    @Test
    public void testLargeData() throws Exception {
        for (int offsetChunk : OFFSET_CHUNK_FACTORS) {
            for (int maxValue : MAX_VALUES) {
                int valueChunk = CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue((int)maxValue);
                this.generateVals((this.rand.nextInt(2) + 1) * valueChunk + this.rand.nextInt(valueChunk), maxValue);
                this.checkSerializedSizeAndData(offsetChunk, valueChunk);
            }
        }
    }

    @Test
    public void testEmpty() throws Exception {
        this.vals = new ArrayList<int[]>();
        this.checkSerializedSizeAndData(1, 2);
    }

    private void checkV2SerializedSizeAndData(int offsetChunkFactor, int valueChunkFactor) throws Exception {
        File tmpDirectory = Files.createTempDirectory(StringUtils.format((String)"CompressedVSizeIndexedV3WriterTest_%d_%d", (Object[])new Object[]{offsetChunkFactor, offsetChunkFactor}), new FileAttribute[0]).toFile();
        FileSmoosher smoosher = new FileSmoosher(tmpDirectory);
        int maxValue = this.vals.size() > 0 ? this.getMaxValue(this.vals) : 0;
        try (OffHeapMemorySegmentWriteOutMedium segmentWriteOutMedium = new OffHeapMemorySegmentWriteOutMedium();){
            CompressedColumnarIntsSerializer offsetWriter = new CompressedColumnarIntsSerializer((SegmentWriteOutMedium)segmentWriteOutMedium, offsetChunkFactor, this.byteOrder, this.compressionStrategy, GenericIndexedWriter.ofCompressedByteBuffers((SegmentWriteOutMedium)segmentWriteOutMedium, (String)"offset", (CompressionStrategy)this.compressionStrategy, (int)2000000));
            GenericIndexedWriter genericIndexed = GenericIndexedWriter.ofCompressedByteBuffers((SegmentWriteOutMedium)segmentWriteOutMedium, (String)"value", (CompressionStrategy)this.compressionStrategy, (int)2000000);
            CompressedVSizeColumnarIntsSerializer valueWriter = new CompressedVSizeColumnarIntsSerializer((SegmentWriteOutMedium)segmentWriteOutMedium, maxValue, valueChunkFactor, this.byteOrder, this.compressionStrategy, genericIndexed);
            V3CompressedVSizeColumnarMultiIntsSerializer writer = new V3CompressedVSizeColumnarMultiIntsSerializer(offsetWriter, valueWriter);
            writer.open();
            for (int[] val : this.vals) {
                writer.add((Object)val);
            }
            SmooshedWriter channel = smoosher.addWithSmooshedWriter("test", writer.getSerializedSize());
            writer.writeTo((WritableByteChannel)channel, smoosher);
            channel.close();
            smoosher.close();
            SmooshedFileMapper mapper = Smoosh.map((File)tmpDirectory);
            V3CompressedVSizeColumnarMultiIntsSupplier supplierFromByteBuffer = V3CompressedVSizeColumnarMultiIntsSupplier.fromByteBuffer((ByteBuffer)mapper.mapFile("test"), (ByteOrder)this.byteOrder);
            ColumnarMultiInts columnarMultiInts = supplierFromByteBuffer.get();
            Assert.assertEquals((long)columnarMultiInts.size(), (long)this.vals.size());
            for (int i = 0; i < this.vals.size(); ++i) {
                IndexedInts subVals = columnarMultiInts.get(i);
                Assert.assertEquals((long)subVals.size(), (long)this.vals.get(i).length);
                for (int j = 0; j < subVals.size(); ++j) {
                    Assert.assertEquals((long)subVals.get(j), (long)this.vals.get(i)[j]);
                }
            }
            CloseQuietly.close((Closeable)columnarMultiInts);
            mapper.close();
        }
    }

    @Test
    public void testMultiValueFileLargeData() throws Exception {
        for (int offsetChunk : OFFSET_CHUNK_FACTORS) {
            for (int maxValue : MAX_VALUES) {
                int valueChunk = CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue((int)maxValue);
                this.generateVals((this.rand.nextInt(2) + 1) * valueChunk + this.rand.nextInt(valueChunk), maxValue);
                this.checkV2SerializedSizeAndData(offsetChunk, valueChunk);
            }
        }
    }
}

