/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerde;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.RoaringBitmapSerdeFactory;
import org.junit.Assert;
import org.junit.Test;

public class BitmapSerdeFactoryTest {
    @Test
    public void testSerialization() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Assert.assertEquals((Object)"{\"type\":\"roaring\",\"compressRunOnSerialization\":true}", (Object)mapper.writeValueAsString((Object)new RoaringBitmapSerdeFactory(null)));
        Assert.assertEquals((Object)"{\"type\":\"roaring\",\"compressRunOnSerialization\":false}", (Object)mapper.writeValueAsString((Object)new RoaringBitmapSerdeFactory(Boolean.valueOf(false))));
        Assert.assertEquals((Object)"{\"type\":\"roaring\",\"compressRunOnSerialization\":true}", (Object)mapper.writeValueAsString((Object)new RoaringBitmapSerdeFactory(Boolean.valueOf(true))));
        Assert.assertEquals((Object)"{\"type\":\"concise\"}", (Object)mapper.writeValueAsString((Object)new ConciseBitmapSerdeFactory()));
        Assert.assertEquals((Object)"{\"type\":\"concise\"}", (Object)mapper.writeValueAsString((Object)BitmapSerde.createLegacyFactory()));
        Assert.assertEquals((Object)"{\"type\":\"concise\"}", (Object)mapper.writeValueAsString((Object)new BitmapSerde.DefaultBitmapSerdeFactory()));
        Assert.assertEquals((Object)"{\"type\":\"concise\"}", (Object)mapper.writeValueAsString((Object)new BitmapSerde.LegacyBitmapSerdeFactory()));
    }

    @Test
    public void testDeserialization() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        BitmapSerdeFactory roaringFactory = (BitmapSerdeFactory)mapper.readValue("{\"type\":\"roaring\"}", BitmapSerdeFactory.class);
        Assert.assertTrue((boolean)(roaringFactory instanceof RoaringBitmapSerdeFactory));
        Assert.assertTrue((boolean)((RoaringBitmapSerdeFactory)roaringFactory).getCompressRunOnSerialization());
        BitmapSerdeFactory compressingRoaringFactory = (BitmapSerdeFactory)mapper.readValue("{\"type\":\"roaring\", \"compressRunOnSerialization\":false}", BitmapSerdeFactory.class);
        Assert.assertTrue((boolean)(compressingRoaringFactory instanceof RoaringBitmapSerdeFactory));
        Assert.assertFalse((boolean)((RoaringBitmapSerdeFactory)compressingRoaringFactory).getCompressRunOnSerialization());
        Assert.assertTrue((boolean)(mapper.readValue("{\"type\":\"concise\"}", BitmapSerdeFactory.class) instanceof ConciseBitmapSerdeFactory));
        Assert.assertTrue((boolean)(mapper.readValue("{\"type\":\"BitmapSerde$SomeRandomClass\"}", BitmapSerdeFactory.class) instanceof ConciseBitmapSerdeFactory));
    }
}

