/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.StringFormatExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.DimensionSelectorUtils;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.junit.Assert;
import org.junit.Test;

public class ConstantDimensionSelectorTest {
    private final DimensionSelector NULL_SELECTOR = DimensionSelectorUtils.constantSelector(null);
    private final DimensionSelector CONST_SELECTOR = DimensionSelectorUtils.constantSelector((String)"billy");
    private final DimensionSelector NULL_EXTRACTION_SELECTOR = DimensionSelectorUtils.constantSelector(null, (ExtractionFn)new StringFormatExtractionFn("billy"));
    private final DimensionSelector CONST_EXTRACTION_SELECTOR = DimensionSelectorUtils.constantSelector((String)"billybilly", (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(5)));

    @Test
    public void testGetRow() throws Exception {
        IndexedInts row = this.NULL_SELECTOR.getRow();
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertEquals((long)0L, (long)row.get(0));
    }

    @Test
    public void testGetValueCardinality() throws Exception {
        Assert.assertEquals((long)1L, (long)this.NULL_SELECTOR.getValueCardinality());
        Assert.assertEquals((long)1L, (long)this.CONST_SELECTOR.getValueCardinality());
        Assert.assertEquals((long)1L, (long)this.NULL_EXTRACTION_SELECTOR.getValueCardinality());
        Assert.assertEquals((long)1L, (long)this.CONST_EXTRACTION_SELECTOR.getValueCardinality());
    }

    @Test
    public void testLookupName() throws Exception {
        Assert.assertEquals(null, (Object)this.NULL_SELECTOR.lookupName(0));
        Assert.assertEquals((Object)"billy", (Object)this.CONST_SELECTOR.lookupName(0));
        Assert.assertEquals((Object)"billy", (Object)this.NULL_EXTRACTION_SELECTOR.lookupName(0));
        Assert.assertEquals((Object)"billy", (Object)this.CONST_EXTRACTION_SELECTOR.lookupName(0));
    }

    @Test
    public void testLookupId() throws Exception {
        Assert.assertEquals((long)0L, (long)this.NULL_SELECTOR.idLookup().lookupId(null));
        Assert.assertEquals((long)0L, (long)this.NULL_SELECTOR.idLookup().lookupId(""));
        Assert.assertEquals((long)-1L, (long)this.NULL_SELECTOR.idLookup().lookupId("billy"));
        Assert.assertEquals((long)-1L, (long)this.NULL_SELECTOR.idLookup().lookupId("bob"));
        Assert.assertEquals((long)-1L, (long)this.CONST_SELECTOR.idLookup().lookupId(null));
        Assert.assertEquals((long)-1L, (long)this.CONST_SELECTOR.idLookup().lookupId(""));
        Assert.assertEquals((long)0L, (long)this.CONST_SELECTOR.idLookup().lookupId("billy"));
        Assert.assertEquals((long)-1L, (long)this.CONST_SELECTOR.idLookup().lookupId("bob"));
        Assert.assertEquals((long)-1L, (long)this.NULL_EXTRACTION_SELECTOR.idLookup().lookupId(null));
        Assert.assertEquals((long)-1L, (long)this.NULL_EXTRACTION_SELECTOR.idLookup().lookupId(""));
        Assert.assertEquals((long)0L, (long)this.NULL_EXTRACTION_SELECTOR.idLookup().lookupId("billy"));
        Assert.assertEquals((long)-1L, (long)this.NULL_EXTRACTION_SELECTOR.idLookup().lookupId("bob"));
        Assert.assertEquals((long)-1L, (long)this.CONST_EXTRACTION_SELECTOR.idLookup().lookupId(null));
        Assert.assertEquals((long)-1L, (long)this.CONST_EXTRACTION_SELECTOR.idLookup().lookupId(""));
        Assert.assertEquals((long)0L, (long)this.CONST_EXTRACTION_SELECTOR.idLookup().lookupId("billy"));
        Assert.assertEquals((long)-1L, (long)this.CONST_EXTRACTION_SELECTOR.idLookup().lookupId("bob"));
    }
}

