/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.timeseries;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.FinalizeResultsQueryRunner;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.io.druid.segment.IncrementalIndexSegment;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexSchema;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeseriesQueryRunnerBonusTest {
    private final boolean descending;

    @Parameterized.Parameters(name="descending={0}")
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        return QueryRunnerTestHelper.transformToConstructionFeeder(Arrays.asList(false, true));
    }

    public TimeseriesQueryRunnerBonusTest(boolean descending) {
        this.descending = descending;
    }

    @Test
    public void testOneRowAtATime() throws Exception {
        IncrementalIndex oneRowIndex = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DateTimes.of((String)"2012-01-01T00:00:00Z").getMillis()).build()).setMaxRowCount(1000).buildOnheap();
        oneRowIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2012-01-01T00:00:00Z").getMillis(), (List)ImmutableList.of((Object)"dim1"), (Map)ImmutableMap.of((Object)"dim1", (Object)"x")));
        List<Result<TimeseriesResultValue>> results = this.runTimeseriesCount(oneRowIndex);
        Assert.assertEquals((String)"index size", (long)1L, (long)oneRowIndex.size());
        Assert.assertEquals((String)"result size", (long)1L, (long)results.size());
        Assert.assertEquals((String)"result timestamp", (Object)DateTimes.of((String)"2012-01-01T00:00:00Z"), (Object)results.get(0).getTimestamp());
        Assert.assertEquals((String)"result count metric", (long)1L, (long)((TimeseriesResultValue)results.get(0).getValue()).getLongMetric("rows"));
        oneRowIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2012-01-01T00:00:00Z").getMillis(), (List)ImmutableList.of((Object)"dim1"), (Map)ImmutableMap.of((Object)"dim1", (Object)"y")));
        results = this.runTimeseriesCount(oneRowIndex);
        Assert.assertEquals((String)"index size", (long)2L, (long)oneRowIndex.size());
        Assert.assertEquals((String)"result size", (long)1L, (long)results.size());
        Assert.assertEquals((String)"result timestamp", (Object)DateTimes.of((String)"2012-01-01T00:00:00Z"), (Object)results.get(0).getTimestamp());
        Assert.assertEquals((String)"result count metric", (long)2L, (long)((TimeseriesResultValue)results.get(0).getValue()).getLongMetric("rows"));
    }

    private List<Result<TimeseriesResultValue>> runTimeseriesCount(IncrementalIndex index) {
        TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        QueryRunner runner = TimeseriesQueryRunnerBonusTest.makeQueryRunner(factory, (Segment)new IncrementalIndexSegment(index, null));
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("xxx").granularity(Granularities.ALL).intervals((List)ImmutableList.of((Object)Intervals.of((String)"2012-01-01T00:00:00Z/P1D"))).aggregators((List)ImmutableList.of((Object)new CountAggregatorFactory("rows"))).descending(this.descending).build();
        HashMap context = new HashMap();
        return Sequences.toList((Sequence)runner.run(QueryPlus.wrap((Query)query), context), (List)Lists.newArrayList());
    }

    private static <T> QueryRunner<T> makeQueryRunner(QueryRunnerFactory<T, Query<T>> factory, Segment adapter) {
        return new FinalizeResultsQueryRunner(factory.createRunner(adapter), factory.getToolchest());
    }
}

