/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.select;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.query.select.PagingOffset;
import org.junit.Assert;
import org.junit.Test;

public class PagingOffsetTest {
    @Test
    public void testZeroThreshold() throws Exception {
        PagingOffset offset = PagingOffset.of((int)PagingOffset.toOffset((int)3, (boolean)false), (int)0);
        Assert.assertEquals((long)3L, (long)offset.startOffset());
        Assert.assertEquals((long)3L, (long)offset.startDelta());
        Assert.assertArrayEquals((int[])new int[0], (int[])this.toArray(offset));
        offset = PagingOffset.of((int)PagingOffset.toOffset((int)3, (boolean)true), (int)0);
        Assert.assertEquals((long)-4L, (long)offset.startOffset());
        Assert.assertEquals((long)3L, (long)offset.startDelta());
        Assert.assertArrayEquals((int[])new int[0], (int[])this.toArray(offset));
    }

    @Test
    public void testAscending() throws Exception {
        PagingOffset offset = PagingOffset.of((int)PagingOffset.toOffset((int)3, (boolean)false), (int)3);
        Assert.assertEquals((long)3L, (long)offset.startOffset());
        Assert.assertEquals((long)3L, (long)offset.startDelta());
        Assert.assertArrayEquals((int[])new int[]{3, 4, 5}, (int[])this.toArray(offset));
    }

    @Test
    public void testDescending() throws Exception {
        PagingOffset offset = PagingOffset.of((int)PagingOffset.toOffset((int)3, (boolean)true), (int)3);
        Assert.assertEquals((long)-4L, (long)offset.startOffset());
        Assert.assertEquals((long)3L, (long)offset.startDelta());
        Assert.assertArrayEquals((int[])new int[]{-4, -5, -6}, (int[])this.toArray(offset));
    }

    private int[] toArray(PagingOffset offset) {
        ArrayList ints = Lists.newArrayList();
        while (offset.hasNext()) {
            ints.add(offset.current());
            offset.next();
        }
        return Ints.toArray((Collection)ints);
    }
}

