/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.lookup;

import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.core.ClassNamesResourceConfig;
import com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.WebAppDescriptor;
import com.sun.jersey.test.framework.spi.container.TestContainerFactory;
import com.sun.jersey.test.framework.spi.container.grizzly2.GrizzlyTestContainerFactory;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractorFactory;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.hive.druid.io.druid.query.lookup.LookupIntrospectHandler;
import org.apache.hive.druid.io.druid.query.lookup.LookupIntrospectionResource;
import org.apache.hive.druid.io.druid.query.lookup.LookupReferencesManager;
import org.apache.hive.druid.io.druid.query.lookup.MapLookupExtractorFactory;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LookupIntrospectionResourceImplTest
extends JerseyTest {
    static LookupReferencesManager lookupReferencesManager = (LookupReferencesManager)EasyMock.createMock(LookupReferencesManager.class);

    @Before
    public void setUp() throws Exception {
        super.setUp();
        EasyMock.reset((Object[])new Object[]{lookupReferencesManager});
        MapLookupExtractorFactory lookupExtractorFactory1 = new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key", (Object)"value", (Object)"key2", (Object)"value2"), false);
        EasyMock.expect((Object)lookupReferencesManager.get("lookupId1")).andReturn((Object)new LookupExtractorFactoryContainer("v0", (LookupExtractorFactory)lookupExtractorFactory1)).anyTimes();
        EasyMock.replay((Object[])new Object[]{lookupReferencesManager});
    }

    public LookupIntrospectionResourceImplTest() {
        super((AppDescriptor)new WebAppDescriptor.Builder().initParam("com.sun.jersey.config.property.resourceConfigClass", ClassNamesResourceConfig.class.getName()).initParam("com.sun.jersey.config.property.classnames", LookupIntrospectionResource.class.getName() + ';' + MockTodoServiceProvider.class.getName() + ';' + LookupIntrospectHandler.class.getName()).build());
    }

    protected TestContainerFactory getTestContainerFactory() {
        return new GrizzlyTestContainerFactory();
    }

    @Test
    public void testGetKey() {
        WebResource r = this.resource().path("/druid/v1/lookups/introspect/lookupId1/keys");
        String s = (String)r.get(String.class);
        Assert.assertEquals((Object)"[key, key2]", (Object)s);
    }

    @Test
    public void testGetValue() {
        WebResource r = this.resource().path("/druid/v1/lookups/introspect/lookupId1/values");
        String s = (String)r.get(String.class);
        Assert.assertEquals((Object)"[value, value2]", (Object)s);
    }

    @Test
    public void testGetMap() {
        WebResource r = this.resource().path("/druid/v1/lookups/introspect/lookupId1/");
        String s = (String)r.get(String.class);
        Assert.assertEquals((Object)"{\"key\":\"value\",\"key2\":\"value2\"}", (Object)s);
    }

    @Provider
    public static class MockTodoServiceProvider
    extends SingletonTypeInjectableProvider<Context, LookupReferencesManager> {
        public MockTodoServiceProvider() {
            super(LookupReferencesManager.class, (Object)lookupReferencesManager);
        }
    }
}

