/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.post;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.io.druid.data.input.MapBasedRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.jackson.AggregatorsModule;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.aggregation.AggregationTestHelper;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.post.FinalizingFieldAccessPostAggregator;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryRunnerTest;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FinalizingFieldAccessPostAggregatorTest {
    @Rule
    public final TemporaryFolder tempFoler = new TemporaryFolder();

    @Test(expected=UnsupportedOperationException.class)
    public void testComputeWithoutFinalizing() {
        String aggName = "rows";
        CountAggregator agg = new CountAggregator();
        agg.aggregate();
        agg.aggregate();
        agg.aggregate();
        HashMap metricValues = Maps.newHashMap();
        metricValues.put(aggName, agg.get());
        FinalizingFieldAccessPostAggregator postAgg = new FinalizingFieldAccessPostAggregator("final_rows", aggName);
        Assert.assertEquals((Object)new Long(3L), (Object)postAgg.compute((Map)metricValues));
    }

    @Test
    public void testComputedWithFinalizing() {
        String aggName = "biily";
        AggregatorFactory aggFactory = (AggregatorFactory)EasyMock.createMock(AggregatorFactory.class);
        EasyMock.expect((Object)aggFactory.finalizeComputation((Object)"test")).andReturn((Object)new Long(3L)).times(1);
        EasyMock.replay((Object[])new Object[]{aggFactory});
        FinalizingFieldAccessPostAggregator postAgg = FinalizingFieldAccessPostAggregator.buildDecorated((String)"final_billy", (String)aggName, (Map)ImmutableMap.of((Object)aggName, (Object)aggFactory));
        HashMap metricValues = Maps.newHashMap();
        metricValues.put(aggName, "test");
        Assert.assertEquals((Object)new Long(3L), (Object)postAgg.compute((Map)metricValues));
        EasyMock.verify((Object[])new Object[]{aggFactory});
    }

    @Test
    public void testComputedInArithmeticPostAggregator() {
        String aggName = "billy";
        AggregatorFactory aggFactory = (AggregatorFactory)EasyMock.createMock(AggregatorFactory.class);
        EasyMock.expect((Object)aggFactory.finalizeComputation((Object)"test")).andReturn((Object)new Long(3L)).times(1);
        EasyMock.replay((Object[])new Object[]{aggFactory});
        FinalizingFieldAccessPostAggregator postAgg = FinalizingFieldAccessPostAggregator.buildDecorated((String)"final_billy", (String)aggName, (Map)ImmutableMap.of((Object)aggName, (Object)aggFactory));
        HashMap metricValues = Maps.newHashMap();
        metricValues.put(aggName, "test");
        ArrayList postAggsList = Lists.newArrayList((Object[])new PostAggregator[]{new ConstantPostAggregator("roku", (Number)6), postAgg});
        ArithmeticPostAggregator arithmeticPostAggregator = new ArithmeticPostAggregator("add", "+", (List)postAggsList);
        Assert.assertEquals((Object)new Double(9.0), (Object)arithmeticPostAggregator.compute((Map)metricValues));
        EasyMock.verify((Object[])new Object[0]);
    }

    @Test
    public void testComparatorsWithFinalizing() throws Exception {
        String aggName = "billy";
        AggregatorFactory aggFactory = (AggregatorFactory)EasyMock.createMock(AggregatorFactory.class);
        EasyMock.expect((Object)aggFactory.finalizeComputation((Object)"test_val1")).andReturn((Object)new Long(10L)).times(1);
        EasyMock.expect((Object)aggFactory.finalizeComputation((Object)"test_val2")).andReturn((Object)new Long(21L)).times(1);
        EasyMock.expect((Object)aggFactory.finalizeComputation((Object)"test_val3")).andReturn((Object)new Long(3L)).times(1);
        EasyMock.expect((Object)aggFactory.finalizeComputation((Object)"test_val4")).andReturn(null).times(1);
        EasyMock.expect((Object)aggFactory.getComparator()).andReturn((Object)Ordering.natural().nullsLast()).times(1);
        EasyMock.replay((Object[])new Object[]{aggFactory});
        FinalizingFieldAccessPostAggregator postAgg = FinalizingFieldAccessPostAggregator.buildDecorated((String)"final_billy", (String)aggName, (Map)ImmutableMap.of((Object)aggName, (Object)aggFactory));
        ArrayList computedValues = Lists.newArrayList();
        computedValues.add(postAgg.compute((Map)ImmutableMap.of((Object)aggName, (Object)"test_val1")));
        computedValues.add(postAgg.compute((Map)ImmutableMap.of((Object)aggName, (Object)"test_val2")));
        computedValues.add(postAgg.compute((Map)ImmutableMap.of((Object)aggName, (Object)"test_val3")));
        computedValues.add(postAgg.compute((Map)ImmutableMap.of((Object)aggName, (Object)"test_val4")));
        Collections.sort(computedValues, postAgg.getComparator());
        Assert.assertArrayEquals((Object[])new Object[]{3L, 10L, 21L, null}, (Object[])computedValues.toArray(new Object[0]));
        EasyMock.verify((Object[])new Object[0]);
    }

    @Test
    public void testComparatorsWithFinalizingAndComparatorNull() throws Exception {
        String aggName = "billy";
        AggregatorFactory aggFactory = (AggregatorFactory)EasyMock.createMock(AggregatorFactory.class);
        EasyMock.expect((Object)aggFactory.getComparator()).andReturn(null).times(1);
        EasyMock.replay((Object[])new Object[]{aggFactory});
        FinalizingFieldAccessPostAggregator postAgg = FinalizingFieldAccessPostAggregator.buildDecorated((String)"final_billy", (String)"joe", (Map)ImmutableMap.of((Object)aggName, (Object)aggFactory));
        ArrayList computedValues = Lists.newArrayList();
        HashMap forNull = Maps.newHashMap();
        forNull.put("joe", null);
        computedValues.add(postAgg.compute((Map)ImmutableMap.of((Object)"joe", (Object)"test_val1")));
        computedValues.add(postAgg.compute((Map)ImmutableMap.of((Object)"joe", (Object)"test_val2")));
        computedValues.add(postAgg.compute((Map)forNull));
        computedValues.add(postAgg.compute((Map)ImmutableMap.of((Object)"joe", (Object)"test_val4")));
        Collections.sort(computedValues, postAgg.getComparator());
        Assert.assertArrayEquals((Object[])new Object[]{null, "test_val1", "test_val2", "test_val4"}, (Object[])computedValues.toArray(new Object[0]));
        EasyMock.verify((Object[])new Object[0]);
    }

    @Test
    public void testIngestAndQueryWithArithmeticPostAggregator() throws Exception {
        AggregationTestHelper helper = AggregationTestHelper.createGroupByQueryAggregationTestHelper(Lists.newArrayList((Object[])new AggregatorsModule[]{new AggregatorsModule()}), GroupByQueryRunnerTest.testConfigs().get(0), this.tempFoler);
        String metricSpec = "[{\"type\": \"hyperUnique\", \"name\": \"hll_market\", \"fieldName\": \"market\"},{\"type\": \"hyperUnique\", \"name\": \"hll_quality\", \"fieldName\": \"quality\"}]";
        String parseSpec = "{\"type\" : \"string\",\"parseSpec\" : {    \"format\" : \"tsv\",    \"timestampSpec\" : {        \"column\" : \"timestamp\",        \"format\" : \"auto\"},    \"dimensionsSpec\" : {        \"dimensions\": [],        \"dimensionExclusions\" : [],        \"spatialDimensions\" : []    },    \"columns\": [\"timestamp\", \"market\", \"quality\", \"placement\", \"placementish\", \"index\"]  }}";
        String query = "{\"queryType\": \"groupBy\",\"dataSource\": \"test_datasource\",\"granularity\": \"ALL\",\"dimensions\": [],\"aggregations\": [  { \"type\": \"hyperUnique\", \"name\": \"hll_market\", \"fieldName\": \"hll_market\" },  { \"type\": \"hyperUnique\", \"name\": \"hll_quality\", \"fieldName\": \"hll_quality\" }],\"postAggregations\": [  { \"type\": \"arithmetic\", \"name\": \"uniq_add\", \"fn\": \"+\", \"fields\":[    { \"type\": \"finalizingFieldAccess\", \"name\": \"uniq_market\", \"fieldName\": \"hll_market\" },    { \"type\": \"finalizingFieldAccess\", \"name\": \"uniq_quality\", \"fieldName\": \"hll_quality\" }]  }],\"intervals\": [ \"1970/2050\" ]}";
        Sequence<Row> seq = helper.createIndexAndRunQueryOnSegment(new File(this.getClass().getClassLoader().getResource("druid.sample.tsv").getFile()), parseSpec, metricSpec, 0L, Granularities.NONE, 50000, query);
        MapBasedRow row = (MapBasedRow)((ArrayList)Sequences.toList(seq, (List)Lists.newArrayList())).get(0);
        Assert.assertEquals((double)3.0, (double)row.getMetric("hll_market").floatValue(), (double)0.1);
        Assert.assertEquals((double)9.0, (double)row.getMetric("hll_quality").floatValue(), (double)0.1);
        Assert.assertEquals((double)12.0, (double)row.getMetric("uniq_add").floatValue(), (double)0.1);
    }
}

