/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import com.google.caliper.Runner;
import com.google.caliper.SimpleBenchmark;
import java.util.Collections;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleSumAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.JavaScriptAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.JavaScriptAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.TestDoubleColumnSelectorImpl;
import org.apache.hive.druid.io.druid.segment.BaseDoubleColumnValueSelector;

public class JavaScriptAggregatorBenchmark
extends SimpleBenchmark {
    protected static final Map<String, String> scriptDoubleSum = Maps.newHashMap();
    private JavaScriptAggregator jsAggregator;
    private DoubleSumAggregator doubleAgg;
    final LoopingDoubleColumnSelector selector = new LoopingDoubleColumnSelector(new double[]{42.12, 9.0});

    private static void aggregate(TestDoubleColumnSelectorImpl selector, Aggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    protected void setUp() throws Exception {
        Map<String, String> script = scriptDoubleSum;
        this.jsAggregator = new JavaScriptAggregator(Collections.singletonList(this.selector), JavaScriptAggregatorFactory.compileScript((String)script.get("fnAggregate"), (String)script.get("fnReset"), (String)script.get("fnCombine")));
        this.doubleAgg = new DoubleSumAggregator((BaseDoubleColumnValueSelector)this.selector);
    }

    public double timeJavaScriptDoubleSum(int reps) {
        double val = 0.0;
        for (int i = 0; i < reps; ++i) {
            JavaScriptAggregatorBenchmark.aggregate(this.selector, (Aggregator)this.jsAggregator);
        }
        return val;
    }

    public double timeNativeDoubleSum(int reps) {
        double val = 0.0;
        for (int i = 0; i < reps; ++i) {
            JavaScriptAggregatorBenchmark.aggregate(this.selector, (Aggregator)this.doubleAgg);
        }
        return val;
    }

    public static void main(String[] args) throws Exception {
        Runner.main(JavaScriptAggregatorBenchmark.class, (String[])args);
    }

    static {
        scriptDoubleSum.put("fnAggregate", "function aggregate(current, a) { return current + a }");
        scriptDoubleSum.put("fnReset", "function reset() { return 0 }");
        scriptDoubleSum.put("fnCombine", "function combine(a,b) { return a + b }");
    }

    protected static class LoopingDoubleColumnSelector
    extends TestDoubleColumnSelectorImpl {
        private final double[] doubles;
        private long index = 0L;

        public LoopingDoubleColumnSelector(double[] doubles) {
            super(doubles);
            this.doubles = doubles;
        }

        @Override
        public double getDouble() {
            return this.doubles[(int)(this.index % (long)this.doubles.length)];
        }

        @Override
        public void increment() {
            ++this.index;
            if (this.index < 0L) {
                this.index = 0L;
            }
        }
    }
}

