/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParser;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonToken;
import org.apache.hive.druid.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.fasterxml.jackson.databind.Module;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.io.Closeables;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.collections.NonBlockingPool;
import org.apache.hive.druid.io.druid.collections.StupidPool;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.StringInputRowParser;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.java.util.common.guava.Yielder;
import org.apache.hive.druid.io.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.hive.druid.io.druid.query.FinalizeResultsQueryRunner;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.MetricManipulatorFns;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.hive.druid.io.druid.query.select.SelectQueryConfig;
import org.apache.hive.druid.io.druid.query.select.SelectQueryEngine;
import org.apache.hive.druid.io.druid.query.select.SelectQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.select.SelectQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryConfig;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryRunnerFactory;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.IndexMerger;
import org.apache.hive.druid.io.druid.segment.IndexMergerV9;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.QueryableIndexSegment;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.segment.column.ColumnConfig;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.io.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.junit.rules.TemporaryFolder;

public class AggregationTestHelper {
    private final ObjectMapper mapper;
    private final IndexMerger indexMerger;
    private final IndexIO indexIO;
    private final QueryToolChest toolChest;
    private final QueryRunnerFactory factory;
    private final TemporaryFolder tempFolder;

    private AggregationTestHelper(ObjectMapper mapper, IndexMerger indexMerger, IndexIO indexIO, QueryToolChest toolchest, QueryRunnerFactory factory, TemporaryFolder tempFolder, List<? extends Module> jsonModulesToRegister) {
        this.mapper = mapper;
        this.indexMerger = indexMerger;
        this.indexIO = indexIO;
        this.toolChest = toolchest;
        this.factory = factory;
        this.tempFolder = tempFolder;
        for (Module module : jsonModulesToRegister) {
            mapper.registerModule(module);
        }
    }

    public static final AggregationTestHelper createGroupByQueryAggregationTestHelper(List<? extends Module> jsonModulesToRegister, GroupByQueryConfig config, TemporaryFolder tempFolder) {
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        GroupByQueryRunnerFactory factory = GroupByQueryRunnerTest.makeQueryRunnerFactory(mapper, config);
        IndexIO indexIO = new IndexIO(mapper, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), new ColumnConfig(){

            public int columnCacheSizeBytes() {
                return 0;
            }
        });
        return new AggregationTestHelper(mapper, (IndexMerger)new IndexMergerV9(mapper, indexIO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()), indexIO, factory.getToolchest(), (QueryRunnerFactory)factory, tempFolder, jsonModulesToRegister);
    }

    public static final AggregationTestHelper createSelectQueryAggregationTestHelper(List<? extends Module> jsonModulesToRegister, TemporaryFolder tempFolder) {
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(SelectQueryConfig.class, (Object)new SelectQueryConfig(Boolean.valueOf(true))));
        Supplier configSupplier = Suppliers.ofInstance((Object)new SelectQueryConfig(Boolean.valueOf(true)));
        SelectQueryQueryToolChest toolchest = new SelectQueryQueryToolChest(TestHelper.makeJsonMapper(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator(), configSupplier);
        SelectQueryRunnerFactory factory = new SelectQueryRunnerFactory(new SelectQueryQueryToolChest(TestHelper.makeJsonMapper(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator(), configSupplier), new SelectQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        IndexIO indexIO = new IndexIO(mapper, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), new ColumnConfig(){

            public int columnCacheSizeBytes() {
                return 0;
            }
        });
        return new AggregationTestHelper(mapper, (IndexMerger)new IndexMergerV9(mapper, indexIO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()), indexIO, (QueryToolChest)toolchest, (QueryRunnerFactory)factory, tempFolder, jsonModulesToRegister);
    }

    public static final AggregationTestHelper createTimeseriesQueryAggregationTestHelper(List<? extends Module> jsonModulesToRegister, TemporaryFolder tempFolder) {
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        TimeseriesQueryQueryToolChest toolchest = new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator());
        TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(toolchest, new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        IndexIO indexIO = new IndexIO(mapper, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), new ColumnConfig(){

            public int columnCacheSizeBytes() {
                return 0;
            }
        });
        return new AggregationTestHelper(mapper, (IndexMerger)new IndexMergerV9(mapper, indexIO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()), indexIO, (QueryToolChest)toolchest, (QueryRunnerFactory)factory, tempFolder, jsonModulesToRegister);
    }

    public static final AggregationTestHelper createTopNQueryAggregationTestHelper(List<? extends Module> jsonModulesToRegister, TemporaryFolder tempFolder) {
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        TopNQueryQueryToolChest toolchest = new TopNQueryQueryToolChest(new TopNQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator());
        TopNQueryRunnerFactory factory = new TopNQueryRunnerFactory((NonBlockingPool)new StupidPool("TopNQueryRunnerFactory-bufferPool", (Supplier)new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocate(0xA00000);
            }
        }), toolchest, QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        IndexIO indexIO = new IndexIO(mapper, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), new ColumnConfig(){

            public int columnCacheSizeBytes() {
                return 0;
            }
        });
        return new AggregationTestHelper(mapper, (IndexMerger)new IndexMergerV9(mapper, indexIO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()), indexIO, (QueryToolChest)toolchest, (QueryRunnerFactory)factory, tempFolder, jsonModulesToRegister);
    }

    public Sequence<Row> createIndexAndRunQueryOnSegment(File inputDataFile, String parserJson, String aggregators, long minTimestamp, Granularity gran, int maxRowCount, String groupByQueryJson) throws Exception {
        File segmentDir = this.tempFolder.newFolder();
        this.createIndex(inputDataFile, parserJson, aggregators, segmentDir, minTimestamp, gran, maxRowCount);
        return this.runQueryOnSegments((List<File>)Lists.newArrayList((Object[])new File[]{segmentDir}), groupByQueryJson);
    }

    public Sequence<Row> createIndexAndRunQueryOnSegment(InputStream inputDataStream, String parserJson, String aggregators, long minTimestamp, Granularity gran, int maxRowCount, String groupByQueryJson) throws Exception {
        File segmentDir = this.tempFolder.newFolder();
        this.createIndex(inputDataStream, parserJson, aggregators, segmentDir, minTimestamp, gran, maxRowCount);
        return this.runQueryOnSegments((List<File>)Lists.newArrayList((Object[])new File[]{segmentDir}), groupByQueryJson);
    }

    public void createIndex(File inputDataFile, String parserJson, String aggregators, File outDir, long minTimestamp, Granularity gran, int maxRowCount) throws Exception {
        this.createIndex(new FileInputStream(inputDataFile), parserJson, aggregators, outDir, minTimestamp, gran, maxRowCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIndex(InputStream inputDataStream, String parserJson, String aggregators, File outDir, long minTimestamp, Granularity gran, int maxRowCount) throws Exception {
        try {
            StringInputRowParser parser = (StringInputRowParser)this.mapper.readValue(parserJson, StringInputRowParser.class);
            LineIterator iter = IOUtils.lineIterator((InputStream)inputDataStream, (String)"UTF-8");
            List aggregatorSpecs = (List)this.mapper.readValue(aggregators, (TypeReference)new TypeReference<List<AggregatorFactory>>(){});
            this.createIndex((Iterator)iter, (InputRowParser)parser, aggregatorSpecs.toArray(new AggregatorFactory[0]), outDir, minTimestamp, gran, true, maxRowCount);
        }
        finally {
            Closeables.close((Closeable)inputDataStream, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIndex(Iterator rows, InputRowParser parser, AggregatorFactory[] metrics, File outDir, long minTimestamp, Granularity gran, boolean deserializeComplexMetrics, int maxRowCount) throws Exception {
        ArrayList<File> toMerge = new ArrayList<File>();
        try (IncrementalIndex index = null;){
            index = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(minTimestamp).withQueryGranularity(gran).withMetrics(metrics).build()).setDeserializeComplexMetrics(deserializeComplexMetrics).setMaxRowCount(maxRowCount).buildOnheap();
            while (rows.hasNext()) {
                Object row = rows.next();
                if (!index.canAppendRow()) {
                    File tmp = this.tempFolder.newFolder();
                    toMerge.add(tmp);
                    this.indexMerger.persist(index, tmp, new IndexSpec(), null);
                    index.close();
                    index = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(minTimestamp).withQueryGranularity(gran).withMetrics(metrics).build()).setDeserializeComplexMetrics(deserializeComplexMetrics).setMaxRowCount(maxRowCount).buildOnheap();
                }
                if (row instanceof String && parser instanceof StringInputRowParser) {
                    index.add(((StringInputRowParser)parser).parse((String)row));
                    continue;
                }
                index.add((InputRow)parser.parseBatch(row).get(0));
            }
            if (toMerge.size() > 0) {
                File tmp = this.tempFolder.newFolder();
                toMerge.add(tmp);
                this.indexMerger.persist(index, tmp, new IndexSpec(), null);
                ArrayList<QueryableIndex> indexes = new ArrayList<QueryableIndex>(toMerge.size());
                for (File file : toMerge) {
                    indexes.add(this.indexIO.loadIndex(file));
                }
                this.indexMerger.mergeQueryableIndex(indexes, true, metrics, outDir, new IndexSpec(), null);
                for (QueryableIndex qi : indexes) {
                    qi.close();
                }
            } else {
                this.indexMerger.persist(index, outDir, new IndexSpec(), null);
            }
        }
    }

    public Sequence<Row> runQueryOnSegments(List<File> segmentDirs, String queryJson) throws Exception {
        return this.runQueryOnSegments(segmentDirs, (Query)this.mapper.readValue(queryJson, Query.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence<Row> runQueryOnSegments(List<File> segmentDirs, Query query) {
        List segments = Lists.transform(segmentDirs, (Function)new Function<File, Segment>(){

            public Segment apply(File segmentDir) {
                try {
                    return new QueryableIndexSegment("", AggregationTestHelper.this.indexIO.loadIndex(segmentDir));
                }
                catch (IOException ex) {
                    throw Throwables.propagate((Throwable)ex);
                }
            }
        });
        try {
            Sequence<Row> sequence = this.runQueryOnSegmentsObjs(segments, query);
            return sequence;
        }
        finally {
            for (Segment segment : segments) {
                CloseQuietly.close((Closeable)segment);
            }
        }
    }

    public Sequence<Row> runQueryOnSegmentsObjs(List<Segment> segments, Query query) {
        FinalizeResultsQueryRunner baseRunner = new FinalizeResultsQueryRunner(this.toolChest.postMergeQueryDecoration(this.toolChest.mergeResults(this.toolChest.preMergeQueryDecoration(this.factory.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), (Iterable)Lists.transform(segments, (Function)new Function<Segment, QueryRunner>(){

            public QueryRunner apply(Segment segment) {
                try {
                    return AggregationTestHelper.this.makeStringSerdeQueryRunner(AggregationTestHelper.this.mapper, AggregationTestHelper.this.toolChest, (QueryRunner<Row>)AggregationTestHelper.this.factory.createRunner(segment));
                }
                catch (Exception ex) {
                    throw Throwables.propagate((Throwable)ex);
                }
            }
        }))))), this.toolChest);
        return baseRunner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap());
    }

    public QueryRunner<Row> makeStringSerdeQueryRunner(final ObjectMapper mapper, final QueryToolChest toolChest, final QueryRunner<Row> baseRunner) {
        return new QueryRunner<Row>(){

            public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> map) {
                try {
                    Sequence resultSeq = baseRunner.run(queryPlus, (Map)Maps.newHashMap());
                    Yielder yielder = resultSeq.toYielder(null, new YieldingAccumulator(){

                        public Object accumulate(Object accumulated, Object in) {
                            this.yield();
                            return in;
                        }
                    });
                    String resultStr = mapper.writer().writeValueAsString((Object)yielder);
                    List resultRows = Lists.transform((List)AggregationTestHelper.this.readQueryResultArrayFromString(resultStr), (Function)toolChest.makePreComputeManipulatorFn(queryPlus.getQuery(), MetricManipulatorFns.deserializing()));
                    return Sequences.simple((Iterable)resultRows);
                }
                catch (Exception ex) {
                    throw Throwables.propagate((Throwable)ex);
                }
            }
        };
    }

    private List readQueryResultArrayFromString(String str) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        JsonParser jp = this.mapper.getFactory().createParser(str);
        if (jp.nextToken() != JsonToken.START_ARRAY) {
            throw new IAE("not an array [%s]", new Object[]{str});
        }
        ObjectCodec objectCodec = jp.getCodec();
        while (jp.nextToken() != JsonToken.END_ARRAY) {
            result.add(objectCodec.readValue(jp, this.toolChest.getResultTypeReference()));
        }
        return result;
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public <T> T[] runRelocateVerificationTest(AggregatorFactory factory, ColumnSelectorFactory selector, Class<T> clazz) {
        Object[] results = (Object[])Array.newInstance(clazz, 2);
        BufferAggregator agg = factory.factorizeBuffered(selector);
        ByteBuffer myBuf = ByteBuffer.allocate(10040902);
        agg.init(myBuf, 0);
        agg.aggregate(myBuf, 0);
        results[0] = agg.get(myBuf, 0);
        byte[] theBytes = new byte[factory.getMaxIntermediateSize()];
        myBuf.get(theBytes);
        ByteBuffer newBuf = ByteBuffer.allocate(941209);
        newBuf.position(7574);
        newBuf.put(theBytes);
        newBuf.position(0);
        agg.relocate(0, 7574, myBuf, newBuf);
        results[1] = agg.get(newBuf, 7574);
        return results;
    }
}

