/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.Map;
import java.util.Properties;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.java.util.common.config.Config;
import org.apache.hive.druid.io.druid.query.DruidProcessingConfig;
import org.junit.Assert;
import org.junit.Test;
import org.skife.config.ConfigurationObjectFactory;

public class DruidProcessingConfigTest {
    @Test
    public void testDeserialization() throws Exception {
        ConfigurationObjectFactory factory = Config.createFactory((Properties)new Properties());
        DruidProcessingConfig config = (DruidProcessingConfig)factory.build(DruidProcessingConfig.class);
        Assert.assertEquals((long)0x40000000L, (long)config.intermediateComputeSizeBytes());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)config.poolCacheMaxCount());
        if (Runtime.getRuntime().availableProcessors() == 1) {
            Assert.assertTrue((config.getNumThreads() == 1 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((config.getNumThreads() < Runtime.getRuntime().availableProcessors() ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)Math.max(2, config.getNumThreads() / 4), (long)config.getNumMergeBuffers());
        Assert.assertEquals((long)0L, (long)config.columnCacheSizeBytes());
        Assert.assertFalse((boolean)config.isFifo());
        Assert.assertEquals((Object)System.getProperty("java.io.tmpdir"), (Object)config.getTmpDir());
        Properties props = new Properties();
        props.setProperty("druid.processing.buffer.sizeBytes", "1");
        props.setProperty("druid.processing.buffer.poolCacheMaxCount", "1");
        props.setProperty("druid.processing.numThreads", "256");
        props.setProperty("druid.processing.columnCache.sizeBytes", "1");
        props.setProperty("druid.processing.fifo", "true");
        props.setProperty("druid.processing.tmpDir", "/test/path");
        factory = Config.createFactory((Properties)props);
        config = (DruidProcessingConfig)factory.buildWithReplacements(DruidProcessingConfig.class, (Map)ImmutableMap.of((Object)"base_path", (Object)"druid.processing"));
        Assert.assertEquals((long)1L, (long)config.intermediateComputeSizeBytes());
        Assert.assertEquals((long)1L, (long)config.poolCacheMaxCount());
        Assert.assertEquals((long)256L, (long)config.getNumThreads());
        Assert.assertEquals((long)64L, (long)config.getNumMergeBuffers());
        Assert.assertEquals((long)1L, (long)config.columnCacheSizeBytes());
        Assert.assertTrue((boolean)config.isFifo());
        Assert.assertEquals((Object)"/test/path", (Object)config.getTmpDir());
    }
}

