/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.metadata;

import java.util.LinkedList;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.io.druid.metadata.TestDerbyConnector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class SQLMetadataConnectorTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private TestDerbyConnector connector;
    private MetadataStorageTablesConfig tablesConfig;

    @Before
    public void setUp() throws Exception {
        this.connector = this.derbyConnectorRule.getConnector();
        this.tablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
    }

    @Test
    public void testCreateTables() throws Exception {
        final LinkedList<String> tables = new LinkedList<String>();
        String entryType = this.tablesConfig.getTaskEntryType();
        tables.add(this.tablesConfig.getConfigTable());
        tables.add(this.tablesConfig.getSegmentsTable());
        tables.add(this.tablesConfig.getRulesTable());
        tables.add(this.tablesConfig.getLockTable(entryType));
        tables.add(this.tablesConfig.getLogTable(entryType));
        tables.add(this.tablesConfig.getEntryTable(entryType));
        tables.add(this.tablesConfig.getAuditTable());
        tables.add(this.tablesConfig.getSupervisorTable());
        this.connector.createSegmentTable();
        this.connector.createConfigTable();
        this.connector.createRulesTable();
        this.connector.createTaskTables();
        this.connector.createAuditTable();
        this.connector.createSupervisorsTable();
        this.connector.getDBI().withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                for (String table : tables) {
                    Assert.assertTrue((String)StringUtils.format((String)"table %s was not created!", (Object[])new Object[]{table}), (boolean)SQLMetadataConnectorTest.this.connector.tableExists(handle, table));
                }
                return null;
            }
        });
        for (String table : tables) {
            this.dropTable(table);
        }
    }

    @Test
    public void testInsertOrUpdate() throws Exception {
        String tableName = "test";
        this.connector.createConfigTable("test");
        Assert.assertNull((Object)this.connector.lookup("test", "name", "payload", "emperor"));
        this.connector.insertOrUpdate("test", "name", "payload", "emperor", StringUtils.toUtf8((String)"penguin"));
        Assert.assertArrayEquals((byte[])StringUtils.toUtf8((String)"penguin"), (byte[])this.connector.lookup("test", "name", "payload", "emperor"));
        this.connector.insertOrUpdate("test", "name", "payload", "emperor", StringUtils.toUtf8((String)"penguin chick"));
        Assert.assertArrayEquals((byte[])StringUtils.toUtf8((String)"penguin chick"), (byte[])this.connector.lookup("test", "name", "payload", "emperor"));
        this.dropTable("test");
    }

    private void dropTable(final String tableName) {
        this.connector.getDBI().withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                handle.createStatement(StringUtils.format((String)"DROP TABLE %s", (Object[])new Object[]{tableName})).execute();
                return null;
            }
        });
    }
}

