/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.math.expr;

import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.math.expr.Parser;
import org.junit.Assert;
import org.junit.Test;

public class ParserTest {
    @Test
    public void testSimple() {
        String actual = Parser.parse((String)"1", (ExprMacroTable)ExprMacroTable.nil()).toString();
        String expected = "1";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSimpleUnaryOps1() {
        String actual = Parser.parse((String)"-x", (ExprMacroTable)ExprMacroTable.nil()).toString();
        String expected = "-x";
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Parser.parse((String)"!x", (ExprMacroTable)ExprMacroTable.nil()).toString();
        expected = "!x";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSimpleUnaryOps2() {
        this.validateFlatten("-1", "-1", "-1");
        this.validateFlatten("--1", "--1", "1");
        this.validateFlatten("-1+2", "(+ -1 2)", "1");
        this.validateFlatten("-1*2", "(* -1 2)", "-2");
        this.validateFlatten("-1^2", "(^ -1 2)", "1");
    }

    @Test
    public void testSimpleLogicalOps1() {
        this.validateParser("x>y", "(> x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateParser("x<y", "(< x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateParser("x<=y", "(<= x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateParser("x>=y", "(>= x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateParser("x==y", "(== x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateParser("x!=y", "(!= x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateParser("x && y", "(&& x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateParser("x || y", "(|| x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
    }

    @Test
    public void testSimpleAdditivityOp1() {
        this.validateParser("x+y", "(+ x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateParser("x-y", "(- x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
    }

    @Test
    public void testSimpleAdditivityOp2() {
        this.validateParser("x+y+z", "(+ (+ x y) z)", (List<String>)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"));
        this.validateParser("x+y-z", "(- (+ x y) z)", (List<String>)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"));
        this.validateParser("x-y+z", "(+ (- x y) z)", (List<String>)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"));
        this.validateParser("x-y-z", "(- (- x y) z)", (List<String>)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"));
        this.validateParser("x-y-x", "(- (- x y) x)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
    }

    @Test
    public void testSimpleMultiplicativeOp1() {
        this.validateParser("x*y", "(* x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateParser("x/y", "(/ x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateParser("x%y", "(% x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
    }

    @Test
    public void testSimpleMultiplicativeOp2() {
        this.validateFlatten("1*2*3", "(* (* 1 2) 3)", "6");
        this.validateFlatten("1*2/3", "(/ (* 1 2) 3)", "0");
        this.validateFlatten("1/2*3", "(* (/ 1 2) 3)", "0");
        this.validateFlatten("1/2/3", "(/ (/ 1 2) 3)", "0");
        this.validateFlatten("1.0*2*3", "(* (* 1.0 2) 3)", "6.0");
        this.validateFlatten("1.0*2/3", "(/ (* 1.0 2) 3)", "0.6666666666666666");
        this.validateFlatten("1.0/2*3", "(* (/ 1.0 2) 3)", "1.5");
        this.validateFlatten("1.0/2/3", "(/ (/ 1.0 2) 3)", "0.16666666666666666");
        this.validateFlatten("1.0*2*x", "(* (* 1.0 2) x)", "(* 2.0 x)");
        this.validateFlatten("1.0*2/x", "(/ (* 1.0 2) x)", "(/ 2.0 x)");
        this.validateFlatten("1.0/2*x", "(* (/ 1.0 2) x)", "(* 0.5 x)");
        this.validateFlatten("1.0/2/x", "(/ (/ 1.0 2) x)", "(/ 0.5 x)");
        this.validateFlatten("1.0*x*3", "(* (* 1.0 x) 3)", "(* (* 1.0 x) 3)");
    }

    @Test
    public void testSimpleCarrot1() {
        this.validateFlatten("1^2", "(^ 1 2)", "1");
    }

    @Test
    public void testSimpleCarrot2() {
        this.validateFlatten("1^2^3", "(^ 1 (^ 2 3))", "1");
    }

    @Test
    public void testMixed() {
        this.validateFlatten("1+2*3", "(+ 1 (* 2 3))", "7");
        this.validateFlatten("1+(2*3)", "(+ 1 (* 2 3))", "7");
        this.validateFlatten("(1+2)*3", "(* (+ 1 2) 3)", "9");
        this.validateFlatten("1*2+3", "(+ (* 1 2) 3)", "5");
        this.validateFlatten("(1*2)+3", "(+ (* 1 2) 3)", "5");
        this.validateFlatten("1*(2+3)", "(* 1 (+ 2 3))", "5");
        this.validateFlatten("1+2^3", "(+ 1 (^ 2 3))", "9");
        this.validateFlatten("1+(2^3)", "(+ 1 (^ 2 3))", "9");
        this.validateFlatten("(1+2)^3", "(^ (+ 1 2) 3)", "27");
        this.validateFlatten("1^2+3", "(+ (^ 1 2) 3)", "4");
        this.validateFlatten("(1^2)+3", "(+ (^ 1 2) 3)", "4");
        this.validateFlatten("1^(2+3)", "(^ 1 (+ 2 3))", "1");
        this.validateFlatten("1^2*3+4", "(+ (* (^ 1 2) 3) 4)", "7");
        this.validateFlatten("-1^2*-3+-4", "(+ (* (^ -1 2) -3) -4)", "-7");
        this.validateFlatten("max(3, 4)", "(max [3, 4])", "4");
        this.validateFlatten("min(1, max(3, 4))", "(min [1, (max [3, 4])])", "1");
    }

    @Test
    public void testIdentifiers() {
        this.validateParser("foo", "foo", (List<String>)ImmutableList.of((Object)"foo"));
        this.validateParser("\"foo\"", "foo", (List<String>)ImmutableList.of((Object)"foo"));
        this.validateParser("\"foo bar\"", "foo bar", (List<String>)ImmutableList.of((Object)"foo bar"));
        this.validateParser("\"foo\\\"bar\"", "foo\"bar", (List<String>)ImmutableList.of((Object)"foo\"bar"));
    }

    @Test
    public void testLiterals() {
        this.validateConstantExpression("'foo'", "foo");
        this.validateConstantExpression("'foo bar'", "foo bar");
        this.validateConstantExpression("'f\u00f6o bar'", "f\u00f6o bar");
        this.validateConstantExpression("'f\\u0040o bar'", "f@o bar");
        this.validateConstantExpression("'f\\u000Ao \\'b\\\\\\\"ar'", "f\no 'b\\\"ar");
    }

    @Test
    public void testFunctions() {
        this.validateParser("sqrt(x)", "(sqrt [x])", (List<String>)ImmutableList.of((Object)"x"));
        this.validateParser("if(cond,then,else)", "(if [cond, then, else])", (List<String>)ImmutableList.of((Object)"cond", (Object)"then", (Object)"else"));
    }

    private void validateFlatten(String expression, String withoutFlatten, String withFlatten) {
        Assert.assertEquals((String)expression, (Object)withoutFlatten, (Object)Parser.parse((String)expression, (ExprMacroTable)ExprMacroTable.nil(), (boolean)false).toString());
        Assert.assertEquals((String)expression, (Object)withFlatten, (Object)Parser.parse((String)expression, (ExprMacroTable)ExprMacroTable.nil(), (boolean)true).toString());
    }

    private void validateParser(String expression, String expected, List<String> identifiers) {
        Expr parsed = Parser.parse((String)expression, (ExprMacroTable)ExprMacroTable.nil());
        Assert.assertEquals((String)expression, (Object)expected, (Object)parsed.toString());
        Assert.assertEquals((String)expression, identifiers, (Object)Parser.findRequiredBindings((Expr)parsed));
    }

    private void validateConstantExpression(String expression, Object expected) {
        Assert.assertEquals((String)expression, (Object)expected, (Object)Parser.parse((String)expression, (ExprMacroTable)ExprMacroTable.nil()).eval(Parser.withMap((Map)ImmutableMap.of())).value());
    }
}

